/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.apis

import io.provenance.eventstream.stream.models.EmptyResponse
import io.provenance.eventstream.stream.models.ErrorResponse

import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import io.provenance.eventstream.stream.infrastructure.ApiClient
import io.provenance.eventstream.stream.infrastructure.ClientException
import io.provenance.eventstream.stream.infrastructure.ClientError
import io.provenance.eventstream.stream.infrastructure.ServerException
import io.provenance.eventstream.stream.infrastructure.ServerError
import io.provenance.eventstream.stream.infrastructure.MultiValueMap
import io.provenance.eventstream.stream.infrastructure.RequestConfig
import io.provenance.eventstream.stream.infrastructure.RequestMethod
import io.provenance.eventstream.stream.infrastructure.ResponseType
import io.provenance.eventstream.stream.infrastructure.Success
import io.provenance.eventstream.stream.infrastructure.toMultiValue

class WebsocketApi(basePath: kotlin.String = defaultBasePath) : ApiClient(basePath) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty("io.provenance.eventstream.stream.baseUrl", "https://rpc.cosmos.network")
        }
    }

    /**
    * Subscribe for events via WebSocket.
    * To tell which events you want, you need to provide a query. query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot; AND \&quot;EXISTS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  Examples:       tm.event &#x3D; &#39;NewBlock&#39;               # new blocks       tm.event &#x3D; &#39;CompleteProposal&#39;       # node got a complete proposal       tm.event &#x3D; &#39;Tx&#39; AND tx.hash &#x3D; &#39;XYZ&#39; # single transaction       tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 5   # all txs of the fifth block       tx.height &#x3D; 5                       # all txs of the fifth block  Tendermint provides a few predefined keys: tm.event, tx.hash and tx.height. Note for transactions, you can define additional keys by providing events with DeliverTx response.  import (     abci \&quot;github.com/tendermint/tendermint/abci/types\&quot;     \&quot;github.com/tendermint/tendermint/libs/pubsub/query\&quot; )  abci.ResponseDeliverTx{   Events: []abci.Event{       {           Type: \&quot;rewards.withdraw\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;address\&quot;), Value: []byte(\&quot;AddrA\&quot;), Index: true},               {Key: []byte(\&quot;source\&quot;), Value: []byte(\&quot;SrcX\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},               {Key: []byte(\&quot;balance\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },       {           Type: \&quot;rewards.withdraw\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;address\&quot;), Value: []byte(\&quot;AddrB\&quot;), Index: true},               {Key: []byte(\&quot;source\&quot;), Value: []byte(\&quot;SrcY\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},               {Key: []byte(\&quot;balance\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },       {           Type: \&quot;transfer\&quot;,           Attributes: abci.EventAttribute{               {Key: []byte(\&quot;sender\&quot;), Value: []byte(\&quot;AddrC\&quot;), Index: true},               {Key: []byte(\&quot;recipient\&quot;), Value: []byte(\&quot;AddrD\&quot;), Index: true},               {Key: []byte(\&quot;amount\&quot;), Value: []byte(\&quot;...\&quot;), Index: true},           },       },   }, }  All events are indexed by a composite key of the form {eventType}.{evenAttrKey}. In the above examples, the following keys would be indexed:    - rewards.withdraw.address    - rewards.withdraw.source    - rewards.withdraw.amount    - rewards.withdraw.balance    - transfer.sender    - transfer.recipient    - transfer.amount  Multiple event types with duplicate keys are allowed and are meant to categorize unique and distinct events. In the above example, all events indexed under the key &#x60;rewards.withdraw.address&#x60; will have the following values stored and queryable:     - AddrA    - AddrB  To create a query for txs where address AddrA withdrew rewards: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrA&#39;\&quot;)  To create a query for txs where address AddrA withdrew rewards from source Y: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrA&#39; AND rewards.withdraw.source &#x3D; &#39;Y&#39;\&quot;)  To create a query for txs where AddrA transferred funds: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND transfer.sender &#x3D; &#39;AddrA&#39;\&quot;)  The following queries would return no results: query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND transfer.sender &#x3D; &#39;AddrZ&#39;\&quot;) query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.address &#x3D; &#39;AddrZ&#39;\&quot;) query.MustParse(\&quot;tm.event &#x3D; &#39;Tx&#39; AND rewards.withdraw.source &#x3D; &#39;W&#39;\&quot;)  See list of all possible events here https://godoc.org/github.com/tendermint/tendermint/types#pkg-constants  For complete query syntax, check out https://godoc.org/github.com/tendermint/tendermint/libs/pubsub/query.  &#x60;&#x60;&#x60;go import rpchttp \&quot;github.com/tendermint/rpc/client/http\&quot; import \&quot;github.com/tendermint/tendermint/types\&quot;  client :&#x3D; rpchttp.New(\&quot;tcp:0.0.0.0:26657\&quot;, \&quot;/websocket\&quot;) err :&#x3D; client.Start() if err !&#x3D; nil {   handle error } defer client.Stop() ctx, cancel :&#x3D; context.WithTimeout(context.Background(), 1 * time.Second) defer cancel() query :&#x3D; \&quot;tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 3\&quot; txs, err :&#x3D; client.Subscribe(ctx, \&quot;test-client\&quot;, query) if err !&#x3D; nil {   handle error }  go func() {  for e :&#x3D; range txs {    fmt.Println(\&quot;got \&quot;, e.Data.(types.EventDataTx))    } }() &#x60;&#x60;&#x60;  NOTE: if you&#39;re not reading events fast enough, Tendermint might terminate the subscription. 
    * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  
    * @return EmptyResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun subscribe(query: kotlin.String) : EmptyResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = subscribeRequestConfig(query = query)

        val localVarResponse = request<Unit, EmptyResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation subscribe
    *
    * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  
    * @return RequestConfig
    */
    fun subscribeRequestConfig(query: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/subscribe",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Unsubscribe from event on Websocket
    * &#x60;&#x60;&#x60;go client :&#x3D; rpchttp.New(\&quot;tcp:0.0.0.0:26657\&quot;, \&quot;/websocket\&quot;) err :&#x3D; client.Start() if err !&#x3D; nil {    handle error } defer client.Stop() query :&#x3D; \&quot;tm.event &#x3D; &#39;Tx&#39; AND tx.height &#x3D; 3\&quot; err &#x3D; client.Unsubscribe(context.Background(), \&quot;test-client\&quot;, query) if err !&#x3D; nil {    handle error } &#x60;&#x60;&#x60; 
    * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  
    * @return EmptyResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun unsubscribe(query: kotlin.String) : EmptyResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = unsubscribeRequestConfig(query = query)

        val localVarResponse = request<Unit, EmptyResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation unsubscribe
    *
    * @param query query is a string, which has a form: \&quot;condition AND condition ...\&quot; (no OR at the moment). condition has a form: \&quot;key operation operand\&quot;. key is a string with a restricted set of possible symbols ( \\t\\n\\r\\\\()\&quot;&#39;&#x3D;&gt;&lt; are not allowed). operation can be \&quot;&#x3D;\&quot;, \&quot;&lt;\&quot;, \&quot;&lt;&#x3D;\&quot;, \&quot;&gt;\&quot;, \&quot;&gt;&#x3D;\&quot;, \&quot;CONTAINS\&quot;. operand can be a string (escaped with single quotes), number, date or time.  
    * @return RequestConfig
    */
    fun unsubscribeRequestConfig(query: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, List<kotlin.String>>()
            .apply {
                put("query", listOf(query.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/unsubscribe",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

    /**
    * Unsubscribe from all events via WebSocket
    * Unsubscribe from all events via WebSocket 
    * @return EmptyResponse
    * @throws UnsupportedOperationException If the API returns an informational or redirection response
    * @throws ClientException If the API returns a client error response
    * @throws ServerException If the API returns a server error response
    */
    @Suppress("UNCHECKED_CAST")
    @Throws(UnsupportedOperationException::class, ClientException::class, ServerException::class)
    suspend fun unsubscribeAll() : EmptyResponse = withContext(Dispatchers.IO) {
        val localVariableConfig = unsubscribeAllRequestConfig()

        val localVarResponse = request<Unit, EmptyResponse>(
            localVariableConfig
        )

        return@withContext when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as EmptyResponse
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
    * To obtain the request config of the operation unsubscribeAll
    *
    * @return RequestConfig
    */
    fun unsubscribeAllRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/unsubscribe_all",
            query = localVariableQuery,
            headers = localVariableHeaders,
            body = localVariableBody
        )
    }

}
