/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.models

import io.provenance.eventstream.stream.models.BlockHeaderVersion
import io.provenance.eventstream.stream.models.BlockID

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass
import java.io.Serializable

/**
 * 
 *
 * @param version 
 * @param chainId 
 * @param height 
 * @param time 
 * @param lastBlockId 
 * @param lastCommitHash 
 * @param dataHash 
 * @param validatorsHash 
 * @param nextValidatorsHash 
 * @param consensusHash 
 * @param appHash 
 * @param lastResultsHash 
 * @param evidenceHash 
 * @param proposerAddress 
 */
@JsonClass(generateAdapter = true)
data class BlockHeader (

    @Json(name = "version")
    var version: BlockHeaderVersion,

    @Json(name = "chain_id")
    var chainId: kotlin.String,

    @Json(name = "height")
    var height: kotlin.Long,

    @Json(name = "time")
    var time: kotlin.String,

    @Json(name = "last_block_id")
    var lastBlockId: BlockID,

    @Json(name = "last_commit_hash")
    var lastCommitHash: kotlin.String,

    @Json(name = "data_hash")
    var dataHash: kotlin.String,

    @Json(name = "validators_hash")
    var validatorsHash: kotlin.String,

    @Json(name = "next_validators_hash")
    var nextValidatorsHash: kotlin.String,

    @Json(name = "consensus_hash")
    var consensusHash: kotlin.String,

    @Json(name = "app_hash")
    var appHash: kotlin.String,

    @Json(name = "last_results_hash")
    var lastResultsHash: kotlin.String,

    @Json(name = "evidence_hash")
    var evidenceHash: kotlin.String,

    @Json(name = "proposer_address")
    var proposerAddress: kotlin.String

) : Serializable {
    companion object {
        private const val serialVersionUID: Long = 123
    }

}

