/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.models

import io.provenance.eventstream.stream.models.BlockResultsResponseResultEvents
import io.provenance.eventstream.stream.models.BlockResultsResponseResultTxsResults
import io.provenance.eventstream.stream.models.BlockResultsResponseResultValidatorUpdates
import io.provenance.eventstream.stream.models.ConsensusParams

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass
import java.io.Serializable

/**
 * 
 *
 * @param height 
 * @param txsResults 
 * @param beginBlockEvents 
 * @param endBlock 
 * @param validatorUpdates 
 * @param consensusParamsUpdates 
 */
@JsonClass(generateAdapter = true)
data class BlockResultsResponseResult (

    @Json(name = "height")
    var height: kotlin.Long,

    @Json(name = "txs_results")
    var txsResults: kotlin.collections.List<BlockResultsResponseResultTxsResults>? = null,

    @Json(name = "begin_block_events")
    var beginBlockEvents: kotlin.collections.List<BlockResultsResponseResultEvents>? = null,

    @Json(name = "end_block")
    var endBlock: kotlin.collections.List<BlockResultsResponseResultEvents>? = null,

    @Json(name = "validator_updates")
    var validatorUpdates: kotlin.collections.List<BlockResultsResponseResultValidatorUpdates>? = null,

    @Json(name = "consensus_params_updates")
    var consensusParamsUpdates: ConsensusParams? = null

) : Serializable {
    companion object {
        private const val serialVersionUID: Long = 123
    }

}

