/**
 * Tendermint RPC
 *
 * Tendermint supports the following RPC protocols:  * URI over HTTP * JSONRPC over HTTP * JSONRPC over websockets  ## Configuration  RPC can be configured by tuning parameters under `[rpc]` table in the `$TMHOME/config/config.toml` file or by using the `--rpc.X` command-line flags.  Default rpc listen address is `tcp://0.0.0.0:26657`. To set another address, set the `laddr` config parameter to desired value. CORS (Cross-Origin Resource Sharing) can be enabled by setting `cors_allowed_origins`, `cors_allowed_methods`, `cors_allowed_headers` config parameters.  ## Arguments  Arguments which expect strings or byte arrays may be passed as quoted strings, like `\"abc\"` or as `0x`-prefixed strings, like `0x616263`.  ## URI/HTTP  A REST like interface.      curl localhost:26657/block?height=5  ## JSONRPC/HTTP  JSONRPC requests can be POST'd to the root RPC endpoint via HTTP.      curl --header \"Content-Type: application/json\" --request POST --data '{\"method\": \"block\", \"params\": [\"5\"], \"id\": 1}' localhost:26657  ## JSONRPC/websockets  JSONRPC requests can be also made via websocket. The websocket endpoint is at `/websocket`, e.g. `localhost:26657/websocket`. Asynchronous RPC functions like event `subscribe` and `unsubscribe` are only available via websockets.  Example using https://github.com/hashrocket/ws:      ws ws://localhost:26657/websocket     > { \"jsonrpc\": \"2.0\", \"method\": \"subscribe\", \"params\": [\"tm.event='NewBlock'\"], \"id\": 1 } 
 *
 * The version of the OpenAPI document: Master
 * 
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package io.provenance.eventstream.stream.models

import io.provenance.eventstream.stream.models.DumpConsensusResponseResultRoundStateLastCommit
import io.provenance.eventstream.stream.models.DumpConsensusResponseResultRoundStateValidators
import io.provenance.eventstream.stream.models.DumpConsensusResponseResultRoundStateVotes

import com.squareup.moshi.Json
import com.squareup.moshi.JsonClass
import java.io.Serializable

/**
 * 
 *
 * @param height 
 * @param round 
 * @param step 
 * @param startTime 
 * @param commitTime 
 * @param validators 
 * @param lockedRound 
 * @param validRound 
 * @param votes 
 * @param commitRound 
 * @param lastCommit 
 * @param lastValidators 
 * @param triggeredTimeoutPrecommit 
 */
@JsonClass(generateAdapter = true)
data class DumpConsensusResponseResultRoundState (

    @Json(name = "height")
    var height: kotlin.Long,

    @Json(name = "round")
    var round: kotlin.Int,

    @Json(name = "step")
    var step: kotlin.Int,

    @Json(name = "start_time")
    var startTime: kotlin.String,

    @Json(name = "commit_time")
    var commitTime: kotlin.String,

    @Json(name = "validators")
    var validators: DumpConsensusResponseResultRoundStateValidators,

    @Json(name = "locked_round")
    var lockedRound: kotlin.Int,

    @Json(name = "valid_round")
    var validRound: kotlin.String,

    @Json(name = "votes")
    var votes: kotlin.collections.List<DumpConsensusResponseResultRoundStateVotes>,

    @Json(name = "commit_round")
    var commitRound: kotlin.Int,

    @Json(name = "last_commit")
    var lastCommit: DumpConsensusResponseResultRoundStateLastCommit?,

    @Json(name = "last_validators")
    var lastValidators: DumpConsensusResponseResultRoundStateValidators,

    @Json(name = "triggered_timeout_precommit")
    var triggeredTimeoutPrecommit: kotlin.Boolean

) : Serializable {
    companion object {
        private const val serialVersionUID: Long = 123
    }

}

