/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.eventstream.observers;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import io.provenance.blockchain.stream.api.BlockSink;
import io.provenance.eventstream.observers.KafkaFileOutputKt;
import io.provenance.eventstream.stream.models.StreamBlock;
import io.provenance.eventstream.stream.models.StreamBlockImpl;
import io.provenance.eventstream.stream.models.extensions.ExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096B\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lio/provenance/eventstream/observers/KafkaFileOutput;", "Lio/provenance/blockchain/stream/api/BlockSink;", "dir", "", "decoder", "Lcom/squareup/moshi/Moshi;", "(Ljava/lang/String;Lcom/squareup/moshi/Moshi;)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "Lio/provenance/eventstream/stream/models/StreamBlockImpl;", "dirname", "Lkotlin/Function1;", "invoke", "", "block", "Lio/provenance/eventstream/stream/models/StreamBlock;", "(Lio/provenance/eventstream/stream/models/StreamBlock;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "es-kafka"})
public final class KafkaFileOutput
implements BlockSink {
    @NotNull
    private final JsonAdapter<StreamBlockImpl> adapter;
    @NotNull
    private final Function1<String, String> dirname;

    public KafkaFileOutput(@NotNull String dir, @NotNull Moshi decoder) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Moshi $this$adapter$iv = decoder;
        boolean $i$f$adapter = false;
        this.adapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(StreamBlockImpl.class));
        this.dirname = (Function1)new Function1<String, String>(dir){
            final /* synthetic */ String $dir;
            {
                this.$dir = $dir;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.$dir + "/" + name;
            }
        };
        new File(dir).mkdirs();
    }

    @Nullable
    public Object invoke(@NotNull StreamBlock block2, @NotNull Continuation<? super Unit> $completion) {
        String string = String.valueOf(block2.getHeight());
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String checksum = KafkaFileOutputKt.access$toHex(ExtensionsKt.sha256((byte[])byArray));
        String splay = StringsKt.take((String)checksum, (int)4);
        String dirname2 = (String)this.dirname.invoke((Object)splay);
        File f = new File(dirname2);
        boolean bl = false;
        if (!f.exists()) {
            f.mkdirs();
        }
        String filename = dirname2 + "/" + StringsKt.padStart((String)String.valueOf(block2.getHeight()), (int)10, (char)'0') + ".json";
        File file = new File(filename);
        if (!file.exists()) {
            String string2 = this.adapter.toJson((Object)KafkaFileOutputKt.access$toStreamBlockImpl(block2));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"adapter.toJson(block.toStreamBlockImpl())");
            FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
        }
        return Unit.INSTANCE;
    }
}

