/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.entity;

import io.provenance.entity.KeyType;
import io.provenance.scope.encryption.crypto.SignerImpl;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.proto.Common;
import java.security.PublicKey;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/provenance/entity/KeyEntity;", "", "keyRefs", "", "Lio/provenance/entity/KeyType;", "Lio/provenance/scope/encryption/model/KeyRef;", "(Ljava/util/Map;)V", "getKeyRefs", "()Ljava/util/Map;", "address", "", "keyType", "isMainNet", "", "getKeyRef", "publicKey", "Ljava/security/PublicKey;", "sign", "", "data", "lib"})
public abstract class KeyEntity {
    @NotNull
    private final Map<KeyType, KeyRef> keyRefs;

    public KeyEntity(@NotNull Map<KeyType, ? extends KeyRef> keyRefs) {
        Intrinsics.checkNotNullParameter(keyRefs, (String)"keyRefs");
        this.keyRefs = keyRefs;
    }

    @NotNull
    protected final Map<KeyType, KeyRef> getKeyRefs() {
        return this.keyRefs;
    }

    @NotNull
    public KeyRef getKeyRef(@NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        KeyRef keyRef = this.keyRefs.get((Object)keyType);
        if (keyRef == null) {
            throw new IllegalArgumentException("No such key type present");
        }
        return keyRef;
    }

    @NotNull
    public byte[] sign(@NotNull KeyType keyType, @NotNull byte[] data) {
        byte[] byArray;
        byte[] byArray2;
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KeyRef keyRef = this.keyRefs.get((Object)keyType);
        if (keyRef == null) {
            byArray2 = null;
        } else {
            SignerImpl signerImpl = keyRef.signer();
            if (signerImpl == null) {
                byArray2 = null;
            } else {
                Common.Signature signature = signerImpl.sign(data);
                if (signature == null) {
                    byArray2 = null;
                } else {
                    String string = signature.getSignature();
                    if (string == null) {
                        byArray2 = null;
                    } else {
                        String string2 = string;
                        byte[] byArray3 = string2.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
                        byArray2 = byArray = byArray3;
                    }
                }
            }
        }
        if (byArray == null) {
            throw new IllegalArgumentException("No such key type present");
        }
        return byArray;
    }

    @NotNull
    public PublicKey publicKey(@NotNull KeyType keyType) {
        PublicKey publicKey;
        PublicKey publicKey2;
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        KeyRef keyRef = this.keyRefs.get((Object)keyType);
        if (keyRef == null) {
            publicKey2 = null;
        } else {
            SignerImpl signerImpl = keyRef.signer();
            publicKey2 = publicKey = signerImpl == null ? null : signerImpl.getPublicKey();
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("No such key type present");
        }
        return publicKey;
    }

    @NotNull
    public String address(@NotNull KeyType keyType, boolean isMainNet) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        KeyRef keyRef = this.keyRefs.get((Object)keyType);
        if (keyRef == null) {
            string2 = null;
        } else {
            PublicKey publicKey = keyRef.getPublicKey();
            string2 = string = publicKey == null ? null : KeyExtensionsKt.getAddress((PublicKey)publicKey, (boolean)isMainNet);
        }
        if (string == null) {
            throw new IllegalArgumentException("No such key type present");
        }
        return string;
    }
}

