/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.plugins.fortanix;

import com.fortanix.sdkms.v1.ApiClient;
import com.fortanix.sdkms.v1.Configuration;
import com.fortanix.sdkms.v1.api.AuthenticationApi;
import com.fortanix.sdkms.v1.api.SignAndVerifyApi;
import com.fortanix.sdkms.v1.auth.ApiKeyAuth;
import com.fortanix.sdkms.v1.auth.Authentication;
import com.fortanix.sdkms.v1.model.AuthResponse;
import io.provenance.core.Plugin;
import io.provenance.entity.KeyEntity;
import io.provenance.entity.KeyType;
import io.provenance.entity.fortanix.FortanixKeyEntity;
import io.provenance.plugins.fortanix.FortanixPluginSpec;
import io.provenance.scope.encryption.ecies.ECUtils;
import io.provenance.scope.encryption.model.SmartKeyRef;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lio/provenance/plugins/fortanix/FortanixPlugin;", "Lio/provenance/core/Plugin;", "()V", "fetch", "Lio/provenance/entity/KeyEntity;", "pluginSpec", "", "supports", "", "lib"})
public final class FortanixPlugin
implements Plugin {
    @Override
    public boolean supports(@NotNull Object pluginSpec) {
        Intrinsics.checkNotNullParameter((Object)pluginSpec, (String)"pluginSpec");
        return pluginSpec instanceof FortanixPluginSpec;
    }

    @Override
    @NotNull
    public KeyEntity fetch(@NotNull Object pluginSpec) {
        ApiClient apiClient;
        Intrinsics.checkNotNullParameter((Object)pluginSpec, (String)"pluginSpec");
        FortanixPluginSpec spec = (FortanixPluginSpec)pluginSpec;
        ApiClient $this$fetch_u24lambda_u2d0 = apiClient = new ApiClient();
        boolean $i$a$-apply-FortanixPlugin$fetch$smartKeyClient$22 = false;
        $this$fetch_u24lambda_u2d0.setBasicAuthString(spec.getApiKey());
        Configuration.setDefaultApiClient((ApiClient)$this$fetch_u24lambda_u2d0);
        AuthResponse authResponse = new AuthenticationApi($this$fetch_u24lambda_u2d0).authorize();
        Authentication authentication = $this$fetch_u24lambda_u2d0.getAuthentication("bearerToken");
        if (authentication == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.fortanix.sdkms.v1.auth.ApiKeyAuth");
        }
        ApiKeyAuth auth = (ApiKeyAuth)authentication;
        auth.setApiKey(authResponse.getAccessToken());
        auth.setApiKeyPrefix("Bearer");
        ApiClient smartKeyClient = apiClient;
        SignAndVerifyApi signAndVerifyApi = new SignAndVerifyApi(smartKeyClient);
        String $i$a$-apply-FortanixPlugin$fetch$smartKeyClient$22 = spec.getEncryptionPublicKey();
        byte[] byArray = $i$a$-apply-FortanixPlugin$fetch$smartKeyClient$22.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        SmartKeyRef encryptionKeyRef = new SmartKeyRef(ECUtils.convertBytesToPublicKey$default((ECUtils)ECUtils.INSTANCE, (byte[])byArray, null, (int)2, null), spec.getUuid(), signAndVerifyApi);
        Pair[] pairArray = spec.getSigningPublicKey();
        byte[] byArray2 = pairArray.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        SmartKeyRef signingKeyRef = new SmartKeyRef(ECUtils.convertBytesToPublicKey$default((ECUtils)ECUtils.INSTANCE, (byte[])byArray2, null, (int)2, null), spec.getUuid(), signAndVerifyApi);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)KeyType.SIGNING), (Object)signingKeyRef), TuplesKt.to((Object)((Object)KeyType.ENCRYPTION), (Object)encryptionKeyRef)};
        return new FortanixKeyEntity(MapsKt.mapOf((Pair[])pairArray));
    }
}

