/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.crypto;

import io.p8e.crypto.Numeric;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J$\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lio/p8e/crypto/Hash;", "", "()V", "hash", "", "input", "algorithm", "", "hmacSha512", "key", "sha256", "sha256hash160", "sha3", "offset", "", "length", "hexInput", "sha3String", "utf8String", "p8e-common"})
public final class Hash {
    @NotNull
    public static final Hash INSTANCE;

    @NotNull
    public final byte[] hash(@Nullable byte[] input, @NotNull String algorithm) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        try {
            String string = algorithm;
            boolean bl = false;
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            MessageDigest digest = MessageDigest.getInstance(string2);
            byte[] byArray2 = digest.digest(input);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest.digest(input)");
            byArray = byArray2;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException("Couldn't find a " + algorithm + " provider", e);
        }
        return byArray;
    }

    @NotNull
    public final String sha3(@NotNull String hexInput) {
        Intrinsics.checkNotNullParameter((Object)hexInput, (String)"hexInput");
        byte[] bytes = Numeric.INSTANCE.hexStringToByteArray(hexInput);
        byte[] result = Hash.sha3$default(this, bytes, 0, 0, 6, null);
        return Numeric.toHexString$default(Numeric.INSTANCE, result, 0, 0, false, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] sha3(@NotNull byte[] input, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Keccak.DigestKeccak kecc = (Keccak.DigestKeccak)new Keccak.Digest256();
        kecc.update(input, offset, length);
        byte[] byArray = kecc.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"kecc.digest()");
        return byArray;
    }

    public static /* synthetic */ byte[] sha3$default(Hash hash, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return hash.sha3(byArray, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final byte[] sha3(@NotNull byte[] input, int offset) {
        return Hash.sha3$default(this, input, offset, 0, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] sha3(@NotNull byte[] input) {
        return Hash.sha3$default(this, input, 0, 0, 6, null);
    }

    @NotNull
    public final String sha3String(@NotNull String utf8String) {
        Intrinsics.checkNotNullParameter((Object)utf8String, (String)"utf8String");
        String string = utf8String;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return Numeric.toHexString$default(Numeric.INSTANCE, Hash.sha3$default(this, byArray, 0, 0, 6, null), 0, 0, false, 14, null);
    }

    @NotNull
    public final byte[] sha256(@Nullable byte[] input) {
        byte[] byArray;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = digest.digest(input);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest.digest(input)");
            byArray = byArray2;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException("Couldn't find a SHA-256 provider", e);
        }
        return byArray;
    }

    @NotNull
    public final byte[] hmacSha512(@Nullable byte[] key, @NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HMac hMac = new HMac((Digest)new SHA512Digest());
        hMac.init((CipherParameters)new KeyParameter(key));
        hMac.update(input, 0, input.length);
        byte[] out = new byte[64];
        hMac.doFinal(out, 0);
        return out;
    }

    @NotNull
    public final byte[] sha256hash160(@Nullable byte[] input) {
        byte[] sha256 = this.sha256(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }

    private Hash() {
    }

    static {
        Hash hash;
        INSTANCE = hash = new Hash();
    }
}

