/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.crypto;

import io.p8e.crypto.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013J \u0010\u0018\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0004J\u0010\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004J.\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001e\u001a\u00020\rH\u0007J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0013J\u0016\u0010 \u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010$\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\bJ \u0010%\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/p8e/crypto/Numeric;", "", "()V", "HEX_PREFIX", "", "asByte", "", "m", "", "n", "cleanHexPrefix", "input", "containsHexPrefix", "", "decodeQuantity", "Ljava/math/BigInteger;", "value", "encodeQuantity", "hexStringToByteArray", "", "isIntegerValue", "Ljava/math/BigDecimal;", "isValidHexQuantity", "prependHexPrefix", "toBigInt", "offset", "length", "hexValue", "toBigIntNoPrefix", "toHexString", "withPrefix", "toHexStringNoPrefix", "toHexStringNoPrefixZeroPadded", "size", "toHexStringWithPrefix", "toHexStringWithPrefixSafe", "toHexStringWithPrefixZeroPadded", "toHexStringZeroPadded", "p8e-common"})
public final class Numeric {
    private static final String HEX_PREFIX = "0x";
    @NotNull
    public static final Numeric INSTANCE;

    @NotNull
    public final String encodeQuantity(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.signum() == -1) {
            throw (Throwable)new IllegalStateException("Negative values are not supported");
        }
        return HEX_PREFIX + value.toString(16);
    }

    @NotNull
    public final BigInteger decodeQuantity(@NotNull String value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.isValidHexQuantity(value)) {
            throw (Throwable)new IllegalStateException("Value must be in format 0x[1-9]+[0-9]* or 0x0");
        }
        try {
            object = value;
            int n = 2;
            boolean bl = false;
            String string = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            object = new BigInteger(string, 16);
        }
        catch (NumberFormatException e) {
            throw (Throwable)new IllegalStateException("Negative ", e);
        }
        return object;
    }

    private final boolean isValidHexQuantity(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() < 3) {
            return false;
        }
        return StringsKt.startsWith$default((String)value, (String)HEX_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public final String cleanHexPrefix(@NotNull String input) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.containsHexPrefix(input)) {
            String string2 = input;
            int n = 2;
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = input;
        }
        return string;
    }

    @NotNull
    public final String prependHexPrefix(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return !this.containsHexPrefix(input) ? HEX_PREFIX + input : input;
    }

    public final boolean containsHexPrefix(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return !Strings.INSTANCE.isEmpty(input) && input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }

    @NotNull
    public final BigInteger toBigInt(@Nullable byte[] value, int offset, int length) {
        return this.toBigInt(Arrays.copyOfRange(value, offset, offset + length));
    }

    @NotNull
    public final BigInteger toBigInt(@Nullable byte[] value) {
        return new BigInteger(1, value);
    }

    @NotNull
    public final BigInteger toBigInt(@NotNull String hexValue) {
        Intrinsics.checkNotNullParameter((Object)hexValue, (String)"hexValue");
        String cleanValue = this.cleanHexPrefix(hexValue);
        return this.toBigIntNoPrefix(cleanValue);
    }

    @NotNull
    public final BigInteger toBigIntNoPrefix(@Nullable String hexValue) {
        return new BigInteger(hexValue, 16);
    }

    @NotNull
    public final String toHexStringWithPrefix(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return HEX_PREFIX + value.toString(16);
    }

    @NotNull
    public final String toHexStringNoPrefix(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString(16)");
        return string;
    }

    @NotNull
    public final String toHexStringNoPrefix(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.toHexString(input, 0, input.length, false);
    }

    @NotNull
    public final String toHexStringWithPrefixZeroPadded(@NotNull BigInteger value, int size) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.toHexStringZeroPadded(value, size, true);
    }

    @NotNull
    public final String toHexStringWithPrefixSafe(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String result = this.toHexStringNoPrefix(value);
        if (result.length() < 2) {
            result = Strings.INSTANCE.zeros(1).toString() + result;
        }
        return HEX_PREFIX + result;
    }

    @NotNull
    public final String toHexStringNoPrefixZeroPadded(@NotNull BigInteger value, int size) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.toHexStringZeroPadded(value, size, false);
    }

    private final String toHexStringZeroPadded(BigInteger value, int size, boolean withPrefix) {
        String result = this.toHexStringNoPrefix(value);
        int length = result.length();
        if (length > size) {
            throw (Throwable)new UnsupportedOperationException("Value " + result + "is larger then length " + size);
        }
        if (value.signum() < 0) {
            throw (Throwable)new UnsupportedOperationException("Value cannot be negative");
        }
        if (length < size) {
            result = Strings.INSTANCE.zeros(size - length).toString() + result;
        }
        return withPrefix ? HEX_PREFIX + result : result;
    }

    @NotNull
    public final byte[] hexStringToByteArray(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String cleanInput = this.cleanHexPrefix(input);
        int len = cleanInput.length();
        if (len == 0) {
            return new byte[0];
        }
        byte[] data = null;
        int startIdx = 0;
        if (len % 2 != 0) {
            data = new byte[len / 2 + 1];
            data[0] = (byte)Character.digit(cleanInput.charAt(0), 16);
            startIdx = 1;
        } else {
            data = new byte[len / 2];
            startIdx = 0;
        }
        for (int i = startIdx; i < len; i += 2) {
            data[(i + 1) / 2] = (byte)((Character.digit(cleanInput.charAt(i), 16) << 4) + Character.digit(cleanInput.charAt(i + 1), 16));
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String toHexString(@NotNull byte[] input, int offset, int length, boolean withPrefix) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StringBuilder stringBuilder = new StringBuilder();
        if (withPrefix) {
            stringBuilder.append(HEX_PREFIX);
        }
        int n = offset;
        int n2 = offset + length;
        while (n < n2) {
            void i;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%02x";
            Object[] objectArray = new Object[1];
            byte by = input[i];
            byte by2 = (byte)255;
            boolean bl = false;
            objectArray[0] = (byte)(by & by2);
            Object[] objectArray2 = objectArray;
            by2 = 0;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            stringBuilder.append(string2);
            ++i;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    public static /* synthetic */ String toHexString$default(Numeric numeric, byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return numeric.toHexString(byArray, n, n2, bl);
    }

    @JvmOverloads
    @NotNull
    public final String toHexString(@NotNull byte[] input, int offset, int length) {
        return Numeric.toHexString$default(this, input, offset, length, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String toHexString(@NotNull byte[] input, int offset) {
        return Numeric.toHexString$default(this, input, offset, 0, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final String toHexString(@NotNull byte[] input) {
        return Numeric.toHexString$default(this, input, 0, 0, false, 14, null);
    }

    public final byte asByte(int m, int n) {
        return (byte)(m << 4 | n);
    }

    public final boolean isIntegerValue(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    private Numeric() {
    }

    static {
        Numeric numeric;
        INSTANCE = numeric = new Numeric();
    }
}

