/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.exception;

import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.p8e.exception.P8eError;
import io.p8e.proto.ContractScope;
import io.p8e.util.AffiliateConnectionException;
import io.p8e.util.AuthenticationException;
import io.p8e.util.ContractDefinitionException;
import io.p8e.util.ContractValidationException;
import io.p8e.util.NotFoundException;
import io.p8e.util.ProtoParseException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0007\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\b\u00a8\u0006\t"}, d2={"isContractRetryable", "", "Lio/p8e/exception/P8eError;", "isEnvelopeSpecRetryable", "message", "", "p8eError", "Lio/p8e/proto/ContractScope$EnvelopeError;", "", "p8e-common"})
public final class ExceptionKt {
    public static final boolean isEnvelopeSpecRetryable(@NotNull P8eError $this$isEnvelopeSpecRetryable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isEnvelopeSpecRetryable, (String)"$this$isEnvelopeSpecRetryable");
        P8eError p8eError = $this$isEnvelopeSpecRetryable;
        if (p8eError instanceof P8eError.AffiliateConnection) {
            bl = false;
        } else if (p8eError instanceof P8eError.Authentication) {
            bl = false;
        } else if (p8eError instanceof P8eError.ContractDefinition) {
            bl = false;
        } else if (p8eError instanceof P8eError.ContractValidation) {
            bl = false;
        } else if (p8eError instanceof P8eError.ProtoParse) {
            bl = false;
        } else if (p8eError instanceof P8eError.NotFound) {
            bl = false;
        } else if (p8eError instanceof P8eError.ExecutionError) {
            bl = false;
        } else if (p8eError instanceof P8eError.PreExecutionError) {
            bl = false;
        } else if (p8eError instanceof P8eError.Unknown) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isContractRetryable(@NotNull P8eError $this$isContractRetryable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isContractRetryable, (String)"$this$isContractRetryable");
        P8eError p8eError = $this$isContractRetryable;
        if (p8eError instanceof P8eError.AffiliateConnection) {
            bl = true;
        } else if (p8eError instanceof P8eError.Authentication) {
            bl = true;
        } else if (p8eError instanceof P8eError.ContractDefinition) {
            bl = false;
        } else if (p8eError instanceof P8eError.ContractValidation) {
            bl = false;
        } else if (p8eError instanceof P8eError.ProtoParse) {
            bl = false;
        } else if (p8eError instanceof P8eError.NotFound) {
            bl = false;
        } else if (p8eError instanceof P8eError.ExecutionError) {
            bl = false;
        } else if (p8eError instanceof P8eError.PreExecutionError) {
            bl = false;
        } else if (p8eError instanceof P8eError.Unknown) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public static final String message(@NotNull P8eError $this$message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        P8eError p8eError = $this$message;
        if (p8eError instanceof P8eError.AffiliateConnection) {
            string = ((P8eError.AffiliateConnection)$this$message).getMessage();
        } else if (p8eError instanceof P8eError.Authentication) {
            string = ((P8eError.Authentication)$this$message).getMessage();
        } else if (p8eError instanceof P8eError.ContractDefinition) {
            string = ((P8eError.ContractDefinition)$this$message).getMessage();
        } else if (p8eError instanceof P8eError.ContractValidation) {
            string = ((P8eError.ContractValidation)$this$message).getMessage();
        } else if (p8eError instanceof P8eError.ProtoParse) {
            string = ((P8eError.ProtoParse)$this$message).getMessage();
        } else if (p8eError instanceof P8eError.NotFound) {
            string = ((P8eError.NotFound)$this$message).getMessage();
        } else if (p8eError instanceof P8eError.ExecutionError) {
            String string2 = ((P8eError.ExecutionError)$this$message).getEnvelopeError().getMessage();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.envelopeError.message");
        } else if (p8eError instanceof P8eError.PreExecutionError) {
            String string3 = ((P8eError.PreExecutionError)$this$message).getT().getMessage();
            if (string3 == null) {
                string3 = ((P8eError.PreExecutionError)$this$message).getT().getClass().getName();
            }
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.t.message ?: this.t.javaClass.name");
        } else if (p8eError instanceof P8eError.Unknown) {
            String string4 = ((P8eError.Unknown)$this$message).getT().getMessage();
            if (string4 == null) {
                string4 = ((P8eError.Unknown)$this$message).getT().getClass().getName();
            }
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this.t.message ?: this.t.javaClass.name");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final P8eError p8eError(@NotNull ContractScope.EnvelopeError $this$p8eError) {
        Intrinsics.checkNotNullParameter((Object)$this$p8eError, (String)"$this$p8eError");
        return new P8eError.ExecutionError($this$p8eError);
    }

    @NotNull
    public static final P8eError p8eError(@NotNull Throwable $this$p8eError) {
        P8eError p8eError;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$p8eError, (String)"$this$p8eError");
        Throwable throwable = $this$p8eError;
        if (throwable instanceof StatusException) {
            io.grpc.Metadata metadata = ((StatusException)$this$p8eError).getTrailers();
            string = metadata != null ? (String)metadata.get(P8eError.Companion.getTRAILER_CLASSNAME_KEY()) : null;
        } else if (throwable instanceof StatusRuntimeException) {
            io.grpc.Metadata metadata = ((StatusRuntimeException)$this$p8eError).getTrailers();
            string = metadata != null ? (String)metadata.get(P8eError.Companion.getTRAILER_CLASSNAME_KEY()) : null;
        } else {
            string = null;
        }
        throwable = string;
        boolean bl = false;
        boolean bl2 = false;
        Throwable classname = throwable;
        boolean bl3 = false;
        Throwable throwable2 = classname;
        if (Intrinsics.areEqual((Object)throwable2, (Object)AffiliateConnectionException.class.getName())) {
            String string2 = $this$p8eError.getMessage();
            if (string2 == null) {
                string2 = "default affiliate connection";
            }
            p8eError = new P8eError.AffiliateConnection(string2);
        } else if (Intrinsics.areEqual((Object)throwable2, (Object)AuthenticationException.class.getName())) {
            String string3 = $this$p8eError.getMessage();
            if (string3 == null) {
                string3 = "default authentication";
            }
            p8eError = new P8eError.Authentication(string3);
        } else if (Intrinsics.areEqual((Object)throwable2, (Object)ContractDefinitionException.class.getName())) {
            String string4 = $this$p8eError.getMessage();
            if (string4 == null) {
                string4 = "default contract definition";
            }
            p8eError = new P8eError.ContractDefinition(string4);
        } else if (Intrinsics.areEqual((Object)throwable2, (Object)ContractValidationException.class.getName())) {
            String string5 = $this$p8eError.getMessage();
            if (string5 == null) {
                string5 = "default contract validation";
            }
            p8eError = new P8eError.ContractValidation(string5);
        } else if (Intrinsics.areEqual((Object)throwable2, (Object)ProtoParseException.class.getName())) {
            String string6 = $this$p8eError.getMessage();
            if (string6 == null) {
                string6 = "default proto parse";
            }
            p8eError = new P8eError.ProtoParse(string6);
        } else if (Intrinsics.areEqual((Object)throwable2, (Object)NotFoundException.class.getName())) {
            String string7 = $this$p8eError.getMessage();
            if (string7 == null) {
                string7 = "default not found";
            }
            p8eError = new P8eError.NotFound(string7);
        } else {
            p8eError = new P8eError.Unknown($this$p8eError);
        }
        return p8eError;
    }
}

