/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.grpc.client;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.p8e.grpc.Constant;
import io.p8e.grpc.client.AuthenticationClient;
import io.p8e.proto.Authentication;
import io.p8e.util.ByteStringExtensionsKt;
import io.p8e.util.CryptoExtensionsKt;
import io.p8e.util.DateExtensionsKt;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.Signature;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000bH\u0002JL\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u000f\"\b\b\u0000\u0010\u0010*\u00020\u0012\"\b\b\u0001\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/p8e/grpc/client/ChallengeResponseInterceptor;", "Lio/grpc/ClientInterceptor;", "keyPair", "Ljava/security/KeyPair;", "authenticationClient", "Lio/p8e/grpc/client/AuthenticationClient;", "toleranceSeconds", "", "(Ljava/security/KeyPair;Lio/p8e/grpc/client/AuthenticationClient;J)V", "jwt", "Ljava/util/concurrent/atomic/AtomicReference;", "", "kotlin.jvm.PlatformType", "authenticate", "interceptCall", "Lio/grpc/ClientCall;", "ReqT", "RespT", "", "method", "Lio/grpc/MethodDescriptor;", "callOptions", "Lio/grpc/CallOptions;", "next", "Lio/grpc/Channel;", "isExpired", "", "p8e-common"})
public final class ChallengeResponseInterceptor
implements ClientInterceptor {
    private final AtomicReference<String> jwt;
    private final KeyPair keyPair;
    private final AuthenticationClient authenticationClient;
    private final long toleranceSeconds;

    @NotNull
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(@NotNull MethodDescriptor<ReqT, RespT> method, @NotNull CallOptions callOptions, @NotNull Channel next) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)callOptions, (String)"callOptions");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (ClientCall)new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(this, next, method, callOptions, next.newCall(method, callOptions)){
            final /* synthetic */ ChallengeResponseInterceptor this$0;
            final /* synthetic */ Channel $next;
            final /* synthetic */ MethodDescriptor $method;
            final /* synthetic */ CallOptions $callOptions;

            /*
             * WARNING - void declaration
             */
            public void start(@NotNull ClientCall.Listener<RespT> responseListener, @NotNull io.grpc.Metadata headers) {
                Intrinsics.checkNotNullParameter(responseListener, (String)"responseListener");
                Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
                if (Constant.INSTANCE.getJWT_CTX_KEY().get() == null) {
                    void it;
                    V v = ChallengeResponseInterceptor.access$getJwt$p(this.this$0).get();
                    boolean bl = false;
                    boolean bl2 = false;
                    String string = (String)v;
                    Metadata.Key<String> key = Constant.INSTANCE.getJWT_METADATA_KEY();
                    io.grpc.Metadata metadata = headers;
                    boolean bl3 = false;
                    void v0 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
                    CharSequence charSequence = (CharSequence)v0;
                    boolean bl4 = false;
                    boolean bl5 = charSequence.length() > 0 && !ChallengeResponseInterceptor.access$isExpired(this.this$0, (String)it);
                    String string2 = (String)(bl5 ? v : null);
                    if (string2 == null) {
                        string2 = ChallengeResponseInterceptor.access$authenticate(this.this$0);
                    }
                    metadata.put(key, (Object)string2);
                }
                super.start(responseListener, headers);
            }
            {
                this.this$0 = this$0;
                this.$next = $captured_local_variable$1;
                this.$method = $captured_local_variable$2;
                this.$callOptions = $captured_local_variable$3;
                super($super_call_param$4);
            }
        };
    }

    private final String authenticate() {
        String randomStr = UUID.randomUUID().toString() + System.currentTimeMillis();
        Authentication.AuthenticationToken.Builder builder = Authentication.AuthenticationToken.newBuilder().setRandomData(ByteStringExtensionsKt.toByteString((String)randomStr));
        OffsetDateTime offsetDateTime = OffsetDateTime.now().plusSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"OffsetDateTime.now().plusSeconds(10)");
        Authentication.AuthenticationToken token = builder.setExpiration(DateExtensionsKt.toProtoTimestampProv((OffsetDateTime)offsetDateTime)).build();
        Signature signature = Signature.getInstance(Constant.INSTANCE.getJWT_ALGORITHM());
        boolean bl = false;
        boolean bl2 = false;
        Signature $this$apply = signature;
        boolean bl3 = false;
        $this$apply.initSign(this.keyPair.getPrivate());
        $this$apply.update(token.toByteArray());
        bl = false;
        bl2 = false;
        Signature it = signature;
        boolean bl4 = false;
        byte[] signature2 = it.sign();
        Authentication.AuthenticationRequest.Builder builder2 = Authentication.AuthenticationRequest.newBuilder();
        PublicKey publicKey = this.keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.public");
        Authentication.AuthenticationRequest.Builder builder3 = builder2.setPublicKey(CryptoExtensionsKt.toPublicKeyProto((PublicKey)publicKey));
        Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"signature");
        Authentication.AuthenticationRequest authenticationRequest = builder3.setSignature(ByteStringExtensionsKt.toByteString((byte[])signature2)).setToken(token).build();
        Intrinsics.checkNotNullExpressionValue((Object)authenticationRequest, (String)"Authentication.Authentic\u2026\n                .build()");
        Authentication.Jwt jwtResponse = this.authenticationClient.authenticate(authenticationRequest);
        String string = jwtResponse.getToken();
        AtomicReference<String> atomicReference = this.jwt;
        boolean bl5 = false;
        boolean bl6 = false;
        String p1 = string;
        boolean bl7 = false;
        atomicReference.set(p1);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jwtResponse.token.also(jwt::set)");
        return string2;
    }

    private final boolean isExpired(String $this$isExpired) {
        DecodedJWT decodedJWT = JWT.decode((String)$this$isExpired);
        Intrinsics.checkNotNullExpressionValue((Object)decodedJWT, (String)"JWT.decode(this)");
        return decodedJWT.getExpiresAt().toInstant().atOffset(ZoneOffset.UTC).minusSeconds(this.toleranceSeconds).isBefore(OffsetDateTime.now());
    }

    public ChallengeResponseInterceptor(@NotNull KeyPair keyPair, @NotNull AuthenticationClient authenticationClient, long toleranceSeconds) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)authenticationClient, (String)"authenticationClient");
        this.keyPair = keyPair;
        this.authenticationClient = authenticationClient;
        this.toleranceSeconds = toleranceSeconds;
        this.jwt = new AtomicReference<String>("");
    }

    public /* synthetic */ ChallengeResponseInterceptor(KeyPair keyPair, AuthenticationClient authenticationClient, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 3L;
        }
        this(keyPair, authenticationClient, l);
    }

    public static final /* synthetic */ AtomicReference access$getJwt$p(ChallengeResponseInterceptor $this) {
        return $this.jwt;
    }

    public static final /* synthetic */ boolean access$isExpired(ChallengeResponseInterceptor $this, String $this$access_u24isExpired) {
        return $this.isExpired($this$access_u24isExpired);
    }

    public static final /* synthetic */ String access$authenticate(ChallengeResponseInterceptor $this) {
        return $this.authenticate();
    }
}

