/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.grpc.client;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import io.p8e.grpc.client.ChallengeResponseInterceptor;
import io.p8e.grpc.client.GrpcRetry;
import io.p8e.proto.ContractScope;
import io.p8e.proto.Envelope;
import io.p8e.proto.EnvelopeServiceGrpc;
import io.p8e.util.UuidExtensionsKt;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/p8e/grpc/client/EnvelopeClient;", "", "channel", "Lio/grpc/ManagedChannel;", "interceptor", "Lio/p8e/grpc/client/ChallengeResponseInterceptor;", "deadlineMs", "", "(Lio/grpc/ManagedChannel;Lio/p8e/grpc/client/ChallengeResponseInterceptor;J)V", "blockingClient", "Lio/p8e/proto/EnvelopeServiceGrpc$EnvelopeServiceBlockingStub;", "kotlin.jvm.PlatformType", "eventClient", "Lio/p8e/proto/EnvelopeServiceGrpc$EnvelopeServiceStub;", "cancelByExecutionUuid", "Lio/p8e/proto/ContractScope$Envelope;", "executionUuid", "Ljava/util/UUID;", "message", "", "event", "Lio/grpc/stub/StreamObserver;", "Lio/p8e/proto/Envelope$EnvelopeEvent;", "inObserver", "execute", "request", "getAllByGroupUuid", "Lio/p8e/proto/ContractScope$EnvelopeCollection;", "groupUuid", "getByExecutionUuid", "getScopeByExecutionUuid", "Lio/p8e/proto/ContractScope$Scope;", "rejectByExecutionUuid", "p8e-common"})
public final class EnvelopeClient {
    private final EnvelopeServiceGrpc.EnvelopeServiceBlockingStub blockingClient;
    private final EnvelopeServiceGrpc.EnvelopeServiceStub eventClient;
    private final long deadlineMs;

    @NotNull
    public final ContractScope.EnvelopeCollection getAllByGroupUuid(@NotNull UUID groupUuid) {
        Intrinsics.checkNotNullParameter((Object)groupUuid, (String)"groupUuid");
        ContractScope.EnvelopeCollection envelopeCollection = ((EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)this.blockingClient.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).getAllByGroupUuid(UuidExtensionsKt.toProtoUuidProv((UUID)groupUuid));
        Intrinsics.checkNotNullExpressionValue((Object)envelopeCollection, (String)"blockingClient.withDeadl\u2026upUuid.toProtoUuidProv())");
        return envelopeCollection;
    }

    @NotNull
    public final ContractScope.Envelope getByExecutionUuid(@NotNull UUID executionUuid) {
        Intrinsics.checkNotNullParameter((Object)executionUuid, (String)"executionUuid");
        ContractScope.Envelope envelope = ((EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)this.blockingClient.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).getByExecutionUuid(UuidExtensionsKt.toProtoUuidProv((UUID)executionUuid));
        Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"blockingClient.withDeadl\u2026onUuid.toProtoUuidProv())");
        return envelope;
    }

    @NotNull
    public final ContractScope.Scope getScopeByExecutionUuid(@NotNull UUID executionUuid) {
        Intrinsics.checkNotNullParameter((Object)executionUuid, (String)"executionUuid");
        ContractScope.Scope scope = ((EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)this.blockingClient.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).getScopeByExecutionUuid(UuidExtensionsKt.toProtoUuidProv((UUID)executionUuid));
        Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"blockingClient.withDeadl\u2026onUuid.toProtoUuidProv())");
        return scope;
    }

    @NotNull
    public final ContractScope.Envelope rejectByExecutionUuid(@NotNull UUID executionUuid, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)executionUuid, (String)"executionUuid");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ContractScope.Envelope envelope = ((EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)this.blockingClient.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).rejectByExecutionUuid(Envelope.RejectCancel.newBuilder().setExecutionUuid(UuidExtensionsKt.toProtoUuidProv((UUID)executionUuid)).setMessage(message).build());
        Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"blockingClient.withDeadl\u2026   .build()\n            )");
        return envelope;
    }

    @NotNull
    public final ContractScope.Envelope cancelByExecutionUuid(@NotNull UUID executionUuid, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)executionUuid, (String)"executionUuid");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ContractScope.Envelope envelope = ((EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)this.blockingClient.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).cancelByExecutionUuid(Envelope.RejectCancel.newBuilder().setExecutionUuid(UuidExtensionsKt.toProtoUuidProv((UUID)executionUuid)).setMessage(message).build());
        Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"blockingClient.withDeadl\u2026   .build()\n            )");
        return envelope;
    }

    @NotNull
    public final StreamObserver<Envelope.EnvelopeEvent> event(@NotNull StreamObserver<Envelope.EnvelopeEvent> inObserver) {
        Intrinsics.checkNotNullParameter(inObserver, (String)"inObserver");
        StreamObserver streamObserver = this.eventClient.event(inObserver);
        Intrinsics.checkNotNullExpressionValue((Object)streamObserver, (String)"eventClient.event(inObserver)");
        return streamObserver;
    }

    @NotNull
    public final Envelope.EnvelopeEvent execute(@NotNull Envelope.EnvelopeEvent request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = GrpcRetry.unavailableBackoff$default(GrpcRetry.INSTANCE, 0, 0, 0.0, (Function0)new Function0<Envelope.EnvelopeEvent>(this, request){
            final /* synthetic */ EnvelopeClient this$0;
            final /* synthetic */ Envelope.EnvelopeEvent $request;

            public final Envelope.EnvelopeEvent invoke() {
                return ((EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)EnvelopeClient.access$getBlockingClient$p(this.this$0).withDeadlineAfter(EnvelopeClient.access$getDeadlineMs$p(this.this$0), TimeUnit.MILLISECONDS)).execute(this.$request);
            }
            {
                this.this$0 = envelopeClient;
                this.$request = envelopeEvent;
                super(0);
            }
        }, 7, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GrpcRetry.unavailableBac\u2026xecute(request)\n        }");
        return (Envelope.EnvelopeEvent)object;
    }

    public EnvelopeClient(@NotNull ManagedChannel channel, @NotNull ChallengeResponseInterceptor interceptor, long deadlineMs) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        this.deadlineMs = deadlineMs;
        this.blockingClient = (EnvelopeServiceGrpc.EnvelopeServiceBlockingStub)EnvelopeServiceGrpc.newBlockingStub((Channel)((Channel)channel)).withInterceptors(new ClientInterceptor[]{interceptor});
        this.eventClient = (EnvelopeServiceGrpc.EnvelopeServiceStub)EnvelopeServiceGrpc.newStub((Channel)((Channel)channel)).withInterceptors(new ClientInterceptor[]{interceptor});
    }

    public static final /* synthetic */ EnvelopeServiceGrpc.EnvelopeServiceBlockingStub access$getBlockingClient$p(EnvelopeClient $this) {
        return $this.blockingClient;
    }

    public static final /* synthetic */ long access$getDeadlineMs$p(EnvelopeClient $this) {
        return $this.deadlineMs;
    }
}

