/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.grpc.client;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.p8e.grpc.client.ChallengeResponseInterceptor;
import io.p8e.proto.Common;
import io.p8e.proto.ObjectGrpc;
import io.p8e.proto.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/p8e/grpc/client/ObjectClient;", "", "channel", "Lio/grpc/ManagedChannel;", "challengeResponseInterceptor", "Lio/p8e/grpc/client/ChallengeResponseInterceptor;", "deadlineMs", "", "(Lio/grpc/ManagedChannel;Lio/p8e/grpc/client/ChallengeResponseInterceptor;J)V", "client", "Lio/p8e/proto/ObjectGrpc$ObjectBlockingStub;", "kotlin.jvm.PlatformType", "load", "", "uri", "", "loadJson", "hash", "className", "contractSpecHash", "store", "Lio/p8e/proto/Common$Location;", "withAudience", "Lio/p8e/proto/Common$WithAudience;", "p8e-common"})
public final class ObjectClient {
    private final ObjectGrpc.ObjectBlockingStub client;
    private final long deadlineMs;

    @NotNull
    public final Common.Location store(@NotNull Common.WithAudience withAudience) {
        Intrinsics.checkNotNullParameter((Object)withAudience, (String)"withAudience");
        Common.Location location = ((ObjectGrpc.ObjectBlockingStub)this.client.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).store(withAudience);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"client.withDeadlineAfter\u2026     .store(withAudience)");
        return location;
    }

    @NotNull
    public final byte[] load(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Objects.ObjectLoadResponse objectLoadResponse = ((ObjectGrpc.ObjectBlockingStub)this.client.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).load(Objects.ObjectLoadRequest.newBuilder().setUri(uri).build());
        Intrinsics.checkNotNullExpressionValue((Object)objectLoadResponse, (String)"client.withDeadlineAfter\u2026   .build()\n            )");
        byte[] byArray = objectLoadResponse.getBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"client.withDeadlineAfter\u2026    ).bytes.toByteArray()");
        return byArray;
    }

    @NotNull
    public final String loadJson(@NotNull String hash, @NotNull String className, @NotNull String contractSpecHash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)contractSpecHash, (String)"contractSpecHash");
        Objects.ObjectLoadJsonResponse objectLoadJsonResponse = ((ObjectGrpc.ObjectBlockingStub)this.client.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS)).loadJson(Objects.ObjectLoadJsonRequest.newBuilder().setHash(hash).setClassname(className).setContractSpecHash(contractSpecHash).build());
        Intrinsics.checkNotNullExpressionValue((Object)objectLoadJsonResponse, (String)"client.withDeadlineAfter\u2026   .build()\n            )");
        String string = objectLoadJsonResponse.getJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"client.withDeadlineAfter\u2026uild()\n            ).json");
        return string;
    }

    public ObjectClient(@NotNull ManagedChannel channel, @NotNull ChallengeResponseInterceptor challengeResponseInterceptor, long deadlineMs) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)challengeResponseInterceptor, (String)"challengeResponseInterceptor");
        this.deadlineMs = deadlineMs;
        this.client = (ObjectGrpc.ObjectBlockingStub)ObjectGrpc.newBlockingStub((Channel)((Channel)channel)).withInterceptors(new ClientInterceptor[]{challengeResponseInterceptor});
    }
}

