/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.grpc.observers;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.p8e.grpc.observers.EndState;
import io.p8e.grpc.observers.ExceptionState;
import io.p8e.grpc.observers.NullState;
import io.provenance.p8e.shared.extension.LoggerExtensionsKt;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\bJ\u0013\u0010\f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lio/p8e/grpc/observers/QueueingStreamObserverSender;", "T", "Ljava/lang/Runnable;", "streamObserver", "Lio/grpc/stub/StreamObserver;", "(Lio/grpc/stub/StreamObserver;)V", "end", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/p8e/grpc/observers/EndState;", "errorQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "queue", "getStreamObserver", "()Lio/grpc/stub/StreamObserver;", "close", "", "state", "error", "sre", "Lio/grpc/StatusRuntimeException;", "isClosed", "", "lastEndState", "value", "(Ljava/lang/Object;)V", "run", "Companion", "p8e-common"})
public final class QueueingStreamObserverSender<T>
implements Runnable {
    private final ConcurrentLinkedQueue<T> queue;
    private final ConcurrentLinkedQueue<Throwable> errorQueue;
    private final AtomicReference<EndState> end;
    @NotNull
    private final StreamObserver<T> streamObserver;
    private static final AtomicInteger threadsRunning;
    private static final AtomicInteger totalThreadsStarted;
    @NotNull
    public static final Companion Companion;

    @Override
    public void run() {
        while (true) {
            if (this.isClosed()) {
                this.streamObserver.onCompleted();
                break;
            }
            Throwable error = this.errorQueue.poll();
            if (error != null) {
                this.streamObserver.onError(error);
                this.close(new ExceptionState(error));
                break;
            }
            T value = this.queue.poll();
            if (value != null) {
                this.streamObserver.onNext(value);
            }
            Thread.sleep(10L);
        }
    }

    public final void queue(T value) {
        this.queue.add(value);
    }

    public final void error(@NotNull StatusRuntimeException sre) {
        Intrinsics.checkNotNullParameter((Object)((Object)sre), (String)"sre");
        this.errorQueue.add(sre);
    }

    public final void close(@NotNull EndState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.end.set(state);
    }

    @NotNull
    public final EndState lastEndState() {
        EndState endState = this.end.get();
        Intrinsics.checkNotNullExpressionValue((Object)endState, (String)"end.get()");
        return endState;
    }

    public final boolean isClosed() {
        return Intrinsics.areEqual((Object)this.end.get(), (Object)NullState.INSTANCE) ^ true;
    }

    @NotNull
    public final StreamObserver<T> getStreamObserver() {
        return this.streamObserver;
    }

    public QueueingStreamObserverSender(@NotNull StreamObserver<T> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        this.streamObserver = streamObserver;
        this.queue = new ConcurrentLinkedQueue();
        this.errorQueue = new ConcurrentLinkedQueue();
        this.end = new AtomicReference<NullState>(NullState.INSTANCE);
        QueueingStreamObserverSender $this$logger$iv = this;
        boolean $i$f$logger = false;
        KClass clazz$iv$iv = Reflection.getOrCreateKotlinClass(QueueingStreamObserverSender.class);
        boolean $i$f$logger2 = false;
        LoggerExtensionsKt.logger((String)KClassesJvm.getJvmName((KClass)clazz$iv$iv)).info("Starting QueuingStreamObserverSender Thread: threadCount " + threadsRunning.incrementAndGet());
        Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("QueuingStreamObserverSender-" + totalThreadsStarted.incrementAndGet()), (int)0, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.run();
                QueueingStreamObserverSender $this$logger$iv = this;
                boolean $i$f$logger = false;
                KClass clazz$iv$iv = Reflection.getOrCreateKotlinClass(QueueingStreamObserverSender.class);
                boolean $i$f$logger2 = false;
                LoggerExtensionsKt.logger((String)KClassesJvm.getJvmName((KClass)clazz$iv$iv)).info("Ending QueuingStreamObserverSender Thread: threadCount " + threadsRunning.decrementAndGet());
            }
        }), (int)23, null);
        boolean bl = false;
        boolean bl2 = false;
        Thread it = thread;
        boolean bl3 = false;
        it.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ QueueingStreamObserverSender this$0;
            {
                this.this$0 = queueingStreamObserverSender;
            }

            public final void uncaughtException(Thread t, Throwable e) {
                QueueingStreamObserverSender $this$logger$iv = this.this$0;
                boolean $i$f$logger = false;
                KClass clazz$iv$iv = Reflection.getOrCreateKotlinClass(QueueingStreamObserverSender.class);
                boolean $i$f$logger2 = false;
                LoggerExtensionsKt.logger((String)KClassesJvm.getJvmName((KClass)clazz$iv$iv)).info("(Exception) Ending QueuingStreamObserverSender Thread: threadCount " + QueueingStreamObserverSender.access$getThreadsRunning$cp().decrementAndGet());
            }
        });
    }

    static {
        Companion = new Companion(null);
        threadsRunning = new AtomicInteger(0);
        totalThreadsStarted = new AtomicInteger(0);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/p8e/grpc/observers/QueueingStreamObserverSender$Companion;", "", "()V", "threadsRunning", "Ljava/util/concurrent/atomic/AtomicInteger;", "totalThreadsStarted", "p8e-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

