/*
 * Decompiled with CFR 0.152.
 */
package io.p8e.util.feign;

import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import io.p8e.util.feign.RetryAfterDecoder;
import io.p8e.util.feign.WrappedFeignException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/p8e/util/feign/BodyErrorDecoder;", "Lfeign/codec/ErrorDecoder;", "()V", "retryAfterDecoder", "Lio/p8e/util/feign/RetryAfterDecoder;", "decode", "Ljava/lang/Exception;", "methodKey", "", "response", "Lfeign/Response;", "Companion", "p8e-common"})
public final class BodyErrorDecoder
implements ErrorDecoder {
    private final RetryAfterDecoder retryAfterDecoder = new RetryAfterDecoder(null, 1, null);
    @NotNull
    private static final String RETRY_HEADER;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Exception decode(@NotNull String methodKey, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)methodKey, (String)"methodKey");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        byte[] byArray = response.body().asInputStream().readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"response.body()\n        \u2026          .readAllBytes()");
        byte[] byArray2 = byArray;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        boolean bl2 = false;
        String body = new String(byArray2, (Charset)object);
        int n = response.status();
        String string = "status " + response.status() + " reading " + methodKey + "\n message: " + body;
        object = body;
        Charset charset = Charsets.UTF_8;
        bl2 = false;
        byte[] byArray3 = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        WrappedFeignException exception = new WrappedFeignException(n, string, byArray3);
        Collection collection = (Collection)response.headers().get(RETRY_HEADER);
        Date retryAfter = this.retryAfterDecoder.apply(collection != null ? (String)CollectionsKt.firstOrNull((Iterable)collection) : null);
        return retryAfter != null ? (Exception)new RetryableException(exception.status(), exception.getMessage(), response.request().httpMethod(), (Throwable)((Object)exception), retryAfter) : (Exception)((Object)exception);
    }

    static {
        Companion = new Companion(null);
        RETRY_HEADER = "Retry-After";
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/p8e/util/feign/BodyErrorDecoder$Companion;", "", "()V", "RETRY_HEADER", "", "getRETRY_HEADER", "()Ljava/lang/String;", "errorStatus", "Lfeign/FeignException;", "status", "", "message", "body", "", "p8e-common"})
    public static final class Companion {
        @NotNull
        public final String getRETRY_HEADER() {
            return RETRY_HEADER;
        }

        private final FeignException errorStatus(int status, String message, byte[] body) {
            switch (status) {
                case 400: {
                    return (FeignException)new FeignException.BadRequest(message, body);
                }
                case 401: {
                    return (FeignException)new FeignException.Unauthorized(message, body);
                }
                case 403: {
                    return (FeignException)new FeignException.Forbidden(message, body);
                }
                case 404: {
                    return (FeignException)new FeignException.NotFound(message, body);
                }
                case 405: {
                    return (FeignException)new FeignException.MethodNotAllowed(message, body);
                }
                case 406: {
                    return (FeignException)new FeignException.NotAcceptable(message, body);
                }
                case 409: {
                    return (FeignException)new FeignException.Conflict(message, body);
                }
                case 410: {
                    return (FeignException)new FeignException.Gone(message, body);
                }
                case 415: {
                    return (FeignException)new FeignException.UnsupportedMediaType(message, body);
                }
                case 429: {
                    return (FeignException)new FeignException.TooManyRequests(message, body);
                }
                case 422: {
                    return (FeignException)new FeignException.UnprocessableEntity(message, body);
                }
                case 500: {
                    return (FeignException)new FeignException.InternalServerError(message, body);
                }
                case 501: {
                    return (FeignException)new FeignException.NotImplemented(message, body);
                }
                case 502: {
                    return (FeignException)new FeignException.BadGateway(message, body);
                }
                case 503: {
                    return (FeignException)new FeignException.ServiceUnavailable(message, body);
                }
                case 504: {
                    return (FeignException)new FeignException.GatewayTimeout(message, body);
                }
            }
            return new WrappedFeignException(status, message, body);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

