/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.engine.crypto;

import com.google.common.io.BaseEncoding;
import io.provenance.engine.crypto.Bech32;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u001d"}, d2={"Lio/provenance/engine/crypto/Bech32Data;", "", "hrp", "", "fiveBitData", "", "(Ljava/lang/String;[B)V", "address", "getAddress", "()Ljava/lang/String;", "checksum", "getChecksum", "()[B", "data", "getData", "getFiveBitData", "hexData", "kotlin.jvm.PlatformType", "getHexData", "getHrp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "p8e-common"})
public final class Bech32Data {
    @NotNull
    private final byte[] data;
    private final String hexData;
    @NotNull
    private final String address;
    @NotNull
    private final byte[] checksum;
    @NotNull
    private final String hrp;
    @NotNull
    private final byte[] fiveBitData;

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public final String getHexData() {
        return this.hexData;
    }

    @NotNull
    public final String getAddress() {
        return this.address;
    }

    @NotNull
    public final byte[] getChecksum() {
        return this.checksum;
    }

    @NotNull
    public String toString() {
        return "bech32 : " + this.address + "\nhuman: " + this.hrp + " \nbytes: " + this.hexData;
    }

    @NotNull
    public final String getHrp() {
        return this.hrp;
    }

    @NotNull
    public final byte[] getFiveBitData() {
        return this.fiveBitData;
    }

    public Bech32Data(@NotNull String hrp, @NotNull byte[] fiveBitData) {
        Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
        Intrinsics.checkNotNullParameter((Object)fiveBitData, (String)"fiveBitData");
        this.hrp = hrp;
        this.fiveBitData = fiveBitData;
        this.data = Bech32.Companion.convertBits(this.fiveBitData, 5, 8, false);
        this.hexData = BaseEncoding.base16().encode(this.data);
        this.address = Bech32.Companion.encode(this.hrp, this.fiveBitData);
        this.checksum = Bech32.Companion.checksum(this.hrp, ArraysKt.toTypedArray((byte[])this.fiveBitData));
    }

    @NotNull
    public final String component1() {
        return this.hrp;
    }

    @NotNull
    public final byte[] component2() {
        return this.fiveBitData;
    }

    @NotNull
    public final Bech32Data copy(@NotNull String hrp, @NotNull byte[] fiveBitData) {
        Intrinsics.checkNotNullParameter((Object)hrp, (String)"hrp");
        Intrinsics.checkNotNullParameter((Object)fiveBitData, (String)"fiveBitData");
        return new Bech32Data(hrp, fiveBitData);
    }

    public static /* synthetic */ Bech32Data copy$default(Bech32Data bech32Data, String string, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = bech32Data.hrp;
        }
        if ((n & 2) != 0) {
            byArray = bech32Data.fiveBitData;
        }
        return bech32Data.copy(string, byArray);
    }

    public int hashCode() {
        String string = this.hrp;
        return (string != null ? string.hashCode() : 0) * 31 + (this.fiveBitData != null ? Arrays.hashCode(this.fiveBitData) : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Bech32Data)) break block3;
                Bech32Data bech32Data = (Bech32Data)object;
                if (!Intrinsics.areEqual((Object)this.hrp, (Object)bech32Data.hrp) || !Intrinsics.areEqual((Object)this.fiveBitData, (Object)bech32Data.fiveBitData)) break block3;
            }
            return true;
        }
        return false;
    }
}

