/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.engine.crypto;

import java.math.BigInteger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.crypto.SignKt;
import org.kethereum.crypto.api.ec.ECDSASignature;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0001\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"HALF_CURVE_ORDER", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "ZERO", "", "encodeAsBTC", "", "Lorg/kethereum/crypto/api/ec/ECDSASignature;", "getUnsignedBytes", "p8e-common"})
public final class SignatureFormatterKt {
    public static final byte ZERO = 0;
    private static final BigInteger HALF_CURVE_ORDER = SignKt.getCURVE().getN().shiftRight(1);

    @NotNull
    public static final byte[] encodeAsBTC(@NotNull ECDSASignature $this$encodeAsBTC) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeAsBTC, (String)"$this$encodeAsBTC");
        BigInteger sigS = $this$encodeAsBTC.getS();
        if (sigS.compareTo(HALF_CURVE_ORDER) > 0) {
            BigInteger bigInteger = SignKt.getCURVE().getN().subtract(sigS);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"CURVE.n.subtract(sigS)");
            sigS = bigInteger;
        }
        byte[] sBytes = SignatureFormatterKt.getUnsignedBytes(sigS);
        byte[] rBytes = SignatureFormatterKt.getUnsignedBytes($this$encodeAsBTC.getR());
        boolean bl = rBytes.length <= 32;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "cannot encode r into BTC Format, size overflow (" + rBytes.length + " > 32)";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = sBytes.length <= 32;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "cannot encode s into BTC Format, size overflow (" + sBytes.length + " > 32)";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] signature = new byte[64];
        System.arraycopy(rBytes, 0, signature, 32 - rBytes.length, rBytes.length);
        System.arraycopy(sBytes, 0, signature, 64 - sBytes.length, sBytes.length);
        return signature;
    }

    @NotNull
    public static final byte[] getUnsignedBytes(@NotNull BigInteger $this$getUnsignedBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$getUnsignedBytes, (String)"$this$getUnsignedBytes");
        byte[] bytes = $this$getUnsignedBytes.toByteArray();
        if (bytes[0] == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            return CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])bytes, (int)1));
        }
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return bytes;
    }
}

