/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.provenance.metadata.v1.Record;
import io.provenance.metadata.v1.RecordOutput;
import io.provenance.metadata.v1.RecordWrapper;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.scope.ContractEngine;
import io.provenance.scope.ContractEngineKt;
import io.provenance.scope.ContractValidatorsKt;
import io.provenance.scope.ContractWrapper;
import io.provenance.scope.Function;
import io.provenance.scope.ResultSetter;
import io.provenance.scope.classloader.ClassLoaderCache;
import io.provenance.scope.classloader.MemoryClassLoader;
import io.provenance.scope.contract.proto.Commons;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.contract.proto.Specifications;
import io.provenance.scope.contract.spec.P8eContract;
import io.provenance.scope.definition.DefinitionService;
import io.provenance.scope.encryption.crypto.SignerImpl;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.objectstore.client.CachedOsClient;
import io.provenance.scope.objectstore.client.ObjectHash;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.util.ClassLoaderExtensionsKt;
import io.provenance.scope.util.ContractDefinitionException;
import io.provenance.scope.util.EnvelopeExtensionsKt;
import io.provenance.scope.util.ExtensionsKt;
import io.provenance.scope.util.ProtoUtil;
import io.provenance.scope.util.WithoutLoggingKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015JF\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002JF\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160*2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J!\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/provenance/scope/ContractEngine;", "", "osClient", "Lio/provenance/scope/objectstore/client/CachedOsClient;", "disableContractLogs", "", "(Lio/provenance/scope/objectstore/client/CachedOsClient;Z)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "failResult", "Lio/provenance/scope/contract/proto/Contracts$ExecutionResult;", "t", "", "handle", "Lio/provenance/scope/contract/proto/Envelopes$Envelope;", "encryptionKeyRef", "Lio/provenance/scope/encryption/model/KeyRef;", "signingKeyRef", "envelope", "affiliateSharePublicKeys", "", "Ljava/security/PublicKey;", "internalRun", "contract", "Lio/provenance/scope/contract/proto/Contracts$Contract;", "memoryClassLoader", "Lio/provenance/scope/classloader/MemoryClassLoader;", "shares", "spec", "Lio/provenance/scope/contract/proto/Specifications$ContractSpec;", "loadAllClasses", "", "definitionService", "Lio/provenance/scope/definition/DefinitionService;", "signAndStore", "Lcom/google/common/util/concurrent/ListenableFuture;", "name", "", "message", "Lcom/google/protobuf/Message;", "audience", "", "scope", "Lio/provenance/metadata/v1/ScopeResponse;", "withConfigurableLogging", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "engine"})
@SourceDebugExtension(value={"SMAP\nContractEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractEngine.kt\nio/provenance/scope/ContractEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n3190#2,10:290\n1549#2:300\n1620#2,3:301\n1549#2:304\n1620#2,3:305\n1549#2:308\n1620#2,3:309\n1549#2:313\n1620#2,3:314\n1855#2,2:317\n1360#2:319\n1446#2,5:320\n1549#2:325\n1620#2,3:326\n1549#2:329\n1620#2,3:330\n1549#2:333\n1620#2,3:334\n1855#2,2:337\n1#3:312\n*S KotlinDebug\n*F\n+ 1 ContractEngine.kt\nio/provenance/scope/ContractEngine\n*L\n130#1:290,10\n132#1:300\n132#1:301,3\n136#1:304\n136#1:305,3\n174#1:308\n174#1:309,3\n186#1:313\n186#1:314,3\n187#1:317,2\n190#1:319\n190#1:320,5\n191#1:325\n191#1:326,3\n211#1:329\n211#1:330,3\n219#1:333\n219#1:334,3\n220#1:337,2\n*E\n"})
public final class ContractEngine {
    @NotNull
    private final CachedOsClient osClient;
    private final boolean disableContractLogs;
    private final Logger log;

    public ContractEngine(@NotNull CachedOsClient osClient, boolean disableContractLogs) {
        Intrinsics.checkNotNullParameter((Object)osClient, (String)"osClient");
        this.osClient = osClient;
        this.disableContractLogs = disableContractLogs;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ ContractEngine(CachedOsClient cachedOsClient, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(cachedOsClient, bl);
    }

    private final <T> T withConfigurableLogging(Function0<? extends T> block) {
        return (T)(this.disableContractLogs ? WithoutLoggingKt.withoutLogging(block) : block.invoke());
    }

    @NotNull
    public final Envelopes.Envelope handle(@NotNull KeyRef encryptionKeyRef, @NotNull KeyRef signingKeyRef, @NotNull Envelopes.Envelope envelope, @NotNull Collection<? extends PublicKey> affiliateSharePublicKeys) {
        Intrinsics.checkNotNullParameter((Object)encryptionKeyRef, (String)"encryptionKeyRef");
        Intrinsics.checkNotNullParameter((Object)signingKeyRef, (String)"signingKeyRef");
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        Intrinsics.checkNotNullParameter(affiliateSharePublicKeys, (String)"affiliateSharePublicKeys");
        this.log.trace("Running contract engine");
        Contracts.Contract contract2 = envelope.getContract();
        String string = contract2.getSpec().getDataLocation().getClassname();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassname(...)");
        String string2 = contract2.getSpec().getDataLocation().getRef().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHash(...)");
        Object object = this.osClient.getRecord(string, UtilKt.base64Decode((String)string2), encryptionKeyRef).get();
        Specifications.ContractSpec contractSpec = object instanceof Specifications.ContractSpec ? (Specifications.ContractSpec)object : null;
        if (contractSpec == null) {
            throw new ContractDefinitionException("Spec stored at contract.spec.dataLocation is not of type " + Specifications.ContractSpec.class.getName());
        }
        Specifications.ContractSpec spec = contractSpec;
        String string3 = spec.getDefinition().getResourceLocation().getRef().getHash();
        String string4 = contract2.getDefinition().getResourceLocation().getRef().getHash();
        List list = spec.getFunctionSpecsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFunctionSpecsList(...)");
        String classLoaderKey = string3 + "-" + string4 + "-" + ((Specifications.FunctionSpec)CollectionsKt.first((List)list)).getOutputSpec().getSpec().getResourceLocation().getRef().getHash();
        MemoryClassLoader memoryClassLoader = (MemoryClassLoader)ClassLoaderCache.INSTANCE.getClassLoaderCache().get((Object)classLoaderKey, ContractEngine::handle$lambda$0);
        Intrinsics.checkNotNull((Object)memoryClassLoader);
        return (Envelopes.Envelope)ClassLoaderExtensionsKt.forThread((ClassLoader)memoryClassLoader, (Function0)((Function0)new Function0<Envelopes.Envelope>(this, contract2, envelope, encryptionKeyRef, signingKeyRef, memoryClassLoader, affiliateSharePublicKeys, spec){
            final /* synthetic */ ContractEngine this$0;
            final /* synthetic */ Contracts.Contract $contract;
            final /* synthetic */ Envelopes.Envelope $envelope;
            final /* synthetic */ KeyRef $encryptionKeyRef;
            final /* synthetic */ KeyRef $signingKeyRef;
            final /* synthetic */ MemoryClassLoader $memoryClassLoader;
            final /* synthetic */ Collection<PublicKey> $affiliateSharePublicKeys;
            final /* synthetic */ Specifications.ContractSpec $spec;
            {
                this.this$0 = $receiver;
                this.$contract = $contract;
                this.$envelope = $envelope;
                this.$encryptionKeyRef = $encryptionKeyRef;
                this.$signingKeyRef = $signingKeyRef;
                this.$memoryClassLoader = $memoryClassLoader;
                this.$affiliateSharePublicKeys = $affiliateSharePublicKeys;
                this.$spec = $spec;
                super(0);
            }

            @NotNull
            public final Envelopes.Envelope invoke() {
                Contracts.Contract contract2 = this.$contract;
                Intrinsics.checkNotNullExpressionValue((Object)contract2, (String)"$contract");
                MemoryClassLoader memoryClassLoader = this.$memoryClassLoader;
                Intrinsics.checkNotNullExpressionValue((Object)memoryClassLoader, (String)"$memoryClassLoader");
                return ContractEngine.access$internalRun(this.this$0, contract2, this.$envelope, this.$encryptionKeyRef, this.$signingKeyRef, memoryClassLoader, this.$affiliateSharePublicKeys, this.$spec);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Envelopes.Envelope internalRun(Contracts.Contract contract2, Envelopes.Envelope envelope, KeyRef encryptionKeyRef, KeyRef signingKeyRef, MemoryClassLoader memoryClassLoader, Collection<? extends PublicKey> shares, Specifications.ContractSpec spec) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object element$iv3;
        void $this$forEach$iv;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        Class clazz;
        DefinitionService definitionService = new DefinitionService(this.osClient, memoryClassLoader);
        SignerImpl signer = signingKeyRef.signer();
        ScopeResponse scope = EnvelopeExtensionsKt.scopeOrNull((Envelopes.Envelope)envelope);
        try {
            Commons.DefinitionSpec definitionSpec = spec.getDefinition();
            Intrinsics.checkNotNullExpressionValue((Object)definitionSpec, (String)"getDefinition(...)");
            clazz = DefinitionService.loadClass$default(definitionService, encryptionKeyRef, definitionSpec, null, 4, null);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                throw new ContractDefinitionException(StringsKt.trimIndent((String)("\n                        Unable to load contract jar. Verify that you're using a jar that has been bootstrapped.\n                        [classname: " + spec.getDefinition().getResourceLocation().getClassname() + "]\n                        [public key: " + UtilKt.toHex((PublicKey)encryptionKeyRef.getPublicKey()) + "]\n                        [hash: " + spec.getDefinition().getResourceLocation().getRef().getHash() + "]\n                    ")));
            }
            throw e;
        }
        Class contractSpecClass = clazz;
        this.loadAllClasses(encryptionKeyRef, definitionService, spec);
        ContractValidatorsKt.validateAgainst(contract2, spec);
        Contracts.Contract.Builder contractBuilder = contract2.toBuilder();
        Intrinsics.checkNotNull((Object)contractBuilder);
        ContractWrapper contractWrapper = new ContractWrapper(contractSpecClass, encryptionKeyRef, definitionService, this.osClient, contractBuilder, this.disableContractLogs);
        Iterable $this$partition$iv = contractWrapper.getFunctions();
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Function it = (Function)element$iv2;
            boolean bl = false;
            if (it.canExecute()) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List execList = (List)pair.component1();
        List skipList = (List)pair.component2();
        first$iv = skipList;
        Object object = this.log;
        boolean $i$f$map22 = false;
        Iterator iterator = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            void it;
            Iterator iterator2 = (Function)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFact().name());
        }
        object.trace("Skipped Records: " + (List)destination$iv$iv);
        Iterable $i$f$map22 = execList;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            Pair pair2;
            void function;
            Function bl = (Function)item$iv$iv3;
            object = destination$iv$iv2;
            boolean bl2 = false;
            try {
                pair2 = (Pair)this.withConfigurableLogging((Function0)new Function0<Pair<? extends Contracts.ConsiderationProto.Builder, ? extends Message>>((Function<P8eContract>)function){
                    final /* synthetic */ Function<P8eContract> $function;
                    {
                        this.$function = $function;
                        super(0);
                    }

                    @NotNull
                    public final Pair<Contracts.ConsiderationProto.Builder, Message> invoke() {
                        return this.$function.invoke();
                    }
                });
            }
            catch (Throwable t) {
                this.log.error("Error executing condition " + contractWrapper.getContractClass() + "." + function.getMethod().getName() + " [Exception classname: " + t.getClass().getName() + "]", t);
                function.getConsiderationBuilder().setResult(this.failResult(t));
                Contracts.Contract contractForSignature = contractBuilder.build();
                Envelopes.Envelope.Builder builder = envelope.toBuilder().setContract(contractForSignature);
                Intrinsics.checkNotNull((Object)contractForSignature);
                Envelopes.Envelope envelope2 = builder.addSignatures(signer.sign((Message)contractForSignature)).build();
                Intrinsics.checkNotNullExpressionValue((Object)envelope2, (String)"build(...)");
                return envelope2;
            }
            Pair pair3 = pair2;
            Contracts.ConsiderationProto.Builder considerationBuilder = (Contracts.ConsiderationProto.Builder)pair3.component1();
            Message result = (Message)pair3.component2();
            if (result == null) {
                throw new ContractDefinitionException(StringsKt.trimIndent((String)("\n                                Invoked function returned null instead of type " + Message.class.getName() + "\n                                [class: " + contractWrapper.getContractClass().getName() + "]\n                                [invoked function: " + function.getMethod().getName() + "]\n                            ")));
            }
            object.add(new ResultSetter((Function0<? extends ListenableFuture<Unit>>)((Function0)new Function0<ListenableFuture<Unit>>(this, (Function<P8eContract>)function, result, contract2, scope, shares, encryptionKeyRef, signingKeyRef, considerationBuilder){
                final /* synthetic */ ContractEngine this$0;
                final /* synthetic */ Function<P8eContract> $function;
                final /* synthetic */ Message $result;
                final /* synthetic */ Contracts.Contract $contract;
                final /* synthetic */ ScopeResponse $scope;
                final /* synthetic */ Collection<PublicKey> $shares;
                final /* synthetic */ KeyRef $encryptionKeyRef;
                final /* synthetic */ KeyRef $signingKeyRef;
                final /* synthetic */ Contracts.ConsiderationProto.Builder $considerationBuilder;
                {
                    this.this$0 = $receiver;
                    this.$function = $function;
                    this.$result = $result;
                    this.$contract = $contract;
                    this.$scope = $scope;
                    this.$shares = $shares;
                    this.$encryptionKeyRef = $encryptionKeyRef;
                    this.$signingKeyRef = $signingKeyRef;
                    this.$considerationBuilder = $considerationBuilder;
                    super(0);
                }

                @NotNull
                public final ListenableFuture<Unit> invoke() {
                    ListenableFuture listenableFuture = ContractEngine.access$signAndStore(this.this$0, this.$function.getFact().name(), this.$result, ContractEngineKt.toAudience(this.$contract, this.$scope, this.$shares), this.$encryptionKeyRef, this.$signingKeyRef, this.$scope);
                    Contracts.ConsiderationProto.Builder builder = this.$considerationBuilder;
                    ListenableFuture signFuture = listenableFuture;
                    boolean bl = false;
                    ListenableFuture listenableFuture2 = Futures.transform((ListenableFuture)signFuture, arg_0 -> internalRun.functionResults.1.2.invoke$lambda$1$lambda$0((Function1)new Function1<Contracts.ExecutionResult, Unit>(builder){
                        final /* synthetic */ Contracts.ConsiderationProto.Builder $considerationBuilder;
                        {
                            this.$considerationBuilder = $considerationBuilder;
                            super(1);
                        }

                        public final void invoke(Contracts.ExecutionResult it) {
                            this.$considerationBuilder.setResult(it);
                        }
                    }, arg_0), (Executor)MoreExecutors.directExecutor());
                    Intrinsics.checkNotNullExpressionValue((Object)listenableFuture2, (String)"let(...)");
                    return listenableFuture2;
                }

                private static final Unit invoke$lambda$1$lambda$0(Function1 $tmp0, Object input) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Unit)$tmp0.invoke(input);
                }
            })));
        }
        $this$map$iv2 = skipList;
        object = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            Function function = (Function)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new ResultSetter((Function0<? extends ListenableFuture<Unit>>)((Function0)new Function0<ListenableFuture<Unit>>((Function<P8eContract>)function){
                final /* synthetic */ Function<P8eContract> $function;
                {
                    this.$function = $function;
                    super(0);
                }

                @NotNull
                public final ListenableFuture<Unit> invoke() {
                    this.$function.getConsiderationBuilder().getResultBuilder().setResult(Contracts.ExecutionResult.Result.SKIP).getOutputBuilder().setName(this.$function.getFact().name()).setClassname(this.$function.getReturnType().getName());
                    ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
                    return listenableFuture;
                }
            })));
        }
        List functionResults2 = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv2));
        Iterable it = $this$map$iv2 = functionResults2;
        boolean $i$a$-also-ContractEngine$internalRun$42 = false;
        this.log.trace("Saving " + it.size() + " results for ContractEngine.handle");
        $i$f$map = false;
        Iterable $i$a$-also-ContractEngine$internalRun$42 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        item$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            void it2;
            Object item$iv$iv3;
            item$iv$iv3 = item$iv$iv2.next();
            ResultSetter function = (ResultSetter)item$iv$iv3;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add((ListenableFuture)it2.getSetter().invoke());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            ListenableFuture it3 = (ListenableFuture)element$iv3;
            boolean bl = false;
            it3.get();
        }
        Contracts.Contract contractForSignature = contractBuilder.build();
        List list = contractForSignature.getConsiderationsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConsiderationsList(...)");
        Iterable $i$f$forEach22 = list;
        object = this.log;
        boolean $i$f$flatMap = false;
        element$iv3 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Contracts.ConsiderationProto it4 = (Contracts.ConsiderationProto)element$iv$iv;
            boolean bl = false;
            List list2 = it4.getInputsList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInputsList(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        object.trace("Inputs list for execution: " + (List)destination$iv$iv3);
        List list3 = contractForSignature.getConsiderationsList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getConsiderationsList(...)");
        $this$flatMap$iv = list3;
        object = this.log;
        boolean $i$f$map3 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void it5;
            Contracts.ConsiderationProto list$iv$iv = (Contracts.ConsiderationProto)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it5.getResult().getOutput());
        }
        object.trace("Outputs list for execution: " + (List)destination$iv$iv3);
        Envelopes.Envelope.Builder builder = envelope.toBuilder().setContract(contractForSignature);
        Intrinsics.checkNotNull((Object)contractForSignature);
        Envelopes.Envelope envelope3 = builder.addSignatures(signer.sign((Message)contractForSignature)).build();
        Intrinsics.checkNotNullExpressionValue((Object)envelope3, (String)"build(...)");
        return envelope3;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAllClasses(KeyRef encryptionKeyRef, DefinitionService definitionService, Specifications.ContractSpec spec) {
        void $this$forEach$iv;
        Pair definition;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object = new Commons.DefinitionSpec[]{spec.getDefinition()};
        Object $this$loadAllClasses_u24lambda_u2410 = object = CollectionsKt.mutableListOf((Object[])object);
        boolean $i$a$-apply-ContractEngine$loadAllClasses$22 = false;
        List list = spec.getFunctionSpecsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFunctionSpecsList(...)");
        $this$loadAllClasses_u24lambda_u2410.add(((Specifications.FunctionSpec)CollectionsKt.first((List)list)).getOutputSpec().getSpec());
        object = (Iterable)object;
        boolean $i$f$map = false;
        void $i$a$-apply-ContractEngine$loadAllClasses$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Commons.DefinitionSpec definitionSpec = (Commons.DefinitionSpec)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Commons.Location $this$loadAllClasses_u24lambda_u2412_u24lambda_u2411 = definition.getResourceLocation();
            boolean bl2 = false;
            String string = $this$loadAllClasses_u24lambda_u2412_u24lambda_u2411.getRef().getHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
            collection.add(TuplesKt.to((Object)$this$loadAllClasses_u24lambda_u2412_u24lambda_u2411, (Object)this.osClient.getJar(UtilKt.base64Decode((String)string), encryptionKeyRef)));
        }
        $this$map$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            definition = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Commons.Location resourceLocation = (Commons.Location)definition.component1();
            ListenableFuture future = (ListenableFuture)definition.component2();
            collection.add(TuplesKt.to((Object)resourceLocation, (Object)future.get()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Commons.Location location = (Commons.Location)pair.component1();
            InputStream inputStream = (InputStream)pair.component2();
            String string = location.getRef().getHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
            Intrinsics.checkNotNull((Object)inputStream);
            definitionService.addJar(string, inputStream);
        }
    }

    private final ListenableFuture<Contracts.ExecutionResult> signAndStore(String name, Message message, Set<? extends PublicKey> audience, KeyRef encryptionKeyRef, KeyRef signingKeyRef, ScopeResponse scope) {
        ListenableFuture putResponse = CachedOsClient.putRecord$default((CachedOsClient)this.osClient, (Message)message, (KeyRef)signingKeyRef, (KeyRef)encryptionKeyRef, audience, null, (boolean)false, (boolean)false, (int)112, null);
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)putResponse, arg_0 -> ContractEngine.signAndStore$lambda$15((Function1)new Function1<ObjectHash, Contracts.ExecutionResult>(scope, name, message){
            final /* synthetic */ ScopeResponse $scope;
            final /* synthetic */ String $name;
            final /* synthetic */ Message $message;
            {
                this.$scope = $scope;
                this.$name = $name;
                this.$message = $message;
                super(1);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Contracts.ExecutionResult invoke(ObjectHash it) {
                block4: {
                    v0 = it;
                    Intrinsics.checkNotNull((Object)v0);
                    sha512 = v0.getValue();
                    var4_3 = this.$scope;
                    if (var4_3 == null || (var5_4 = var4_3.getRecordsList()) == null) ** GOTO lbl-1000
                    var6_5 = var5_4;
                    $i$f$map = false;
                    var8_8 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var13_14 = (RecordWrapper)item$iv$iv;
                        var15_17 = destination$iv$iv;
                        $i$a$-map-ContractEngine$signAndStore$1$ancestorHash$1 = false;
                        var15_17.add(it.getRecord());
                    }
                    var7_7 = (List)destination$iv$iv;
                    var8_8 = this.$name;
                    var9_9 = var7_7;
                    for (Iterator<T> var11_12 : var9_9) {
                        it = (Record)var11_12 /* !! */ ;
                        $i$a$-find-ContractEngine$signAndStore$1$ancestorHash$2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)var8_8)) continue;
                        v1 /* !! */  = var11_12 /* !! */ ;
                        break block4;
                    }
                    v1 /* !! */  = null;
                }
                var6_5 = (Record)v1 /* !! */ ;
                if (var6_5 != null && (var7_7 = var6_5.getOutputsList()) != null && (var8_8 = (RecordOutput)CollectionsKt.first((List)var7_7)) != null) {
                    v2 = var8_8.getHash();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                ancestorHash = v2;
                v3 = Contracts.ExecutionResult.newBuilder().setResult(Contracts.ExecutionResult.Result.PASS);
                v4 = this.$message.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getName(...)");
                v5 /* !! */  = this.$scope;
                return v3.setOutput(ProtoUtil.INSTANCE.proposedRecordOf(this.$name, sha512, v4, v5 /* !! */  != null && (v5 /* !! */  = v5 /* !! */ .getScope()) != null && (v5 /* !! */  = v5 /* !! */ .getScopeIdInfo()) != null && (v5 /* !! */  = v5 /* !! */ .getScopeUuid()) != null ? ExtensionsKt.toUuid((String)v5 /* !! */ ) : null, ancestorHash)).build();
            }
        }, arg_0), (Executor)MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(...)");
        return listenableFuture;
    }

    private final Contracts.ExecutionResult failResult(Throwable t) {
        Contracts.ExecutionResult executionResult = Contracts.ExecutionResult.newBuilder().setResult(Contracts.ExecutionResult.Result.FAIL).setErrorMessage(ExtensionsKt.toMessageWithStackTrace((Throwable)t)).build();
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"build(...)");
        return executionResult;
    }

    private static final MemoryClassLoader handle$lambda$0() {
        return new MemoryClassLoader("", new ByteArrayInputStream(new byte[0]), false, 4, null);
    }

    private static final Contracts.ExecutionResult signAndStore$lambda$15(Function1 $tmp0, Object input) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Contracts.ExecutionResult)$tmp0.invoke(input);
    }

    public static final /* synthetic */ Envelopes.Envelope access$internalRun(ContractEngine $this, Contracts.Contract contract2, Envelopes.Envelope envelope, KeyRef encryptionKeyRef, KeyRef signingKeyRef, MemoryClassLoader memoryClassLoader, Collection shares, Specifications.ContractSpec spec) {
        return $this.internalRun(contract2, envelope, encryptionKeyRef, signingKeyRef, memoryClassLoader, shares, spec);
    }

    public static final /* synthetic */ ListenableFuture access$signAndStore(ContractEngine $this, String name, Message message, Set audience, KeyRef encryptionKeyRef, KeyRef signingKeyRef, ScopeResponse scope) {
        return $this.signAndStore(name, message, audience, encryptionKeyRef, signingKeyRef, scope);
    }
}

