/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope;

import arrow.core.Either;
import com.google.protobuf.Message;
import io.provenance.scope.RecordInstance;
import io.provenance.scope.contract.annotations.Input;
import io.provenance.scope.contract.annotations.Record;
import io.provenance.scope.contract.annotations.SkipIfRecordExists;
import io.provenance.scope.contract.proto.Commons;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.spec.P8eContract;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.objectstore.client.CachedOsClient;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.util.ContractDefinitionException;
import io.provenance.scope.util.ProtoUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010%\u001a\u00020\"J.\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u00020(2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J<\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0017\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00040-H\u0086\u0002J\u0018\u0010.\u001a\n \u001e*\u0004\u0018\u00010/0/2\u0006\u00100\u001a\u000201H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\t\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001c\u001a\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u001d0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lio/provenance/scope/Function;", "T", "Lio/provenance/scope/contract/spec/P8eContract;", "Lkotlin/Function;", "Lcom/google/protobuf/Message;", "encryptionKeyRef", "Lio/provenance/scope/encryption/model/KeyRef;", "osClient", "Lio/provenance/scope/objectstore/client/CachedOsClient;", "contract", "considerationBuilder", "Lio/provenance/scope/contract/proto/Contracts$ConsiderationProto$Builder;", "method", "Ljava/lang/reflect/Method;", "records", "", "Lio/provenance/scope/RecordInstance;", "(Lio/provenance/scope/encryption/model/KeyRef;Lio/provenance/scope/objectstore/client/CachedOsClient;Lio/provenance/scope/contract/spec/P8eContract;Lio/provenance/scope/contract/proto/Contracts$ConsiderationProto$Builder;Ljava/lang/reflect/Method;Ljava/util/List;)V", "getConsiderationBuilder", "()Lio/provenance/scope/contract/proto/Contracts$ConsiderationProto$Builder;", "Lio/provenance/scope/contract/spec/P8eContract;", "fact", "Lio/provenance/scope/contract/annotations/Record;", "getFact", "()Lio/provenance/scope/contract/annotations/Record;", "getMethod", "()Ljava/lang/reflect/Method;", "methodParameters", "returnType", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "getReturnType", "()Ljava/lang/Class;", "skipBecauseRecordAlreadyExists", "", "getSkipBecauseRecordAlreadyExists", "()Z", "canExecute", "getFunctionParameterFact", "parameter", "Ljava/lang/reflect/Parameter;", "proposed", "getFunctionParameters", "considerationProto", "invoke", "Lkotlin/Pair;", "proposedRecordToDef", "Lio/provenance/scope/contract/proto/Commons$DefinitionSpec;", "proposedRecord", "Lio/provenance/scope/contract/proto/Contracts$ProposedRecord;", "engine"})
@SourceDebugExtension(value={"SMAP\nFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Function.kt\nio/provenance/scope/Function\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n1#2:125\n1#2:142\n37#3,2:126\n1549#4:128\n1620#4,3:129\n1549#4:145\n1620#4,3:146\n11383#5,9:132\n13309#5:141\n13310#5:143\n11392#5:144\n*S KotlinDebug\n*F\n+ 1 Function.kt\nio/provenance/scope/Function\n*L\n80#1:142\n55#1:126,2\n66#1:128\n66#1:129,3\n86#1:145\n86#1:146,3\n80#1:132,9\n80#1:141\n80#1:143\n80#1:144\n*E\n"})
public final class Function<T extends P8eContract>
implements kotlin.Function<Message> {
    @NotNull
    private final KeyRef encryptionKeyRef;
    @NotNull
    private final T contract;
    @NotNull
    private final Contracts.ConsiderationProto.Builder considerationBuilder;
    @NotNull
    private final Method method;
    @NotNull
    private final Record fact;
    private final boolean skipBecauseRecordAlreadyExists;
    private final Class<?> returnType;
    @NotNull
    private final List<Message> methodParameters;

    /*
     * WARNING - void declaration
     */
    public Function(@NotNull KeyRef encryptionKeyRef, @NotNull CachedOsClient osClient, @NotNull T contract2, @NotNull Contracts.ConsiderationProto.Builder considerationBuilder, @NotNull Method method, @NotNull List<RecordInstance> records) {
        RecordInstance recordInstance;
        Intrinsics.checkNotNullParameter((Object)encryptionKeyRef, (String)"encryptionKeyRef");
        Intrinsics.checkNotNullParameter((Object)osClient, (String)"osClient");
        Intrinsics.checkNotNullParameter(contract2, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)considerationBuilder, (String)"considerationBuilder");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(records, (String)"records");
        this.encryptionKeyRef = encryptionKeyRef;
        this.contract = contract2;
        this.considerationBuilder = considerationBuilder;
        this.method = method;
        Record record = this.method.getAnnotation(Record.class);
        if (record == null) {
            throw new ContractDefinitionException(this.contract.getClass().getName() + "." + this.method.getName() + " must have the " + Record.class.getName() + " annotation.");
        }
        this.fact = record;
        Function function = this;
        SkipIfRecordExists skipIfRecordExists = this.method.getAnnotation(SkipIfRecordExists.class);
        if (skipIfRecordExists != null) {
            Object v2;
            Function function2;
            block4: {
                SkipIfRecordExists skipIfRecordExists2 = skipIfRecordExists;
                function2 = function;
                boolean bl = false;
                Iterable iterable = records;
                for (Object t : iterable) {
                    void it;
                    RecordInstance record2 = (RecordInstance)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)record2.getName(), (Object)it.name())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            recordInstance = v2;
            function = function2;
        } else {
            recordInstance = null;
        }
        function.skipBecauseRecordAlreadyExists = recordInstance != null;
        this.returnType = this.method.getReturnType();
        this.methodParameters = this.getFunctionParameters(this.encryptionKeyRef, this.considerationBuilder, this.method, records, osClient);
    }

    @NotNull
    public final Contracts.ConsiderationProto.Builder getConsiderationBuilder() {
        return this.considerationBuilder;
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final Record getFact() {
        return this.fact;
    }

    public final boolean getSkipBecauseRecordAlreadyExists() {
        return this.skipBecauseRecordAlreadyExists;
    }

    public final Class<?> getReturnType() {
        return this.returnType;
    }

    public final boolean canExecute() {
        return this.methodParameters.size() == this.method.getParameters().length && !this.skipBecauseRecordAlreadyExists;
    }

    @NotNull
    public final Pair<Contracts.ConsiderationProto.Builder, Message> invoke() {
        Collection $this$toTypedArray$iv = this.methodParameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Message[] messageArray = thisCollection$iv.toArray(new Message[0]);
        Object object = this.method.invoke(this.contract, (Object[])Arrays.copyOf(messageArray, messageArray.length));
        return TuplesKt.to((Object)this.considerationBuilder, (Object)(object instanceof Message ? (Message)object : null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Message> getFunctionParameters(KeyRef encryptionKeyRef, Contracts.ConsiderationProto.Builder considerationProto, Method method, List<RecordInstance> records, CachedOsClient osClient) {
        void $this$mapNotNullTo$iv$iv;
        int n;
        Collection collection;
        Object[] $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = considerationProto.getInputsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputsList(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void proposedFact;
            Contracts.ProposedRecord proposedRecord = (Contracts.ProposedRecord)t;
            collection = destination$iv$iv;
            n = 0;
            void p0 = proposedFact;
            boolean bl = false;
            Commons.DefinitionSpec contractSpec = this.proposedRecordToDef((Contracts.ProposedRecord)p0);
            String string = contractSpec.getResourceLocation().getClassname();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassname(...)");
            String string2 = contractSpec.getResourceLocation().getRef().getHash();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHash(...)");
            Message message = (Message)osClient.getRecord(string, UtilKt.base64Decode((String)string2), encryptionKeyRef).get();
            String string3 = proposedFact.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            collection.add(new RecordInstance(string3, message.getClass(), (Either<? extends Message, ? extends List<? extends Message>>)((Either)new Either.Left((Object)message))));
        }
        List proposed = (List)destination$iv$iv;
        Parameter[] parameterArray = method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Object $this$mapNotNull$iv = parameterArray;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        n = ((void)$this$forEach$iv$iv$iv).length;
        for (int proposedFact = 0; proposedFact < n; ++proposedFact) {
            RecordInstance it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[proposedFact];
            boolean bl2 = false;
            Parameter parameter = (Parameter)element$iv$iv;
            boolean bl22 = false;
            Intrinsics.checkNotNull((Object)parameter);
            if (this.getFunctionParameterFact(parameter, records, proposed) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            RecordInstance proposedFact = (RecordInstance)t;
            collection = destination$iv$iv;
            boolean bl3 = false;
            Either<Message, List<Message>> either = it.getMessageOrCollection();
            Intrinsics.checkNotNull(either, (String)"null cannot be cast to non-null type arrow.core.Either.Left<com.google.protobuf.Message>");
            collection.add((Message)((Either.Left)either).getValue());
        }
        return (List)destination$iv$iv;
    }

    private final RecordInstance getFunctionParameterFact(Parameter parameter, List<RecordInstance> records, List<RecordInstance> proposed) {
        RecordInstance recordInstance;
        RecordInstance recordInstance2;
        Record record = parameter.getAnnotation(Record.class);
        Input input = parameter.getAnnotation(Input.class);
        if (record != null && input != null || record == null && input == null) {
            throw new ContractDefinitionException("Method parameter " + parameter.getName() + " of type " + parameter.getType().getName() + " must have only one of (" + Record.class.getName() + "|" + Input.class.getName() + ") annotations");
        }
        if (record != null) {
            Object v0;
            block7: {
                var8_6 = records;
                for (Object t : var8_6) {
                    it = (RecordInstance)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)record.name())) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            v1 = v0;
        } else {
            Object v2;
            block8: {
                var8_6 = proposed;
                for (Object t : var8_6) {
                    it = (RecordInstance)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)input.name())) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            v1 = recordInstance2 = (RecordInstance)v2;
        }
        if (recordInstance2 != null) {
            RecordInstance recordInstance3;
            RecordInstance it = recordInstance3 = recordInstance2;
            boolean bl = false;
            recordInstance = Intrinsics.areEqual(parameter.getType(), it.getClazz()) ? recordInstance3 : null;
        } else {
            recordInstance = null;
        }
        return recordInstance;
    }

    private final Commons.DefinitionSpec proposedRecordToDef(Contracts.ProposedRecord proposedRecord) {
        Contracts.ProposedRecord it = proposedRecord;
        boolean bl = false;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = proposedRecord.getClassname();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassname(...)");
        Commons.ProvenanceReference provenanceReference = Commons.ProvenanceReference.newBuilder().setHash(proposedRecord.getHash()).build();
        Intrinsics.checkNotNullExpressionValue((Object)provenanceReference, (String)"build(...)");
        Commons.Location.Builder builder = ProtoUtil.INSTANCE.locationBuilderOf(string2, provenanceReference);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"locationBuilderOf(...)");
        return ProtoUtil.defSpecBuilderOf$default((ProtoUtil)ProtoUtil.INSTANCE, (String)string, (Commons.Location.Builder)builder, (Commons.DefinitionSpec.Type)Commons.DefinitionSpec.Type.FACT, (boolean)false, (int)8, null).build();
    }
}

