/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.definition;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.provenance.scope.classloader.MemoryClassLoader;
import io.provenance.scope.contract.proto.Commons;
import io.provenance.scope.definition.DefinitionService;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.objectstore.client.CachedOsClient;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.util.ClassLoaderExtensionsKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u001f\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/provenance/scope/definition/DefinitionService;", "", "osClient", "Lio/provenance/scope/objectstore/client/CachedOsClient;", "memoryClassLoader", "Lio/provenance/scope/classloader/MemoryClassLoader;", "(Lio/provenance/scope/objectstore/client/CachedOsClient;Lio/provenance/scope/classloader/MemoryClassLoader;)V", "parseFromCache", "Lcom/google/common/cache/Cache;", "", "Ljava/lang/reflect/Method;", "addJar", "", "encryptionKeyRef", "Lio/provenance/scope/encryption/model/KeyRef;", "definition", "Lio/provenance/scope/contract/proto/Commons$DefinitionSpec;", "signaturePublicKey", "Ljava/security/PublicKey;", "hash", "inputStream", "Ljava/io/InputStream;", "forThread", "T", "fn", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "loadClass", "Ljava/lang/Class;", "Companion", "engine"})
@SourceDebugExtension(value={"SMAP\nDefinitionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefinitionService.kt\nio/provenance/scope/definition/DefinitionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class DefinitionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CachedOsClient osClient;
    @NotNull
    private final MemoryClassLoader memoryClassLoader;
    @NotNull
    private final Cache<String, Method> parseFromCache;
    @NotNull
    private static final Cache<Companion.ByteCacheKey, byte[]> byteCache;

    public DefinitionService(@NotNull CachedOsClient osClient, @NotNull MemoryClassLoader memoryClassLoader) {
        Intrinsics.checkNotNullParameter((Object)osClient, (String)"osClient");
        Intrinsics.checkNotNullParameter((Object)memoryClassLoader, (String)"memoryClassLoader");
        this.osClient = osClient;
        this.memoryClassLoader = memoryClassLoader;
        Cache cache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.parseFromCache = cache;
    }

    public /* synthetic */ DefinitionService(CachedOsClient cachedOsClient, MemoryClassLoader memoryClassLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            memoryClassLoader = new MemoryClassLoader("", new ByteArrayInputStream(new byte[0]), false, 4, null);
        }
        this(cachedOsClient, memoryClassLoader);
    }

    public final void addJar(@NotNull KeyRef encryptionKeyRef, @NotNull Commons.DefinitionSpec definition, @Nullable PublicKey signaturePublicKey) {
        Intrinsics.checkNotNullParameter((Object)encryptionKeyRef, (String)"encryptionKeyRef");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String string = definition.getResourceLocation().getRef().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
        InputStream it = (InputStream)this.osClient.getJar(UtilKt.base64Decode((String)string), encryptionKeyRef).get();
        boolean bl = false;
        String string2 = definition.getResourceLocation().getRef().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHash(...)");
        Intrinsics.checkNotNull((Object)it);
        this.memoryClassLoader.addJar(string2, it);
    }

    public static /* synthetic */ void addJar$default(DefinitionService definitionService, KeyRef keyRef, Commons.DefinitionSpec definitionSpec, PublicKey publicKey, int n, Object object) {
        if ((n & 4) != 0) {
            publicKey = null;
        }
        definitionService.addJar(keyRef, definitionSpec, publicKey);
    }

    public final void addJar(@NotNull String hash, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.memoryClassLoader.addJar(hash, inputStream);
    }

    @NotNull
    public final Class<?> loadClass(@NotNull KeyRef encryptionKeyRef, @NotNull Commons.DefinitionSpec definition, @Nullable PublicKey signaturePublicKey) {
        Intrinsics.checkNotNullParameter((Object)encryptionKeyRef, (String)"encryptionKeyRef");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String string = definition.getResourceLocation().getRef().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
        InputStream it = (InputStream)this.osClient.getJar(UtilKt.base64Decode((String)string), encryptionKeyRef).get();
        boolean bl = false;
        String string2 = definition.getResourceLocation().getRef().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHash(...)");
        Intrinsics.checkNotNull((Object)it);
        this.memoryClassLoader.addJar(string2, it);
        it = Unit.INSTANCE;
        boolean bl2 = false;
        String string3 = definition.getResourceLocation().getClassname();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getClassname(...)");
        return this.memoryClassLoader.loadClass(string3);
    }

    public static /* synthetic */ Class loadClass$default(DefinitionService definitionService, KeyRef keyRef, Commons.DefinitionSpec definitionSpec, PublicKey publicKey, int n, Object object) {
        if ((n & 4) != 0) {
            publicKey = null;
        }
        return definitionService.loadClass(keyRef, definitionSpec, publicKey);
    }

    @NotNull
    public final Class<?> loadClass(@NotNull Commons.DefinitionSpec definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String string = definition.getResourceLocation().getClassname();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassname(...)");
        return this.memoryClassLoader.loadClass(string);
    }

    public final <T> T forThread(@NotNull Function0<? extends T> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        return (T)ClassLoaderExtensionsKt.forThread((ClassLoader)this.memoryClassLoader, fn);
    }

    private static final int byteCache$lambda$3(Function2 $tmp0, Object key, Object value) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(key, value)).intValue();
    }

    static {
        Cache cache = CacheBuilder.newBuilder().maximumWeight(10000000L).weigher((arg_0, arg_1) -> DefinitionService.byteCache$lambda$3(Companion.byteCache.1.INSTANCE, arg_0, arg_1)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        byteCache = cache;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/provenance/scope/definition/DefinitionService$Companion;", "", "()V", "byteCache", "Lcom/google/common/cache/Cache;", "Lio/provenance/scope/definition/DefinitionService$Companion$ByteCacheKey;", "", "ByteCacheKey", "engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/provenance/scope/definition/DefinitionService$Companion$ByteCacheKey;", "", "publicKey", "Ljava/security/PublicKey;", "hash", "", "(Ljava/security/PublicKey;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getPublicKey", "()Ljava/security/PublicKey;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "engine"})
        public static final class ByteCacheKey {
            @NotNull
            private final PublicKey publicKey;
            @NotNull
            private final String hash;

            public ByteCacheKey(@NotNull PublicKey publicKey, @NotNull String hash) {
                Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                this.publicKey = publicKey;
                this.hash = hash;
            }

            @NotNull
            public final PublicKey getPublicKey() {
                return this.publicKey;
            }

            @NotNull
            public final String getHash() {
                return this.hash;
            }

            @NotNull
            public final PublicKey component1() {
                return this.publicKey;
            }

            @NotNull
            public final String component2() {
                return this.hash;
            }

            @NotNull
            public final ByteCacheKey copy(@NotNull PublicKey publicKey, @NotNull String hash) {
                Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                return new ByteCacheKey(publicKey, hash);
            }

            public static /* synthetic */ ByteCacheKey copy$default(ByteCacheKey byteCacheKey, PublicKey publicKey, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    publicKey = byteCacheKey.publicKey;
                }
                if ((n & 2) != 0) {
                    string = byteCacheKey.hash;
                }
                return byteCacheKey.copy(publicKey, string);
            }

            @NotNull
            public String toString() {
                return "ByteCacheKey(publicKey=" + this.publicKey + ", hash=" + this.hash + ")";
            }

            public int hashCode() {
                int result = this.publicKey.hashCode();
                result = result * 31 + this.hash.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ByteCacheKey)) {
                    return false;
                }
                ByteCacheKey byteCacheKey = (ByteCacheKey)other;
                if (!Intrinsics.areEqual((Object)this.publicKey, (Object)byteCacheKey.publicKey)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.hash, (Object)byteCacheKey.hash);
            }
        }
    }
}

