/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk;

import io.provenance.scope.encryption.model.SigningAndEncryptionPublicKeys;
import io.provenance.scope.encryption.util.EncryptedInputStreamKt;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.util.AffiliateNotFoundException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0014\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0007R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/provenance/scope/sdk/AffiliateRepository;", "", "mainNet", "", "(Z)V", "affiliateAddressToPublicKeys", "Ljava/util/HashMap;", "", "Lio/provenance/scope/encryption/model/SigningAndEncryptionPublicKeys;", "Lkotlin/collections/HashMap;", "addAffiliate", "", "keys", "signingPublicKey", "Ljava/security/PublicKey;", "encryptionPublicKey", "addAllAffiliates", "affiliateKeys", "", "getAffiliateKeysByAddress", "affiliateAddress", "tryGetAffiliateKeysByAddress", "tryGetCorrespondingAffiliateAddress", "sdk"})
@SourceDebugExtension(value={"SMAP\nAffiliateRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AffiliateRepository.kt\nio/provenance/scope/sdk/AffiliateRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n1549#2:84\n1620#2,3:85\n1#3:88\n*S KotlinDebug\n*F\n+ 1 AffiliateRepository.kt\nio/provenance/scope/sdk/AffiliateRepository\n*L\n43#1:80\n43#1:81,3\n44#1:84\n44#1:85,3\n*E\n"})
public final class AffiliateRepository {
    private final boolean mainNet;
    @NotNull
    private final HashMap<String, SigningAndEncryptionPublicKeys> affiliateAddressToPublicKeys;

    public AffiliateRepository(boolean mainNet) {
        this.mainNet = mainNet;
        this.affiliateAddressToPublicKeys = new HashMap();
    }

    public final void addAffiliate(@NotNull PublicKey signingPublicKey, @NotNull PublicKey encryptionPublicKey) {
        Intrinsics.checkNotNullParameter((Object)signingPublicKey, (String)"signingPublicKey");
        Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
        SigningAndEncryptionPublicKeys keys = new SigningAndEncryptionPublicKeys(signingPublicKey, encryptionPublicKey);
        this.affiliateAddressToPublicKeys.put(KeyExtensionsKt.getAddress((PublicKey)signingPublicKey, (boolean)this.mainNet), keys);
        this.affiliateAddressToPublicKeys.put(KeyExtensionsKt.getAddress((PublicKey)encryptionPublicKey, (boolean)this.mainNet), keys);
    }

    public final void addAffiliate(@NotNull SigningAndEncryptionPublicKeys keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        this.affiliateAddressToPublicKeys.put(KeyExtensionsKt.getAddress((PublicKey)keys.getSigningPublicKey(), (boolean)this.mainNet), keys);
        this.affiliateAddressToPublicKeys.put(KeyExtensionsKt.getAddress((PublicKey)keys.getEncryptionPublicKey(), (boolean)this.mainNet), keys);
    }

    public final void addAllAffiliates(@NotNull List<SigningAndEncryptionPublicKeys> affiliateKeys) {
        SigningAndEncryptionPublicKeys it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(affiliateKeys, (String)"affiliateKeys");
        Iterable iterable = affiliateKeys;
        Map map = this.affiliateAddressToPublicKeys;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SigningAndEncryptionPublicKeys signingAndEncryptionPublicKeys = (SigningAndEncryptionPublicKeys)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)KeyExtensionsKt.getAddress((PublicKey)it.getSigningPublicKey(), (boolean)this.mainNet), (Object)it));
        }
        MapsKt.putAll((Map)map, (Iterable)((List)destination$iv$iv));
        $this$map$iv = affiliateKeys;
        map = this.affiliateAddressToPublicKeys;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SigningAndEncryptionPublicKeys)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)KeyExtensionsKt.getAddress((PublicKey)it.getEncryptionPublicKey(), (boolean)this.mainNet), (Object)it));
        }
        MapsKt.putAll((Map)map, (Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final SigningAndEncryptionPublicKeys tryGetAffiliateKeysByAddress(@NotNull String affiliateAddress) {
        Intrinsics.checkNotNullParameter((Object)affiliateAddress, (String)"affiliateAddress");
        return this.affiliateAddressToPublicKeys.get(affiliateAddress);
    }

    @NotNull
    public final SigningAndEncryptionPublicKeys getAffiliateKeysByAddress(@NotNull String affiliateAddress) {
        Intrinsics.checkNotNullParameter((Object)affiliateAddress, (String)"affiliateAddress");
        return (SigningAndEncryptionPublicKeys)EncryptedInputStreamKt.orThrow((Object)this.tryGetAffiliateKeysByAddress(affiliateAddress), (Function0)((Function0)new Function0<AffiliateNotFoundException>(affiliateAddress){
            final /* synthetic */ String $affiliateAddress;
            {
                this.$affiliateAddress = $affiliateAddress;
                super(0);
            }

            @NotNull
            public final AffiliateNotFoundException invoke() {
                return new AffiliateNotFoundException("Affiliate with address " + this.$affiliateAddress + " not found");
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String tryGetCorrespondingAffiliateAddress(@NotNull String affiliateAddress) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)affiliateAddress, (String)"affiliateAddress");
            SigningAndEncryptionPublicKeys signingAndEncryptionPublicKeys = this.tryGetAffiliateKeysByAddress(affiliateAddress);
            if (signingAndEncryptionPublicKeys == null) return null;
            SigningAndEncryptionPublicKeys it = signingAndEncryptionPublicKeys;
            boolean bl = false;
            Object[] objectArray = new String[]{KeyExtensionsKt.getAddress((PublicKey)it.getSigningPublicKey(), (boolean)this.mainNet), KeyExtensionsKt.getAddress((PublicKey)it.getEncryptionPublicKey(), (boolean)this.mainNet)};
            List list = CollectionsKt.listOf((Object[])objectArray);
            if (list == null) return null;
            Iterable iterable = list;
            for (Object t : iterable) {
                String it2 = (String)t;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it2, (Object)affiliateAddress))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        String string = v0;
        return string;
    }
}

