/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import cosmos.authz.v1beta1.Authz;
import cosmos.authz.v1beta1.Tx;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.provenance.metadata.v1.Record;
import io.provenance.metadata.v1.RecordWrapper;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.scope.contract.annotations.ScopeSpecificationDefinition;
import io.provenance.scope.contract.contracts.ContractHash;
import io.provenance.scope.contract.proto.Commons;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.contract.proto.ProtoHash;
import io.provenance.scope.contract.proto.Specifications;
import io.provenance.scope.contract.spec.P8eContract;
import io.provenance.scope.contract.spec.P8eScopeSpecification;
import io.provenance.scope.encryption.crypto.SignerImpl;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.proto.PK;
import io.provenance.scope.sdk.Affiliate;
import io.provenance.scope.sdk.AffiliateRepository;
import io.provenance.scope.sdk.Client;
import io.provenance.scope.sdk.ClientKt;
import io.provenance.scope.sdk.ContractSpecMapper;
import io.provenance.scope.sdk.ExecutionResult;
import io.provenance.scope.sdk.FragmentResult;
import io.provenance.scope.sdk.ProtoIndexer;
import io.provenance.scope.sdk.Session;
import io.provenance.scope.sdk.SharedClient;
import io.provenance.scope.sdk.SignedResult;
import io.provenance.scope.sdk.extensions.EnvelopeExtensionsKt;
import io.provenance.scope.sdk.extensions.ProvenanceKt;
import io.provenance.scope.sdk.mailbox.MailboxEvent;
import io.provenance.scope.sdk.mailbox.MailboxService;
import io.provenance.scope.sdk.mailbox.PollAffiliateMailbox;
import io.provenance.scope.util.ContractBootstrapException;
import io.provenance.scope.util.DateExtensionsKt;
import io.provenance.scope.util.EnvelopeAlreadySignedException;
import io.provenance.scope.util.ExtensionsKt;
import io.provenance.scope.util.TypeUrls;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.PublicKey;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 V2\u00020\u0001:\u0001VB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(J \u0010)\u001a\u00020*\"\b\b\u0000\u0010+*\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.H\u0002J(\u0010/\u001a\u001a\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0015002\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u00102\u001a\u0002032\u0006\u00104\u001a\u00020*2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J'\u00105\u001a\u0002H+\"\u0004\b\u0000\u0010+2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.2\u0006\u00106\u001a\u000207\u00a2\u0006\u0002\u00108J&\u00109\u001a\u00020:\"\b\b\u0000\u0010+*\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.2\u0006\u00106\u001a\u000207J6\u00109\u001a\u00020:\"\b\b\u0000\u0010+*\u00020,\"\b\b\u0001\u0010;*\u00020<2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H;0.J4\u0010>\u001a\u0006\u0012\u0002\b\u00030?2\u0006\u0010@\u001a\u00020A2\b\b\u0002\u0010B\u001a\u00020\u001e2\u0016\u0010C\u001a\u0012\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\u001c0Dj\u0002`FJ\u000e\u0010G\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010H\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010I\u001a\u000201J\u000e\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020LJ\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u00152\u0006\u0010\u0017\u001a\u00020\u0018J5\u0010O\u001a\u0002H+\"\b\b\u0000\u0010+*\u00020P\"\b\b\u0001\u0010Q*\u00020R*\u0004\u0018\u0001H+2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HQ0TH\u0002\u00a2\u0006\u0002\u0010UR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lio/provenance/scope/sdk/Client;", "Ljava/io/Closeable;", "inner", "Lio/provenance/scope/sdk/SharedClient;", "affiliate", "Lio/provenance/scope/sdk/Affiliate;", "(Lio/provenance/scope/sdk/SharedClient;Lio/provenance/scope/sdk/Affiliate;)V", "getAffiliate", "()Lio/provenance/scope/sdk/Affiliate;", "indexer", "Lio/provenance/scope/sdk/ProtoIndexer;", "getIndexer", "()Lio/provenance/scope/sdk/ProtoIndexer;", "getInner", "()Lio/provenance/scope/sdk/SharedClient;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "tracer", "Lio/opentracing/Tracer;", "approveScopeUpdate", "", "Lcosmos/authz/v1beta1/Tx$MsgGrant;", "envelopeState", "Lio/provenance/scope/contract/proto/Envelopes$EnvelopeState;", "expirationTime", "Ljava/time/OffsetDateTime;", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "close", "", "execute", "Lio/provenance/scope/sdk/ExecutionResult;", "envelope", "Lio/provenance/scope/contract/proto/Envelopes$Envelope;", "session", "Lio/provenance/scope/sdk/Session;", "getContractHash", "Lio/provenance/scope/contract/contracts/ContractHash;", "T", "Lio/provenance/scope/contract/spec/P8eContract;", "clazz", "Ljava/lang/Class;", "getGrantSetup", "Lkotlin/Triple;", "", "getProtoHash", "Lio/provenance/scope/contract/proto/ProtoHash;", "contractHash", "hydrate", "scope", "Lio/provenance/metadata/v1/ScopeResponse;", "(Ljava/lang/Class;Lio/provenance/metadata/v1/ScopeResponse;)Ljava/lang/Object;", "newSession", "Lio/provenance/scope/sdk/Session$Builder;", "S", "Lio/provenance/scope/contract/spec/P8eScopeSpecification;", "scopeSpecificationDef", "registerMailHandler", "Ljava/util/concurrent/ScheduledFuture;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "rate", "handler", "Ljava/util/function/Function;", "Lio/provenance/scope/sdk/mailbox/MailboxEvent;", "Lio/provenance/scope/sdk/mailbox/MailHandlerFn;", "requestAffiliateExecution", "respondWithApproval", "approvalTxHash", "respondWithError", "error", "Lio/provenance/scope/contract/proto/Envelopes$EnvelopeError;", "revokeScopeUpdate", "Lcosmos/authz/v1beta1/Tx$MsgRevoke;", "orThrow", "", "X", "", "supplier", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "sdk"})
@SourceDebugExtension(value={"SMAP\nClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Client.kt\nio/provenance/scope/sdk/Client\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,470:1\n1#2:471\n1549#3:472\n1620#3,3:473\n1536#3:476\n1549#3:477\n1620#3,3:478\n1549#3:481\n1620#3,3:482\n1549#3:485\n1620#3,3:486\n288#3:494\n1747#3,3:496\n289#3:500\n1549#3:505\n1620#3,2:506\n288#3,2:508\n1622#3:510\n1549#3:511\n1620#3,3:512\n1549#3:515\n1620#3,3:516\n3792#4:489\n4307#4:490\n12271#4,2:491\n4308#4:493\n12474#4:495\n12475#4:499\n11065#4:501\n11400#4,3:502\n37#5,2:519\n*S KotlinDebug\n*F\n+ 1 Client.kt\nio/provenance/scope/sdk/Client\n*L\n167#1:472\n167#1:473,3\n238#1:476\n239#1:477\n239#1:478,3\n336#1:481\n336#1:482,3\n364#1:485\n364#1:486,3\n400#1:494\n402#1:496,3\n400#1:500\n412#1:505\n412#1:506,2\n413#1:508,2\n412#1:510\n416#1:511\n416#1:512,3\n421#1:515\n421#1:516,3\n389#1:489\n389#1:490\n391#1:491,2\n389#1:493\n401#1:495\n401#1:499\n411#1:501\n411#1:502,3\n423#1:519,2\n*E\n"})
public final class Client
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedClient inner;
    @NotNull
    private final Affiliate affiliate;
    private final Logger log;
    private final Tracer tracer;
    @NotNull
    private final ProtoIndexer indexer;
    @NotNull
    private static final List<ContractHash> contractHashes;
    @NotNull
    private static final List<ProtoHash> protoHashes;

    public Client(@NotNull SharedClient inner, @NotNull Affiliate affiliate) {
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        Intrinsics.checkNotNullParameter((Object)affiliate, (String)"affiliate");
        this.inner = inner;
        this.affiliate = affiliate;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.tracer = GlobalTracer.get();
        this.inner.getAffiliateRepository().addAffiliate(this.affiliate.getSigningKeyRef().getPublicKey(), this.affiliate.getEncryptionKeyRef().getPublicKey());
        this.indexer = new ProtoIndexer(this.inner.getOsClient(), this.inner.getConfig().getMainNet(), this.affiliate, null, 8, null);
    }

    @NotNull
    public final SharedClient getInner() {
        return this.inner;
    }

    @NotNull
    public final Affiliate getAffiliate() {
        return this.affiliate;
    }

    @NotNull
    public final ProtoIndexer getIndexer() {
        return this.indexer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends P8eContract> Session.Builder newSession(@NotNull Class<T> clazz, @NotNull ScopeResponse scope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ProtoHash protoHash2;
        Object object;
        Object object2;
        Object object3;
        ContractHash contractHash;
        block4: {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            contractHash = this.getContractHash(clazz);
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            object3 = methodArray;
            object2 = this;
            for (Object object4 : object3) {
                Method it = (Method)object4;
                boolean bl = false;
                if (!Message.class.isAssignableFrom(it.getReturnType())) continue;
                object = object4;
                break block4;
            }
            object = null;
        }
        Client client = object2;
        Method method = (Method)object;
        if (method != null && (object3 = method.getReturnType()) != null) {
            void it;
            Object object5 = object3;
            object2 = client;
            boolean bl = false;
            protoHash2 = this.getProtoHash(contractHash, (Class<?>)it);
            client = object2;
        } else {
            protoHash2 = null;
        }
        ProtoHash protoHash3 = client.orThrow(protoHash2, (Function0)new Function0<IllegalStateException>(clazz){
            final /* synthetic */ Class<T> $clazz;
            {
                this.$clazz = $clazz;
                super(0);
            }

            @NotNull
            public final IllegalStateException invoke() {
                return new IllegalStateException("Unable to find hash for proto JAR for return types on " + this.$clazz.getName());
            }
        });
        Commons.ProvenanceReference contractRef = Commons.ProvenanceReference.newBuilder().setHash(contractHash.getHash()).build();
        Commons.ProvenanceReference protoRef = Commons.ProvenanceReference.newBuilder().setHash(protoHash3.getHash()).build();
        KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
        Intrinsics.checkNotNull((Object)contractRef);
        Intrinsics.checkNotNull((Object)protoRef);
        Specifications.ContractSpec contractSpec = ContractSpecMapper.INSTANCE.dehydrateSpec((KClass<? extends P8eContract>)kClass, contractRef, protoRef);
        String string = scope.getScope().getScopeSpecIdInfo().getScopeSpecUuid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScopeSpecUuid(...)");
        Object it = new Session.Builder(ExtensionsKt.toUuid((String)string), this.inner.getAffiliateRepository());
        Session.Builder it2 = it;
        boolean $i$a$-also-Client$newSession$22 = false;
        it2.setClient(this);
        Session.Builder builder = ((Session.Builder)it).setContractSpec(contractSpec).setProvenanceReference(contractRef).setScope(scope).addParticipant(this.affiliate.getPartyType(), this.affiliate.getSigningKeyRef().getPublicKey(), this.affiliate.getEncryptionKeyRef().getPublicKey());
        ProtocolStringList protocolStringList = scope.getScope().getScope().getDataAccessList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getDataAccessList(...)");
        it = (Iterable)protocolStringList;
        object2 = builder;
        boolean $i$f$map = false;
        void $i$a$-also-Client$newSession$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AffiliateRepository affiliateRepository = this.inner.getAffiliateRepository();
            Intrinsics.checkNotNull((Object)it3);
            collection.add(affiliateRepository.getAffiliateKeysByAddress((String)it3).getEncryptionPublicKey());
        }
        return ((Session.Builder)object2).addDataAccessKeys((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends P8eContract, S extends P8eScopeSpecification> Session.Builder newSession(@NotNull Class<T> clazz, @NotNull Class<S> scopeSpecificationDef) {
        Session.Builder builder;
        ProtoHash protoHash2;
        Object object;
        Client client;
        Object object2;
        ContractHash contractHash;
        block4: {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter(scopeSpecificationDef, (String)"scopeSpecificationDef");
            contractHash = this.getContractHash(clazz);
            Method[] methodArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            object2 = methodArray;
            client = this;
            for (Object object3 : object2) {
                Method it = (Method)object3;
                boolean bl = false;
                if (!Message.class.isAssignableFrom(it.getReturnType())) continue;
                object = object3;
                break block4;
            }
            object = null;
        }
        Client client2 = client;
        Method method = (Method)object;
        if (method != null && (object2 = method.getReturnType()) != null) {
            void it;
            Object object4 = object2;
            client = client2;
            boolean bl = false;
            protoHash2 = this.getProtoHash(contractHash, (Class<?>)it);
            client2 = client;
        } else {
            protoHash2 = null;
        }
        ProtoHash protoHash3 = client2.orThrow(protoHash2, (Function0)new Function0<IllegalStateException>(clazz){
            final /* synthetic */ Class<T> $clazz;
            {
                this.$clazz = $clazz;
                super(0);
            }

            @NotNull
            public final IllegalStateException invoke() {
                return new IllegalStateException("Unable to find hash for proto JAR for return types on " + this.$clazz.getName());
            }
        });
        Commons.ProvenanceReference contractRef = Commons.ProvenanceReference.newBuilder().setHash(contractHash.getHash()).build();
        Commons.ProvenanceReference protoRef = Commons.ProvenanceReference.newBuilder().setHash(protoHash3.getHash()).build();
        KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
        Intrinsics.checkNotNull((Object)contractRef);
        Intrinsics.checkNotNull((Object)protoRef);
        Specifications.ContractSpec contractSpec = ContractSpecMapper.INSTANCE.dehydrateSpec((KClass<? extends P8eContract>)kClass, contractRef, protoRef);
        ScopeSpecificationDefinition scopeSpecAnnotation = scopeSpecificationDef.getAnnotation(ScopeSpecificationDefinition.class);
        if (scopeSpecAnnotation == null) {
            boolean bl = false;
            String string = "The annotation for the scope specifications must not be null";
            throw new IllegalArgumentException(string.toString());
        }
        Session.Builder it = builder = new Session.Builder(ExtensionsKt.toUuid((String)scopeSpecAnnotation.uuid()), this.inner.getAffiliateRepository());
        boolean bl = false;
        it.setClient(this);
        return builder.setContractSpec(contractSpec).setProvenanceReference(contractRef).addParticipant(this.affiliate.getPartyType(), this.affiliate.getSigningKeyRef().getPublicKey(), this.affiliate.getEncryptionKeyRef().getPublicKey());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecutionResult execute(@NotNull Session session) {
        ExecutionResult executionResult;
        ExecutionResult executionResult2;
        Span span;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Span it = span = this.tracer.buildSpan("Execution").start();
        boolean bl = false;
        this.tracer.activateSpan(it);
        Span span2 = span;
        Envelopes.Envelope input = session.packageContract(this.inner.getConfig().getMainNet(), this.inner.getAffiliateRepository());
        this.log.debug("Contract name: " + input.getContract().getDefinition().getName());
        this.log.debug("Session Id: " + session.getSessionUuid());
        this.log.debug("Execution UUID: " + input.getExecutionUuid());
        Envelopes.Envelope result = this.inner.getContractEngine().handle(this.affiliate.getEncryptionKeyRef(), this.affiliate.getSigningKeyRef(), input, (Collection)session.getDataAccessKeys());
        Envelopes.EnvelopeState envelopeState = Envelopes.EnvelopeState.newBuilder().setInput(input).setResult(result).build();
        boolean bl2 = EnvelopeExtensionsKt.isSigned(result);
        if (bl2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SignedResult signedResult;
            Intrinsics.checkNotNull((Object)envelopeState);
            SignedResult signedResult2 = signedResult = new SignedResult(envelopeState);
            boolean bl3 = false;
            Iterable $this$groupingBy$iv = signedResult2.getExecutionInfo();
            boolean $i$f$groupingBy = false;
            this.log.debug("Number of each type: " + GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Triple<? extends String, ? extends String, ? extends String>, String>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<Triple<? extends String, ? extends String, ? extends String>> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    Triple it = (Triple)element;
                    boolean bl = false;
                    return (String)it.getSecond();
                }
            })));
            $this$groupingBy$iv = signedResult2.getExecutionInfo();
            Logger logger = this.log;
            boolean $i$f$map = false;
            void var13_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Triple triple = (Triple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add("" + it2.getThird() + it2.getFirst());
            }
            logger.debug("List of ID/Address " + (List)destination$iv$iv);
            this.log.trace("Full Content of TX Protos: " + signedResult2.getMessages());
            executionResult2 = signedResult;
        } else if (!bl2) {
            Intrinsics.checkNotNull((Object)envelopeState);
            executionResult2 = new FragmentResult(envelopeState);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ExecutionResult it3 = executionResult = executionResult2;
        boolean bl5 = false;
        span2.finish();
        return executionResult;
    }

    @NotNull
    public final ExecutionResult execute(@NotNull Envelopes.Envelope envelope) {
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        Envelopes.Envelope result = this.inner.getContractEngine().handle(this.affiliate.getEncryptionKeyRef(), this.affiliate.getSigningKeyRef(), envelope, (Collection)CollectionsKt.emptyList());
        Envelopes.EnvelopeState envelopeState = Envelopes.EnvelopeState.newBuilder().setInput(envelope).setResult(result).build();
        Intrinsics.checkNotNull((Object)envelopeState);
        return new FragmentResult(envelopeState);
    }

    @NotNull
    public final ScheduledFuture<?> registerMailHandler(@NotNull ScheduledExecutorService executor, long rate, @NotNull Function<MailboxEvent, Boolean> handler) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        ScheduledFuture<?> scheduledFuture = executor.scheduleAtFixedRate(new PollAffiliateMailbox(this.inner.getOsClient(), this.inner.getMailboxService(), this.affiliate.getSigningKeyRef(), this.affiliate.getEncryptionKeyRef(), 100, this.inner.getConfig().getMainNet(), handler), 1L, rate, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleAtFixedRate(...)");
        return scheduledFuture;
    }

    public static /* synthetic */ ScheduledFuture registerMailHandler$default(Client client, ScheduledExecutorService scheduledExecutorService, long l, Function function, int n, Object object) {
        if ((n & 2) != 0) {
            l = 1L;
        }
        return client.registerMailHandler(scheduledExecutorService, l, function);
    }

    public final void requestAffiliateExecution(@NotNull Envelopes.EnvelopeState envelopeState) {
        Object t;
        Client client;
        block2: {
            Intrinsics.checkNotNullParameter((Object)envelopeState, (String)"envelopeState");
            List list = envelopeState.getInput().getContract().getRecitalsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
            Iterable iterable = list;
            client = this;
            Iterable iterable2 = iterable;
            for (Object t2 : iterable2) {
                Contracts.Recital it = (Contracts.Recital)t2;
                boolean bl = false;
                if (!(it.getSignerRole() == this.affiliate.getPartyType() && Intrinsics.areEqual((Object)it.getSigner().getSigningPublicKey(), (Object)ClientKt.toPublicKeyProto(this.affiliate.getSigningKeyRef().getPublicKey())))) continue;
                t = t2;
                break block2;
            }
            t = null;
        }
        client.orThrow(t, requestAffiliateExecution.2.INSTANCE);
        Envelopes.Envelope envelope = envelopeState.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"getResult(...)");
        if (EnvelopeExtensionsKt.isSigned(envelope)) {
            throw new EnvelopeAlreadySignedException("Envelope already fully signed, cannot request affiliate execution");
        }
        MailboxService mailboxService = this.inner.getMailboxService();
        PublicKey publicKey = this.affiliate.getEncryptionKeyRef().getPublicKey();
        SignerImpl signerImpl = this.affiliate.getSigningKeyRef().signer();
        Envelopes.Envelope envelope2 = envelopeState.getInput();
        Intrinsics.checkNotNullExpressionValue((Object)envelope2, (String)"getInput(...)");
        mailboxService.fragment(publicKey, signerImpl, envelope2);
    }

    public final void respondWithApproval(@NotNull Envelopes.EnvelopeState envelopeState, @NotNull String approvalTxHash) {
        Intrinsics.checkNotNullParameter((Object)envelopeState, (String)"envelopeState");
        Intrinsics.checkNotNullParameter((Object)approvalTxHash, (String)"approvalTxHash");
        MailboxService mailboxService = this.inner.getMailboxService();
        PublicKey publicKey = this.affiliate.getEncryptionKeyRef().getPublicKey();
        SignerImpl signerImpl = this.affiliate.getSigningKeyRef().signer();
        Envelopes.Envelope envelope = envelopeState.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"getResult(...)");
        mailboxService.result(publicKey, signerImpl, envelope);
    }

    public final void respondWithError(@NotNull Envelopes.EnvelopeError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.inner.getMailboxService().error(this.affiliate.getEncryptionKeyRef().getPublicKey(), this.affiliate.getSigningKeyRef().signer(), error, new PublicKey[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Tx.MsgGrant> approveScopeUpdate(@NotNull Envelopes.EnvelopeState envelopeState, @NotNull OffsetDateTime expirationTime) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)envelopeState, (String)"envelopeState");
        Intrinsics.checkNotNullParameter((Object)expirationTime, (String)"expirationTime");
        Triple<String, String, List<String>> triple = this.getGrantSetup(envelopeState);
        String granter = (String)triple.component1();
        String grantee = (String)triple.component2();
        List typeUrls = (List)triple.component3();
        Iterable $this$map$iv = typeUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void typeUrl;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Tx.MsgGrant.Builder builder = Tx.MsgGrant.newBuilder().setGranter(granter).setGrantee(grantee);
            Authz.Grant.Builder builder2 = Authz.Grant.newBuilder().setAuthorization(Any.pack((Message)((Message)Authz.GenericAuthorization.newBuilder().setMsg((String)typeUrl).build()), (String)""));
            Timestamp.Builder builder3 = Timestamp.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder(...)");
            collection.add(builder.setGrant(builder2.setExpiration(DateExtensionsKt.setValue((Timestamp.Builder)builder3, (OffsetDateTime)expirationTime).build()).build()).build());
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List approveScopeUpdate$default(Client client, Envelopes.EnvelopeState envelopeState, OffsetDateTime offsetDateTime, int n, Object object) {
        if ((n & 2) != 0) {
            OffsetDateTime offsetDateTime2 = OffsetDateTime.now().plusHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"plusHours(...)");
            offsetDateTime = offsetDateTime2;
        }
        return client.approveScopeUpdate(envelopeState, offsetDateTime);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Tx.MsgRevoke> revokeScopeUpdate(@NotNull Envelopes.EnvelopeState envelopeState) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)envelopeState, (String)"envelopeState");
        Triple<String, String, List<String>> triple = this.getGrantSetup(envelopeState);
        String granter = (String)triple.component1();
        String grantee = (String)triple.component2();
        List typeUrls = (List)triple.component3();
        Iterable $this$map$iv = typeUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void typeUrl;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Tx.MsgRevoke.newBuilder().setGranter(granter).setGrantee(grantee).setMsgTypeUrl((String)typeUrl).build());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final <T> T hydrate(@NotNull Class<T> clazz, @NotNull ScopeResponse scope) {
        block22: {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            span = this.tracer.buildSpan("Hydration").start();
            this.tracer.activateSpan(span);
            ProvenanceKt.validateRecordsRequested(scope);
            v0 = clazz.getDeclaredConstructors();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getDeclaredConstructors(...)");
            var5_4 = v0;
            var28_5 = ContractSpecMapper.INSTANCE;
            var27_6 = ContractSpecMapper.INSTANCE;
            $i$f$filter = false;
            var7_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                block19: {
                    it = (Constructor)element$iv$iv;
                    $i$a$-filter-Client$hydrate$constructor$1 = false;
                    v1 = it.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getParameters(...)");
                    if (!(((Object[])v1).length == 0 == false)) ** GOTO lbl-1000
                    v2 = it.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getParameters(...)");
                    $this$all$iv = v2;
                    $i$f$all = 0;
                    for (Object element$iv : $this$all$iv) {
                        param = (Parameter)element$iv;
                        $i$a$-all-Client$hydrate$constructor$1$1 = false;
                        if (Message.class.isAssignableFrom(param.getType()) && param.getAnnotation(io.provenance.scope.contract.annotations.Record.class) != null) continue;
                        v3 = false;
                        break block19;
                    }
                    v3 = true;
                }
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $i$f$filter = $this$filter$iv = (var29_61 = (List<E>)destination$iv$iv);
            $i$a$-takeIf-Client$hydrate$constructor$2 = false;
            var29_62 = !((Collection)it).isEmpty();
            it = var28_5.orThrowContractDefinition(var29_62 != false ? $this$filter$iv : null, "Unable to build POJO of type " + clazz.getName() + " because not all constructor params implement " + Message.class.getName() + " and have a \"Record\" annotation");
            $i$a$-run-Client$hydrate$constructor$3 = false;
            $this$firstOrNull$iv = (Iterable)$this$hydrate_u24lambda_u2422;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block21: {
                    it = (Constructor)element$iv;
                    $i$a$-firstOrNull-Client$hydrate$constructor$3$1 = false;
                    v5 = it.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getParameters(...)");
                    $this$any$iv = v5;
                    $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        block20: {
                            block24: {
                                param = (Parameter)element$iv;
                                $i$a$-any-Client$hydrate$constructor$3$1$1 = false;
                                v6 = scope.getRecordsList();
                                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getRecordsList(...)");
                                $this$any$iv = v6;
                                $i$f$any = false;
                                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block24;
                                v7 = false;
                                break block20;
                            }
                            for (T element$iv : $this$any$iv) {
                                wrapper = (RecordWrapper)element$iv;
                                $i$a$-any-Client$hydrate$constructor$3$1$1$1 = false;
                                v8 = param.getAnnotation(io.provenance.scope.contract.annotations.Record.class);
                                if (!Intrinsics.areEqual((Object)wrapper.getRecord().getName(), (Object)(v8 != null ? v8.name() : null))) ** GOTO lbl-1000
                                v9 = wrapper.getRecord();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getRecord(...)");
                                if (Intrinsics.areEqual((Object)ProvenanceKt.resultType(v9), (Object)param.getType().getName())) {
                                    v10 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v10 = false;
                                }
                                if (!v10) continue;
                                v7 = true;
                                break block20;
                            }
                            v7 = false;
                        }
                        if (!v7) continue;
                        v11 = true;
                        break block21;
                    }
                    v11 = false;
                }
                if (!v11) continue;
                v12 = element$iv;
                break block22;
            }
            v12 = null;
        }
        if ((v13 = (Constructor)v12) == null) {
            v13 = (Constructor)CollectionsKt.firstOrNull((List)$this$hydrate_u24lambda_u2422);
        }
        constructor = var27_6.orThrowContractDefinition(v13, "No constructor params have a matching record in scope " + ProvenanceKt.uuid(scope));
        v14 = constructor.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getParameters(...)");
        $this$hydrate_u24lambda_u2422 = v14;
        $i$f$map = false;
        $this$firstOrNull$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
        $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            $this$any$iv = (Parameter)item$iv$iv;
            var27_6 = destination$iv$iv;
            $i$a$-map-Client$hydrate$params$1 = false;
            var27_6.add(TuplesKt.to((Object)it.getAnnotation(io.provenance.scope.contract.annotations.Record.class).name(), it.getType()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            block23: {
                item$iv$iv = (Pair)item$iv$iv;
                var27_6 = destination$iv$iv;
                $i$a$-map-Client$hydrate$params$2 = false;
                name = (String)item$iv$iv.component1();
                type = (Class)item$iv$iv.component2();
                v15 = scope.getRecordsList();
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getRecordsList(...)");
                $this$firstOrNull$iv = v15;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    wrapper = (RecordWrapper)element$iv;
                    $i$a$-firstOrNull-Client$hydrate$params$2$1 = false;
                    if (!Intrinsics.areEqual((Object)wrapper.getRecord().getName(), (Object)name)) ** GOTO lbl-1000
                    v16 = wrapper.getRecord();
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"getRecord(...)");
                    if (Intrinsics.areEqual((Object)ProvenanceKt.resultType(v16), (Object)type.getName())) {
                        v17 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v17 = false;
                    }
                    if (!v17) continue;
                    v18 = element$iv;
                    break block23;
                }
                v18 = null;
            }
            var23_64 = v18;
            var27_6.add(TuplesKt.to((Object)(var23_64 != null ? var23_64.getRecord() : null), (Object)type));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            item$iv$iv = (Pair)item$iv$iv;
            var27_6 = destination$iv$iv;
            $i$a$-map-Client$hydrate$params$3 = false;
            record = (Record)item$iv$iv.component1();
            type = (Class)item$iv$iv.component2();
            if (record == null) {
                v19 = Futures.immediateFuture((Object)record);
            } else {
                v20 = this.inner.getOsClient();
                v21 = type.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"getName(...)");
                v19 = v20.getRecord(v21, ProvenanceKt.resultHash(record), this.affiliate.getEncryptionKeyRef());
            }
            var27_6.add(v19);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            item$iv$iv = (ListenableFuture)item$iv$iv;
            var27_6 = destination$iv$iv;
            $i$a$-map-Client$hydrate$params$4 = false;
            var27_6.add((Message)it.get());
        }
        params = (List)destination$iv$iv;
        $this$toTypedArray$iv = CollectionsKt.toList((Iterable)params);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        var6_8 /* !! */  = thisCollection$iv.toArray(new Message[0]);
        it /* !! */  = var6_8 /* !! */  = clazz.cast(constructor.newInstance(Arrays.copyOf(var6_8 /* !! */ , var6_8 /* !! */ .length)));
        $i$a$-also-Client$hydrate$1 = false;
        span.finish();
        return (T)var6_8 /* !! */ ;
    }

    private final Triple<String, String, List<String>> getGrantSetup(Envelopes.EnvelopeState envelopeState) {
        String granter = KeyExtensionsKt.getAddress((PublicKey)this.affiliate.getSigningKeyRef().getPublicKey(), (boolean)this.inner.getConfig().getMainNet());
        PK.PublicKey publicKey = envelopeState.getInput().getContract().getInvoker().getSigningPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getSigningPublicKey(...)");
        String grantee = KeyExtensionsKt.getAddress((PublicKey)KeyExtensionsKt.toPublicKey((PK.PublicKey)publicKey), (boolean)this.inner.getConfig().getMainNet());
        Object[] objectArray = new String[]{envelopeState.getInput().getNewScope() ? TypeUrls.INSTANCE.getTypeURLMsgWriteScopeRequest() : null, !envelopeState.getInput().getNewScope() ? TypeUrls.INSTANCE.getTypeURLMsgAddScopeDataAccessRequest() : null, envelopeState.getInput().getNewSession() ? TypeUrls.INSTANCE.getTypeURLMsgWriteSessionRequest() : null, !envelopeState.getInput().getNewSession() ? TypeUrls.INSTANCE.getTypeURLMsgWriteRecordRequest() : null};
        List typeUrls = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
        return new Triple((Object)granter, (Object)grantee, (Object)typeUrls);
    }

    private final <T extends P8eContract> ContractHash getContractHash(Class<T> clazz) {
        T t;
        Client client;
        block1: {
            Iterable iterable = contractHashes;
            client = this;
            Iterable iterable2 = iterable;
            for (Object t2 : iterable2) {
                ContractHash it = (ContractHash)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClasses().get(clazz.getName()), (Object)true)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        return client.orThrow(t, (Function0)new Function0<ContractBootstrapException>(clazz){
            final /* synthetic */ Class<T> $clazz;
            {
                this.$clazz = $clazz;
                super(0);
            }

            @NotNull
            public final ContractBootstrapException invoke() {
                return new ContractBootstrapException("Unable to find ContractHash instance to match " + this.$clazz.getName() + ", please verify you are running a Provenance bootstrapped JAR.");
            }
        });
    }

    private final ProtoHash getProtoHash(ContractHash contractHash, Class<?> clazz) {
        Object t;
        Client client;
        block1: {
            Iterable iterable = protoHashes;
            client = this;
            Iterable iterable2 = iterable;
            for (Object t2 : iterable2) {
                ProtoHash it = (ProtoHash)t2;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getUuid(), (Object)contractHash.getUuid()) && Intrinsics.areEqual(it.getClasses().get(clazz.getName()), (Object)true))) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        return client.orThrow(t, (Function0)new Function0<ContractBootstrapException>(clazz){
            final /* synthetic */ Class<?> $clazz;
            {
                this.$clazz = $clazz;
                super(0);
            }

            @NotNull
            public final ContractBootstrapException invoke() {
                return new ContractBootstrapException("Unable to find ProtoHash instance to match " + this.$clazz.getName() + ", please verify you are running a Provenance bootstrapped JAR.");
            }
        });
    }

    private final <T, X extends Throwable> T orThrow(T $this$orThrow, Function0<? extends X> supplier) {
        T t = $this$orThrow;
        if (t == null) {
            throw (Throwable)supplier.invoke();
        }
        return t;
    }

    @Override
    public void close() {
        this.inner.close();
    }

    public final boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.inner.awaitTermination(timeout, unit);
    }

    static {
        ServiceLoader<ContractHash> serviceLoader = ServiceLoader.load(ContractHash.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        contractHashes = CollectionsKt.toList((Iterable)serviceLoader);
        ServiceLoader<ProtoHash> serviceLoader2 = ServiceLoader.load(ProtoHash.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader2, (String)"load(...)");
        protoHashes = CollectionsKt.toList((Iterable)serviceLoader2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/provenance/scope/sdk/Client$Companion;", "", "()V", "contractHashes", "", "Lio/provenance/scope/contract/contracts/ContractHash;", "kotlin.jvm.PlatformType", "protoHashes", "Lio/provenance/scope/contract/proto/ProtoHash;", "sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

