/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import io.provenance.metadata.v1.Party;
import io.provenance.metadata.v1.Record;
import io.provenance.metadata.v1.RecordWrapper;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.metadata.v1.SessionWrapper;
import io.provenance.scope.contract.proto.Commons;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.contract.proto.Specifications;
import io.provenance.scope.encryption.ecies.ECUtils;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.encryption.model.SigningAndEncryptionPublicKeys;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.objectstore.client.CachedOsClient;
import io.provenance.scope.objectstore.client.ObjectHash;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.proto.PK;
import io.provenance.scope.proto.Util;
import io.provenance.scope.sdk.AffiliateRepository;
import io.provenance.scope.sdk.Client;
import io.provenance.scope.sdk.ClientKt;
import io.provenance.scope.sdk.ContractSpecMapper;
import io.provenance.scope.sdk.extensions.ProvenanceKt;
import io.provenance.scope.util.ExtensionsKt;
import io.provenance.scope.util.UuidExtensionsKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002DEB\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B}\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0015\u0012\u0006\u0010\u0018\u001a\u00020\u0015\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\u0010\u001cJ\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\nH\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u0002022\b\b\u0002\u00109\u001a\u00020:J\b\u0010;\u001a\u00020<H\u0002J\u0014\u0010=\u001a\u00020>*\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J$\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020<2\b\u0010C\u001a\u0004\u0018\u00010\u00132\u0006\u00109\u001a\u00020:H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$R\u0011\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010$R\u0011\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lio/provenance/scope/sdk/Session;", "", "builder", "Lio/provenance/scope/sdk/Session$Builder;", "(Lio/provenance/scope/sdk/Session$Builder;)V", "participants", "Ljava/util/HashMap;", "Lio/provenance/scope/contract/proto/Specifications$PartyType;", "Lio/provenance/scope/encryption/model/SigningAndEncryptionPublicKeys;", "proposedRecords", "", "Lcom/google/protobuf/Message;", "client", "Lio/provenance/scope/sdk/Client;", "contractSpec", "Lio/provenance/scope/contract/proto/Specifications$ContractSpec;", "provenanceReference", "Lio/provenance/scope/contract/proto/Commons$ProvenanceReference;", "scope", "Lio/provenance/metadata/v1/ScopeResponse;", "executionUuid", "Ljava/util/UUID;", "scopeUuid", "sessionUuid", "scopeSpecUuid", "dataAccessKeys", "", "Ljava/security/PublicKey;", "(Ljava/util/HashMap;Ljava/util/HashMap;Lio/provenance/scope/sdk/Client;Lio/provenance/scope/contract/proto/Specifications$ContractSpec;Lio/provenance/scope/contract/proto/Commons$ProvenanceReference;Lio/provenance/metadata/v1/ScopeResponse;Ljava/util/UUID;Ljava/util/UUID;Ljava/util/UUID;Ljava/util/UUID;Ljava/util/Set;)V", "getClient", "()Lio/provenance/scope/sdk/Client;", "getContractSpec", "()Lio/provenance/scope/contract/proto/Specifications$ContractSpec;", "getDataAccessKeys", "()Ljava/util/Set;", "getExecutionUuid", "()Ljava/util/UUID;", "getParticipants", "()Ljava/util/HashMap;", "getProposedRecords", "getProvenanceReference", "()Lio/provenance/scope/contract/proto/Commons$ProvenanceReference;", "getScope", "()Lio/provenance/metadata/v1/ScopeResponse;", "getScopeSpecUuid", "getScopeUuid", "getSessionUuid", "stagedProposedProtos", "", "isMatchingRecord", "", "inputRecord", "Lio/provenance/scope/contract/proto/Contracts$Record$Builder;", "recordName", "packageContract", "Lio/provenance/scope/contract/proto/Envelopes$Envelope;", "mainNet", "affiliateRepository", "Lio/provenance/scope/sdk/AffiliateRepository;", "populateContract", "Lio/provenance/scope/contract/proto/Contracts$Contract;", "populateRecord", "", "Lio/provenance/scope/contract/proto/Contracts$Contract$Builder;", "record", "Lio/provenance/scope/contract/proto/Contracts$Record;", "toAudience", "scopeResponse", "Builder", "PermissionUpdater", "sdk"})
@SourceDebugExtension(value={"SMAP\nSessionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionBuilder.kt\nio/provenance/scope/sdk/Session\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,601:1\n766#2:602\n857#2:603\n858#2:605\n1855#2:606\n766#2:607\n857#2,2:608\n1855#2,2:610\n1856#2:612\n1194#2,2:613\n1222#2,4:615\n1549#2:625\n1620#2,3:626\n1549#2:629\n1620#2,3:630\n766#2:633\n857#2,2:634\n1360#2:636\n1446#2,5:637\n1855#2,2:642\n1549#2:644\n1620#2,3:645\n288#2,2:648\n1549#2:650\n1620#2,3:651\n1549#2:654\n1620#2,3:655\n1#3:604\n215#4,2:619\n125#4:621\n152#4,3:622\n*S KotlinDebug\n*F\n+ 1 SessionBuilder.kt\nio/provenance/scope/sdk/Session\n*L\n374#1:602\n374#1:603\n374#1:605\n375#1:606\n378#1:607\n378#1:608,2\n382#1:610,2\n375#1:612\n410#1:613,2\n410#1:615,4\n465#1:625\n465#1:626,3\n468#1:629\n468#1:630,3\n470#1:633\n470#1:634,2\n470#1:636\n470#1:637,5\n474#1:642,2\n497#1:644\n497#1:645,3\n524#1:648,2\n546#1:650\n546#1:651,3\n548#1:654\n548#1:655,3\n411#1:619,2\n431#1:621\n431#1:622,3\n*E\n"})
public final class Session {
    @NotNull
    private final HashMap<Specifications.PartyType, SigningAndEncryptionPublicKeys> participants;
    @NotNull
    private final HashMap<String, Message> proposedRecords;
    @NotNull
    private final Client client;
    @NotNull
    private final Specifications.ContractSpec contractSpec;
    @NotNull
    private final Commons.ProvenanceReference provenanceReference;
    @Nullable
    private final ScopeResponse scope;
    @NotNull
    private final UUID executionUuid;
    @NotNull
    private final UUID scopeUuid;
    @NotNull
    private final UUID sessionUuid;
    @NotNull
    private final UUID scopeSpecUuid;
    @NotNull
    private final Set<PublicKey> dataAccessKeys;
    @NotNull
    private final List<Message> stagedProposedProtos;

    public Session(@NotNull HashMap<Specifications.PartyType, SigningAndEncryptionPublicKeys> participants, @NotNull HashMap<String, Message> proposedRecords, @NotNull Client client, @NotNull Specifications.ContractSpec contractSpec, @NotNull Commons.ProvenanceReference provenanceReference, @Nullable ScopeResponse scope, @NotNull UUID executionUuid, @NotNull UUID scopeUuid, @NotNull UUID sessionUuid, @NotNull UUID scopeSpecUuid, @NotNull Set<? extends PublicKey> dataAccessKeys) {
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter(proposedRecords, (String)"proposedRecords");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)contractSpec, (String)"contractSpec");
        Intrinsics.checkNotNullParameter((Object)provenanceReference, (String)"provenanceReference");
        Intrinsics.checkNotNullParameter((Object)executionUuid, (String)"executionUuid");
        Intrinsics.checkNotNullParameter((Object)scopeUuid, (String)"scopeUuid");
        Intrinsics.checkNotNullParameter((Object)sessionUuid, (String)"sessionUuid");
        Intrinsics.checkNotNullParameter((Object)scopeSpecUuid, (String)"scopeSpecUuid");
        Intrinsics.checkNotNullParameter(dataAccessKeys, (String)"dataAccessKeys");
        this.participants = participants;
        this.proposedRecords = proposedRecords;
        this.client = client;
        this.contractSpec = contractSpec;
        this.provenanceReference = provenanceReference;
        this.scope = scope;
        this.executionUuid = executionUuid;
        this.scopeUuid = scopeUuid;
        this.sessionUuid = sessionUuid;
        this.scopeSpecUuid = scopeSpecUuid;
        this.dataAccessKeys = dataAccessKeys;
        this.stagedProposedProtos = new ArrayList();
    }

    @NotNull
    public final HashMap<Specifications.PartyType, SigningAndEncryptionPublicKeys> getParticipants() {
        return this.participants;
    }

    @NotNull
    public final HashMap<String, Message> getProposedRecords() {
        return this.proposedRecords;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final Specifications.ContractSpec getContractSpec() {
        return this.contractSpec;
    }

    @NotNull
    public final Commons.ProvenanceReference getProvenanceReference() {
        return this.provenanceReference;
    }

    @Nullable
    public final ScopeResponse getScope() {
        return this.scope;
    }

    @NotNull
    public final UUID getExecutionUuid() {
        return this.executionUuid;
    }

    @NotNull
    public final UUID getScopeUuid() {
        return this.scopeUuid;
    }

    @NotNull
    public final UUID getSessionUuid() {
        return this.sessionUuid;
    }

    @NotNull
    public final UUID getScopeSpecUuid() {
        return this.scopeSpecUuid;
    }

    @NotNull
    public final Set<PublicKey> getDataAccessKeys() {
        return this.dataAccessKeys;
    }

    private Session(Builder builder) {
        HashMap<Specifications.PartyType, SigningAndEncryptionPublicKeys> hashMap = builder.getParticipants();
        HashMap<String, Message> hashMap2 = builder.getProposedRecords();
        Client client = builder.getClient();
        Intrinsics.checkNotNull((Object)client);
        Specifications.ContractSpec contractSpec = builder.getContractSpec();
        Intrinsics.checkNotNull((Object)contractSpec);
        Commons.ProvenanceReference provenanceReference = builder.getProvenanceReference();
        Intrinsics.checkNotNull((Object)provenanceReference);
        this(hashMap, hashMap2, client, contractSpec, provenanceReference, builder.getScope(), builder.getExecutionUuid(), builder.getScopeUuid(), builder.getSessionUuid(), builder.getScopeSpecUuid(), CollectionsKt.toSet((Iterable)builder.getDataAccessKeys()));
    }

    /*
     * WARNING - void declaration
     */
    private final Contracts.Contract populateContract() {
        Object object;
        Iterable iterable;
        Object it;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        Contracts.Contract.Builder builder = ContractSpecMapper.INSTANCE.newContract(this.contractSpec).setDefinition(this.contractSpec.getDefinition());
        builder.setInvoker(PK.SigningAndEncryptionPublicKeys.newBuilder().setEncryptionPublicKey(PK.PublicKey.newBuilder().setPublicKeyBytes(ByteString.copyFrom((byte[])ECUtils.INSTANCE.convertPublicKeyToBytes(this.client.getAffiliate().getEncryptionKeyRef().getPublicKey()))).build()).setSigningPublicKey(PK.PublicKey.newBuilder().setPublicKeyBytes(ByteString.copyFrom((byte[])ECUtils.INSTANCE.convertPublicKeyToBytes(this.client.getAffiliate().getSigningKeyRef().getPublicKey()))).build()).build());
        List list = this.contractSpec.getFunctionSpecsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFunctionSpecsList(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object v2;
            block11: {
                element$iv$iv = iterator.next();
                it = (Specifications.FunctionSpec)element$iv$iv;
                boolean bl = false;
                List list2 = it.getInputSpecsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInputSpecsList(...)");
                iterable = list2;
                for (Object t : iterable) {
                    Commons.DefinitionSpec it2 = (Commons.DefinitionSpec)t;
                    boolean bl2 = false;
                    if (!(it2.getType() == Commons.DefinitionSpec.Type.PROPOSED)) continue;
                    v2 = t;
                    break block11;
                }
                v2 = null;
            }
            boolean bl = v2 != null;
            if (!bl) continue;
            collection.add(element$iv$iv);
        }
        Object $this$forEach$iv = (List)collection;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object it3;
            Object element$iv$iv2;
            Iterator $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Object t = $this$filterTo$iv$iv.next();
            Specifications.FunctionSpec considerationSpec = (Specifications.FunctionSpec)t;
            boolean bl = false;
            List list3 = builder.getConsiderationsBuilderList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getConsiderationsBuilderList(...)");
            element$iv$iv = list3;
            it = ContractSpecMapper.INSTANCE;
            boolean $i$f$filter2 = false;
            iterable = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            Iterator it2 = $this$filterTo$iv$iv2.iterator();
            while (it2.hasNext()) {
                element$iv$iv2 = it2.next();
                it3 = (Contracts.ConsiderationProto.Builder)element$iv$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it3.getConsiderationName(), (Object)considerationSpec.getFuncName())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Contracts.ConsiderationProto.Builder consideration = (Contracts.ConsiderationProto.Builder)((ContractSpecMapper)it).orThrowNotFound(CollectionsKt.single((List)((List)destination$iv$iv2)), "Function not found for " + considerationSpec.getFuncName());
            List list4 = considerationSpec.getInputSpecsList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getInputSpecsList(...)");
            Iterable $this$forEach$iv2 = list4;
            boolean $i$f$forEach2 = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Contracts.ConsiderationProto.Builder builder2;
                Object v7;
                Commons.DefinitionSpec defSpec;
                block12: {
                    Object element$iv2 = $this$filterTo$iv$iv2.next();
                    defSpec = (Commons.DefinitionSpec)element$iv2;
                    boolean bl4 = false;
                    List list5 = consideration.getInputsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getInputsList(...)");
                    element$iv$iv2 = list5;
                    it3 = element$iv$iv2.iterator();
                    while (it3.hasNext()) {
                        Object bl3 = it3.next();
                        Contracts.ProposedRecord it4 = (Contracts.ProposedRecord)bl3;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it4.getName(), (Object)defSpec.getName())) continue;
                        v7 = bl3;
                        break block12;
                    }
                    v7 = null;
                }
                if (v7 != null) continue;
                Message message2 = this.proposedRecords.get(defSpec.getName());
                if (message2 == null) continue;
                Object it4 = element$iv$iv2 = message2;
                boolean bl6 = false;
                Contracts.ProposedRecord.Builder builder3 = Contracts.ProposedRecord.newBuilder().setClassname(defSpec.getResourceLocation().getClassname());
                byte[] byArray = it4.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                byte[] byArray2 = UtilKt.sha256((byte[])byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"sha256(...)");
                Contracts.ConsiderationProto.Builder it5 = builder2 = consideration.addInputs(builder3.setHash(UtilKt.base64EncodeString((byte[])byArray2)).setName(defSpec.getName()).build());
                boolean bl7 = false;
                if (it5.getResult().getResultValue() == 2) {
                    it5.clearResult();
                }
                if (this.stagedProposedProtos.contains(it4)) continue;
                Intrinsics.checkNotNull((Object)it4);
                this.stagedProposedProtos.add((Message)it4);
            }
        }
        if (this.scope != null) {
            List list6 = this.scope.getRecordsList();
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getRecordsList(...)");
            Iterable $this$associateBy$iv = list6;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable3 = $this$associateBy$iv;
            Object destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv3 : iterable3) {
                void it6;
                RecordWrapper $i$f$forEach2 = (RecordWrapper)element$iv$iv3;
                object = destination$iv$iv3;
                boolean bl = false;
                object.put(it6.getRecord().getName(), element$iv$iv3);
            }
            $this$forEach$iv = destination$iv$iv3;
            $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                destination$iv$iv3 = entry;
                boolean bl = false;
                String recordName = (String)destination$iv$iv3.getKey();
                RecordWrapper scopeRecord = (RecordWrapper)destination$iv$iv3.getValue();
                Intrinsics.checkNotNull((Object)builder);
                Contracts.Record.Builder builder4 = Contracts.Record.newBuilder().setName(recordName);
                Commons.Location.Builder builder5 = Commons.Location.newBuilder().setClassname(scopeRecord.getRecord().getProcess().getName());
                Commons.ProvenanceReference.Builder builder6 = Commons.ProvenanceReference.newBuilder().setScopeUuid(UuidExtensionsKt.toProtoUuid((String)ProvenanceKt.uuid(this.scope)));
                Record record = scopeRecord.getRecord();
                Intrinsics.checkNotNullExpressionValue((Object)record, (String)"getRecord(...)");
                Commons.ProvenanceReference.Builder builder7 = builder6.setSessionUuid(UuidExtensionsKt.toProtoUuid((String)ProvenanceKt.sessionUuid(record)));
                Record record2 = scopeRecord.getRecord();
                Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"getRecord(...)");
                Contracts.Record record3 = builder4.setDataLocation(builder5.setRef(builder7.setHash(UtilKt.base64EncodeString((byte[])ProvenanceKt.resultHash(record2))))).build();
                Intrinsics.checkNotNullExpressionValue((Object)record3, (String)"build(...)");
                this.populateRecord(builder, record3);
            }
        }
        Map $this$map$iv = this.participants;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Contracts.Recital.Builder builder8;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            object = destination$iv$iv4;
            boolean bl = false;
            Specifications.PartyType partyType = (Specifications.PartyType)entry.getKey();
            SigningAndEncryptionPublicKeys keys = (SigningAndEncryptionPublicKeys)entry.getValue();
            Contracts.Recital.Builder recitalBuilder = builder8 = Contracts.Recital.newBuilder().setSignerRole(partyType);
            boolean bl8 = false;
            recitalBuilder.setSigner(PK.SigningAndEncryptionPublicKeys.newBuilder().setSigningPublicKey(ClientKt.toPublicKeyProto(keys.getSigningPublicKey())).setEncryptionPublicKey(ClientKt.toPublicKeyProto(keys.getEncryptionPublicKey())).build());
            object.add(builder8.build());
        }
        List formattedStagedRecitals = (List)destination$iv$iv4;
        builder.clearRecitals();
        builder.addAllRecitals((Iterable)formattedStagedRecitals);
        int n = builder.getTimesExecuted();
        builder.setTimesExecuted(n + 1);
        Contracts.Contract contract = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)contract, (String)"build(...)");
        return contract;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Envelopes.Envelope packageContract(boolean mainNet, @NotNull AffiliateRepository affiliateRepository) {
        Envelopes.Envelope.Builder builder;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SessionWrapper sessionWrapper;
        Iterable element$iv2;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)affiliateRepository, (String)"affiliateRepository");
        if (this.scope != null) {
            Iterator $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            Iterable iterable = this.dataAccessKeys;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it;
                Object object4 = (PublicKey)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeyExtensionsKt.getAddress((PublicKey)it, (boolean)mainNet));
            }
            Set sessionDataAccessAddresses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv3 = sessionDataAccessAddresses;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)affiliateRepository.tryGetCorrespondingAffiliateAddress((String)it)));
            }
            $this$map$iv3 = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(it.getSecond() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            item$iv$iv2 = $this$flatMapTo$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                Object element$iv$iv;
                element$iv$iv = item$iv$iv2.next();
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond()), TuplesKt.to((Object)it.getSecond(), (Object)it.getFirst())};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Map correspondingAddressLookup = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            ProtocolStringList protocolStringList = this.scope.getScope().getScope().getDataAccessList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getDataAccessList(...)");
            Iterable $this$forEach$iv = (Iterable)protocolStringList;
            boolean $i$f$forEach = false;
            for (Iterable element$iv2 : $this$forEach$iv) {
                String correspondingAddress;
                String address = (String)((Object)element$iv2);
                boolean bl = false;
                if (sessionDataAccessAddresses.contains(address) || (correspondingAddress = (String)correspondingAddressLookup.get(address)) != null && sessionDataAccessAddresses.contains(correspondingAddress)) continue;
                throw new IllegalStateException(address + " has data access in the existing scope but was not added to the data access list in this session.");
            }
        }
        Contracts.Contract contract = this.populateContract();
        PermissionUpdater permissionUpdater = new PermissionUpdater(this.client, contract, SetsKt.plus(this.toAudience(contract, this.scope, affiliateRepository), (Iterable)this.dataAccessKeys));
        Object object = Envelopes.Envelope.newBuilder().setExecutionUuid(UuidExtensionsKt.toProtoUuid((UUID)this.executionUuid)).setScopeSpecUuid(UuidExtensionsKt.toProtoUuid((UUID)this.scopeSpecUuid)).setNewScope(this.scope == null);
        Object object2 = this.scope;
        if (object2 != null && (object2 = object2.getSessionsList()) != null) {
            Object object3;
            block11: {
                element$iv2 = (Iterable)object2;
                collection = object;
                Iterable address = element$iv2;
                for (Object object4 : address) {
                    SessionWrapper it = (SessionWrapper)object4;
                    boolean bl = false;
                    String string = it.getSessionIdInfo().getSessionUuid();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionUuid(...)");
                    if (!Intrinsics.areEqual((Object)ExtensionsKt.toUuid((String)string), (Object)this.sessionUuid)) continue;
                    object3 = object4;
                    break block11;
                }
                object3 = null;
            }
            object = collection;
            sessionWrapper = (SessionWrapper)object3;
        } else {
            sessionWrapper = null;
        }
        Iterable $i$f$forEach = this.dataAccessKeys;
        collection = object.setNewSession(sessionWrapper == null);
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PublicKey bl = (PublicKey)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            collection2.add(ClientKt.toPublicKeyProto((PublicKey)it));
        }
        Envelopes.Envelope.Builder $this$packageContract_u24lambda_u2419 = builder = collection.addAllDataAccess((List)destination$iv$iv).setMainNet(mainNet).setContract(contract);
        boolean bl = false;
        Commons.ProvenanceReference.Builder builder2 = $this$packageContract_u24lambda_u2419.getRefBuilder().setScopeUuid(UuidExtensionsKt.toProtoUuid((UUID)this.scopeUuid)).setSessionUuid(UuidExtensionsKt.toProtoUuid((UUID)this.sessionUuid));
        byte[] byArray = contract.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = UtilKt.sha256((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"sha256(...)");
        builder2.setHash(UtilKt.base64EncodeString((byte[])byArray2)).build();
        if (this.scope != null) {
            $this$packageContract_u24lambda_u2419.setScope(Any.pack((Message)((Message)this.scope), (String)""));
        }
        Envelopes.Envelope envelope = builder.clearSignatures().build();
        permissionUpdater.saveConstructorArguments();
        Collection<Message> collection3 = this.proposedRecords.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"<get-values>(...)");
        permissionUpdater.saveProposedFacts(collection3);
        Intrinsics.checkNotNull((Object)envelope);
        return envelope;
    }

    public static /* synthetic */ Envelopes.Envelope packageContract$default(Session session, boolean bl, AffiliateRepository affiliateRepository, int n, Object object) {
        if ((n & 2) != 0) {
            affiliateRepository = new AffiliateRepository(bl);
        }
        return session.packageContract(bl, affiliateRepository);
    }

    private final void populateRecord(Contracts.Contract.Builder $this$populateRecord, Contracts.Record record) {
        block2: {
            Contracts.Record.Builder builder;
            Object v2;
            block1: {
                List list = $this$populateRecord.getInputsBuilderList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputsBuilderList(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Contracts.Record.Builder it = (Contracts.Record.Builder)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    String string = record.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!this.isMatchingRecord(it, string)) continue;
                    v2 = element$iv;
                    break block1;
                }
                v2 = null;
            }
            Contracts.Record.Builder builder2 = v2;
            if (builder2 == null) break block2;
            Contracts.Record.Builder $this$populateRecord_u24lambda_u2421 = builder = builder2;
            boolean bl = false;
            $this$populateRecord_u24lambda_u2421.setDataLocation(Commons.Location.newBuilder().setClassname(record.getDataLocation().getClassname()).setRef(Commons.ProvenanceReference.newBuilder().setSessionUuid(Util.UUID.newBuilder().setValueBytes(record.getDataLocation().getRef().getSessionUuid().getValueBytes()).build()).setHash(record.getDataLocation().getRef().getHash()).setScopeUuid(Util.UUID.newBuilder().setValueBytes(record.getDataLocation().getRef().getScopeUuid().getValueBytes()).build()).setName(record.getDataLocation().getRef().getName()).build()).build());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PublicKey> toAudience(Contracts.Contract $this$toAudience, ScopeResponse scopeResponse, AffiliateRepository affiliateRepository) {
        Iterable iterable;
        Collection collection;
        void $this$mapTo$iv$iv;
        List list = $this$toAudience.getRecitalsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Contracts.Recital recital = (Contracts.Recital)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PK.PublicKey publicKey = it.getSigner().getEncryptionPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getEncryptionPublicKey(...)");
            collection.add(UtilKt.toPublicKey((PK.PublicKey)publicKey));
        }
        Collection collection2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object object = scopeResponse;
        if (object != null && (object = object.getScope()) != null && (object = object.getScope()) != null && (object = object.getOwnersList()) != null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Object item$iv$iv;
            Iterable $i$f$mapTo2 = (Iterable)object;
            collection = collection2;
            boolean $i$f$map2 = false;
            item$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void owner;
                Party party = (Party)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl = false;
                String string = owner.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
                collection3.add(affiliateRepository.getAffiliateKeysByAddress(string).getEncryptionPublicKey());
            }
            collection2 = collection;
            iterable = (List)destination$iv$iv2;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return SetsKt.plus((Set)collection2, (Iterable)iterable);
    }

    private final boolean isMatchingRecord(Contracts.Record.Builder inputRecord, String recordName) {
        return Intrinsics.areEqual((Object)inputRecord.getName(), (Object)recordName) && Intrinsics.areEqual((Object)inputRecord.getDataLocation().getRef(), (Object)Commons.ProvenanceReference.getDefaultInstance());
    }

    public /* synthetic */ Session(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0015J\u0014\u0010:\u001a\u00020\u00002\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150<J\u001e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0015J\u0016\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020%J\u0006\u0010D\u001a\u00020EJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0003J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010G\u001a\u00020)J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020.J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0003J\u000e\u00107\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR6\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R6\u0010&\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u001e2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\"\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u001d\u001a\u0004\u0018\u00010.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001aR\u001e\u00103\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001aR\u001a\u00105\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u001a\"\u0004\b7\u0010\u001c\u00a8\u0006L"}, d2={"Lio/provenance/scope/sdk/Session$Builder;", "", "scopeSpecUuid", "Ljava/util/UUID;", "affiliateRepository", "Lio/provenance/scope/sdk/AffiliateRepository;", "(Ljava/util/UUID;Lio/provenance/scope/sdk/AffiliateRepository;)V", "client", "Lio/provenance/scope/sdk/Client;", "getClient", "()Lio/provenance/scope/sdk/Client;", "setClient", "(Lio/provenance/scope/sdk/Client;)V", "contractSpec", "Lio/provenance/scope/contract/proto/Specifications$ContractSpec;", "getContractSpec", "()Lio/provenance/scope/contract/proto/Specifications$ContractSpec;", "setContractSpec", "(Lio/provenance/scope/contract/proto/Specifications$ContractSpec;)V", "dataAccessKeys", "", "Ljava/security/PublicKey;", "getDataAccessKeys", "()Ljava/util/List;", "executionUuid", "getExecutionUuid", "()Ljava/util/UUID;", "setExecutionUuid", "(Ljava/util/UUID;)V", "<set-?>", "Ljava/util/HashMap;", "Lio/provenance/scope/contract/proto/Specifications$PartyType;", "Lio/provenance/scope/encryption/model/SigningAndEncryptionPublicKeys;", "participants", "getParticipants", "()Ljava/util/HashMap;", "", "Lcom/google/protobuf/Message;", "proposedRecords", "getProposedRecords", "provenanceReference", "Lio/provenance/scope/contract/proto/Commons$ProvenanceReference;", "getProvenanceReference", "()Lio/provenance/scope/contract/proto/Commons$ProvenanceReference;", "setProvenanceReference", "(Lio/provenance/scope/contract/proto/Commons$ProvenanceReference;)V", "Lio/provenance/metadata/v1/ScopeResponse;", "scope", "getScope", "()Lio/provenance/metadata/v1/ScopeResponse;", "getScopeSpecUuid", "scopeUuid", "getScopeUuid", "sessionUuid", "getSessionUuid", "setSessionUuid", "addDataAccessKey", "key", "addDataAccessKeys", "keys", "", "addParticipant", "party", "signingPublicKey", "encryptionPublicKey", "addProposedRecord", "name", "record", "build", "Lio/provenance/scope/sdk/Session;", "uuid", "provReference", "setScope", "scopeResponse", "setScopeUuid", "scopeUUID", "sdk"})
    @SourceDebugExtension(value={"SMAP\nSessionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionBuilder.kt\nio/provenance/scope/sdk/Session$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n1360#2:602\n1446#2,5:603\n766#2:608\n857#2,2:609\n1360#2:611\n1446#2,5:612\n766#2:617\n857#2,2:618\n288#2,2:620\n766#2:622\n857#2,2:623\n*S KotlinDebug\n*F\n+ 1 SessionBuilder.kt\nio/provenance/scope/sdk/Session$Builder\n*L\n207#1:602\n207#1:603,5\n208#1:608\n208#1:609,2\n210#1:611\n210#1:612,5\n211#1:617\n211#1:618,2\n214#1:620,2\n238#1:622\n238#1:623,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private final UUID scopeSpecUuid;
        @NotNull
        private final AffiliateRepository affiliateRepository;
        @NotNull
        private HashMap<String, Message> proposedRecords;
        @NotNull
        private HashMap<Specifications.PartyType, SigningAndEncryptionPublicKeys> participants;
        @Nullable
        private Client client;
        @Nullable
        private Specifications.ContractSpec contractSpec;
        @Nullable
        private Commons.ProvenanceReference provenanceReference;
        @NotNull
        private UUID scopeUuid;
        @Nullable
        private ScopeResponse scope;
        @NotNull
        private UUID executionUuid;
        @NotNull
        private UUID sessionUuid;
        @NotNull
        private final List<PublicKey> dataAccessKeys;

        public Builder(@NotNull UUID scopeSpecUuid, @NotNull AffiliateRepository affiliateRepository) {
            Intrinsics.checkNotNullParameter((Object)scopeSpecUuid, (String)"scopeSpecUuid");
            Intrinsics.checkNotNullParameter((Object)affiliateRepository, (String)"affiliateRepository");
            this.scopeSpecUuid = scopeSpecUuid;
            this.affiliateRepository = affiliateRepository;
            this.proposedRecords = new HashMap();
            this.participants = new HashMap();
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.scopeUuid = uUID;
            UUID uUID2 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
            this.executionUuid = uUID2;
            UUID uUID3 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"randomUUID(...)");
            this.sessionUuid = uUID3;
            this.dataAccessKeys = new ArrayList();
        }

        @NotNull
        public final UUID getScopeSpecUuid() {
            return this.scopeSpecUuid;
        }

        @NotNull
        public final HashMap<String, Message> getProposedRecords() {
            return this.proposedRecords;
        }

        @NotNull
        public final HashMap<Specifications.PartyType, SigningAndEncryptionPublicKeys> getParticipants() {
            return this.participants;
        }

        @Nullable
        public final Client getClient() {
            return this.client;
        }

        public final void setClient(@Nullable Client client) {
            this.client = client;
        }

        @Nullable
        public final Specifications.ContractSpec getContractSpec() {
            return this.contractSpec;
        }

        public final void setContractSpec(@Nullable Specifications.ContractSpec contractSpec) {
            this.contractSpec = contractSpec;
        }

        @Nullable
        public final Commons.ProvenanceReference getProvenanceReference() {
            return this.provenanceReference;
        }

        public final void setProvenanceReference(@Nullable Commons.ProvenanceReference provenanceReference) {
            this.provenanceReference = provenanceReference;
        }

        @NotNull
        public final UUID getScopeUuid() {
            return this.scopeUuid;
        }

        @Nullable
        public final ScopeResponse getScope() {
            return this.scope;
        }

        @NotNull
        public final UUID getExecutionUuid() {
            return this.executionUuid;
        }

        public final void setExecutionUuid(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.executionUuid = uUID;
        }

        @NotNull
        public final UUID getSessionUuid() {
            return this.sessionUuid;
        }

        public final void setSessionUuid(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.sessionUuid = uUID;
        }

        @NotNull
        public final List<PublicKey> getDataAccessKeys() {
            return this.dataAccessKeys;
        }

        @NotNull
        public final Session build() {
            return new Session(this, null);
        }

        @NotNull
        public final Builder setExecutionUuid(@NotNull UUID uuid) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Builder $this$setExecutionUuid_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setExecutionUuid_u24lambda_u240.executionUuid = uuid;
            return builder;
        }

        @NotNull
        public final Builder setSessionUuid(@NotNull UUID sessionUuid) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)sessionUuid, (String)"sessionUuid");
            Builder $this$setSessionUuid_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setSessionUuid_u24lambda_u241.sessionUuid = sessionUuid;
            return builder;
        }

        @NotNull
        public final Builder setContractSpec(@NotNull Specifications.ContractSpec contractSpec) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)contractSpec, (String)"contractSpec");
            Builder $this$setContractSpec_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setContractSpec_u24lambda_u242.contractSpec = contractSpec;
            return builder;
        }

        @NotNull
        public final Builder setProvenanceReference(@NotNull Commons.ProvenanceReference provReference) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)provReference, (String)"provReference");
            Builder $this$setProvenanceReference_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setProvenanceReference_u24lambda_u243.provenanceReference = provReference;
            return builder;
        }

        @NotNull
        public final Builder setClient(@NotNull Client client) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Builder $this$setClient_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$setClient_u24lambda_u244.client = client;
            return builder;
        }

        @NotNull
        public final Builder setScope(@NotNull ScopeResponse scopeResponse) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)scopeResponse, (String)"scopeResponse");
            Builder $this$setScope_u24lambda_u245 = builder = this;
            boolean bl = false;
            ProvenanceKt.validateRecordsRequested(ProvenanceKt.validateSessionsRequested(scopeResponse));
            $this$setScope_u24lambda_u245.scope = scopeResponse;
            String string = scopeResponse.getScope().getScopeIdInfo().getScopeUuid();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScopeUuid(...)");
            $this$setScope_u24lambda_u245.scopeUuid = ExtensionsKt.toUuid((String)string);
            return builder;
        }

        @NotNull
        public final Builder setScopeUuid(@NotNull UUID scopeUUID) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)scopeUUID, (String)"scopeUUID");
            Builder $this$setScopeUuid_u24lambda_u246 = builder = this;
            boolean bl = false;
            if ($this$setScopeUuid_u24lambda_u246.scope != null) {
                throw new IllegalStateException("Scope UUID cannot be set once the scope is already set");
            }
            $this$setScopeUuid_u24lambda_u246.scopeUuid = scopeUUID;
            return builder;
        }

        @NotNull
        public final Builder addDataAccessKeys(@NotNull Collection<? extends PublicKey> keys) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Builder $this$addDataAccessKeys_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$addDataAccessKeys_u24lambda_u247.dataAccessKeys.addAll(keys);
            return builder;
        }

        @NotNull
        public final Builder addDataAccessKey(@NotNull PublicKey key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$addDataAccessKey_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$addDataAccessKey_u24lambda_u248.dataAccessKeys.add(key);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addProposedRecord(@NotNull String name, @NotNull Message record) {
            Object t;
            ContractSpecMapper contractSpecMapper;
            Builder $this$addProposedRecord_u24lambda_u2415;
            Builder builder;
            block6: {
                void $this$firstOrNull$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable list$iv$iv;
                Specifications.ConditionSpec it;
                Iterable $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                $this$addProposedRecord_u24lambda_u2415 = builder = this;
                boolean bl = false;
                Object object = new List[2];
                Specifications.ContractSpec contractSpec = $this$addProposedRecord_u24lambda_u2415.contractSpec;
                Intrinsics.checkNotNull((Object)contractSpec);
                List list = contractSpec.getConditionSpecsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConditionSpecsList(...)");
                Iterable iterable = list;
                int n = 0;
                Object[] objectArray = object;
                contractSpecMapper = ContractSpecMapper.INSTANCE;
                boolean $i$f$flatMap = false;
                void var12_15 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (Specifications.ConditionSpec)element$iv$iv;
                    boolean bl2 = false;
                    List list2 = it.getInputSpecsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInputSpecsList(...)");
                    list$iv$iv = list2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                $this$flatMap$iv = list3;
                boolean $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Commons.DefinitionSpec)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it.getType() == Commons.DefinitionSpec.Type.PROPOSED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                objectArray[n] = list3 = (List)destination$iv$iv;
                Specifications.ContractSpec contractSpec2 = $this$addProposedRecord_u24lambda_u2415.contractSpec;
                Intrinsics.checkNotNull((Object)contractSpec2);
                List list4 = contractSpec2.getFunctionSpecsList();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getFunctionSpecsList(...)");
                $this$filter$iv = list4;
                n = 1;
                objectArray = object;
                $i$f$flatMap = false;
                $this$filterTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (Specifications.FunctionSpec)element$iv$iv;
                    boolean bl4 = false;
                    List list5 = it.getInputSpecsList();
                    Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getInputSpecsList(...)");
                    list$iv$iv = list5;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list3 = (List)destination$iv$iv;
                $this$flatMap$iv = list3;
                $i$f$filter = false;
                $this$flatMapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Commons.DefinitionSpec)element$iv$iv;
                    boolean bl5 = false;
                    if (!(it.getType() == Commons.DefinitionSpec.Type.PROPOSED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                objectArray[n] = list3 = (List)destination$iv$iv;
                object = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])object));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Commons.DefinitionSpec it2 = (Commons.DefinitionSpec)element$iv;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)name)) continue;
                    t = element$iv;
                    break block6;
                }
                t = null;
            }
            Commons.DefinitionSpec proposedSpec = contractSpecMapper.orThrowNotFound(t, "Can't find the proposed fact for " + name);
            if (!Intrinsics.areEqual((Object)proposedSpec.getResourceLocation().getClassname(), (Object)record.getDefaultInstanceForType().getClass().getName())) {
                boolean bl = false;
                String string = "Invalid proto message supplied for " + name + ". Expected: " + proposedSpec.getResourceLocation().getClassname() + " Received: " + record.getDefaultInstanceForType().getClass().getName();
                throw new IllegalArgumentException(string.toString());
            }
            ((Map)$this$addProposedRecord_u24lambda_u2415.proposedRecords).put(name, record);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder addParticipant(@NotNull Specifications.PartyType party, @NotNull PublicKey signingPublicKey, @NotNull PublicKey encryptionPublicKey) {
            SigningAndEncryptionPublicKeys signingAndEncryptionPublicKeys;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)party, (String)"party");
            Intrinsics.checkNotNullParameter((Object)signingPublicKey, (String)"signingPublicKey");
            Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
            Builder $this$addParticipant_u24lambda_u2418 = builder = this;
            boolean bl = false;
            Specifications.ContractSpec contractSpec = $this$addParticipant_u24lambda_u2418.contractSpec;
            Intrinsics.checkNotNull((Object)contractSpec);
            List list = contractSpec.getPartiesInvolvedList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPartiesInvolvedList(...)");
            Object object = list;
            ContractSpecMapper contractSpecMapper = ContractSpecMapper.INSTANCE;
            boolean $i$f$filter = false;
            void var10_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Specifications.PartyType it = (Specifications.PartyType)element$iv$iv;
                boolean bl2 = false;
                if (!(it == party)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            contractSpecMapper.orThrowNotFound(CollectionsKt.firstOrNull((List)((List)destination$iv$iv)), "Can't find participant for party type " + party);
            if ($this$addParticipant_u24lambda_u2418.participants.get(party) != null) {
                throw new ContractSpecMapper.ContractDefinitionException("Participant for party type " + party + " already exists in the participant list.");
            }
            object = $this$addParticipant_u24lambda_u2418.participants;
            SigningAndEncryptionPublicKeys it = signingAndEncryptionPublicKeys = new SigningAndEncryptionPublicKeys(signingPublicKey, encryptionPublicKey);
            boolean bl3 = false;
            $this$addParticipant_u24lambda_u2418.affiliateRepository.addAffiliate(it);
            object.put(party, signingAndEncryptionPublicKeys);
            return builder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/provenance/scope/sdk/Session$PermissionUpdater;", "", "client", "Lio/provenance/scope/sdk/Client;", "contract", "Lio/provenance/scope/contract/proto/Contracts$Contract;", "audience", "", "Ljava/security/PublicKey;", "(Lio/provenance/scope/sdk/Client;Lio/provenance/scope/contract/proto/Contracts$Contract;Ljava/util/Set;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "saveConstructorArguments", "", "saveProposedFacts", "stagedProposedProtos", "", "Lcom/google/protobuf/Message;", "sdk"})
    @SourceDebugExtension(value={"SMAP\nSessionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionBuilder.kt\nio/provenance/scope/sdk/Session$PermissionUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n766#2:602\n857#2,2:603\n1549#2:605\n1620#2,3:606\n1549#2:609\n1620#2,3:610\n1549#2:613\n1620#2,3:614\n*S KotlinDebug\n*F\n+ 1 SessionBuilder.kt\nio/provenance/scope/sdk/Session$PermissionUpdater\n*L\n567#1:602\n567#1:603,2\n568#1:605\n568#1:606,3\n590#1:609\n590#1:610,3\n597#1:613\n597#1:614,3\n*E\n"})
    public static final class PermissionUpdater {
        @NotNull
        private final Client client;
        @NotNull
        private final Contracts.Contract contract;
        @NotNull
        private final Set<PublicKey> audience;
        private final Logger log;

        public PermissionUpdater(@NotNull Client client, @NotNull Contracts.Contract contract, @NotNull Set<? extends PublicKey> audience) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
            Intrinsics.checkNotNullParameter(audience, (String)"audience");
            this.client = client;
            this.contract = contract;
            this.audience = audience;
            this.log = LoggerFactory.getLogger(this.getClass());
        }

        /*
         * WARNING - void declaration
         */
        public final void saveConstructorArguments() {
            void $this$mapTo$iv$iv;
            Contracts.Record record;
            Iterable $this$filterTo$iv$iv;
            List list = this.contract.getInputsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputsList(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                record = (Contracts.Record)element$iv$iv;
                boolean bl = false;
                String string = record.getDataLocation().getRef().getHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
                boolean bl2 = !StringsKt.isBlank((CharSequence)string);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                byte[] byArray;
                record = (Contracts.Record)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Client $this$saveConstructorArguments_u24lambda_u242_u24lambda_u241 = this.client;
                boolean bl3 = false;
                String string = record.getDataLocation().getRef().getHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
                byte[] hashBytes = UtilKt.base64Decode((String)string);
                byte[] obj = ((InputStream)$this$saveConstructorArguments_u24lambda_u242_u24lambda_u241.getInner().getOsClient().getJar(hashBytes, $this$saveConstructorArguments_u24lambda_u242_u24lambda_u241.getAffiliate().getEncryptionKeyRef()).get()).readAllBytes();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(obj);
                boolean loHash = hashBytes.length == 16;
                Intrinsics.checkNotNull((Object)obj);
                byte[] msgSha256 = UtilKt.sha256((byte[])obj);
                if (loHash) {
                    Intrinsics.checkNotNull((Object)msgSha256);
                    byArray = CollectionsKt.toByteArray((Collection)UtilKt.loBytes((byte[])msgSha256));
                } else {
                    byArray = msgSha256;
                }
                boolean useSha256 = Arrays.equals(byArray, hashBytes);
                collection.add(CachedOsClient.putJar$default((CachedOsClient)$this$saveConstructorArguments_u24lambda_u242_u24lambda_u241.getInner().getOsClient(), (InputStream)inputStream, (KeyRef)$this$saveConstructorArguments_u24lambda_u242_u24lambda_u241.getAffiliate().getSigningKeyRef(), (KeyRef)$this$saveConstructorArguments_u24lambda_u242_u24lambda_u241.getAffiliate().getEncryptionKeyRef(), (long)obj.length, this.audience, null, (boolean)useSha256, (boolean)loHash, (int)32, null));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }

        public final void saveProposedFacts(@NotNull Collection<? extends Message> stagedProposedProtos) {
            ListenableFuture it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(stagedProposedProtos, (String)"stagedProposedProtos");
            this.log.debug("Persisting " + stagedProposedProtos.size() + " record(s) to object store");
            Iterable $this$map$iv = stagedProposedProtos;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Message message2 = (Message)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CachedOsClient.putRecord$default((CachedOsClient)this.client.getInner().getOsClient(), (Message)it, (KeyRef)this.client.getAffiliate().getSigningKeyRef(), (KeyRef)this.client.getAffiliate().getEncryptionKeyRef(), this.audience, null, (boolean)false, (boolean)false, (int)112, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ListenableFuture)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ObjectHash)it.get());
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
    }
}

