/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk;

import io.provenance.scope.ContractEngine;
import io.provenance.scope.objectstore.client.CachedOsClient;
import io.provenance.scope.objectstore.client.OsClient;
import io.provenance.scope.sdk.AffiliateRepository;
import io.provenance.scope.sdk.ClientConfig;
import io.provenance.scope.sdk.mailbox.MailboxService;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lio/provenance/scope/sdk/SharedClient;", "Ljava/io/Closeable;", "config", "Lio/provenance/scope/sdk/ClientConfig;", "(Lio/provenance/scope/sdk/ClientConfig;)V", "affiliateRepository", "Lio/provenance/scope/sdk/AffiliateRepository;", "getAffiliateRepository", "()Lio/provenance/scope/sdk/AffiliateRepository;", "getConfig", "()Lio/provenance/scope/sdk/ClientConfig;", "contractEngine", "Lio/provenance/scope/ContractEngine;", "getContractEngine", "()Lio/provenance/scope/ContractEngine;", "mailboxService", "Lio/provenance/scope/sdk/mailbox/MailboxService;", "getMailboxService", "()Lio/provenance/scope/sdk/mailbox/MailboxService;", "osClient", "Lio/provenance/scope/objectstore/client/CachedOsClient;", "getOsClient", "()Lio/provenance/scope/objectstore/client/CachedOsClient;", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "close", "", "sdk"})
public final class SharedClient
implements Closeable {
    @NotNull
    private final ClientConfig config;
    @NotNull
    private final CachedOsClient osClient;
    @NotNull
    private final ContractEngine contractEngine;
    @NotNull
    private final AffiliateRepository affiliateRepository;
    @NotNull
    private final MailboxService mailboxService;

    public SharedClient(@NotNull ClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.osClient = new CachedOsClient(new OsClient(this.config.getOsGrpcUrl(), this.config.getOsGrpcDeadlineMs(), this.config.getOsChannelCustomizeFn(), this.config.getExtraHeaders()), this.config.getOsDecryptionWorkerThreads(), this.config.getOsConcurrencySize(), this.config.getCacheRecordSizeInBytes(), this.config.getCacheJarSizeInBytes());
        this.contractEngine = new ContractEngine(this.osClient, this.config.getDisableContractLogs());
        this.affiliateRepository = new AffiliateRepository(this.config.getMainNet());
        this.mailboxService = new MailboxService(this.osClient.getOsClient(), this.affiliateRepository);
    }

    @NotNull
    public final ClientConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final CachedOsClient getOsClient() {
        return this.osClient;
    }

    @NotNull
    public final ContractEngine getContractEngine() {
        return this.contractEngine;
    }

    @NotNull
    public final AffiliateRepository getAffiliateRepository() {
        return this.affiliateRepository;
    }

    @NotNull
    public final MailboxService getMailboxService() {
        return this.mailboxService;
    }

    @Override
    public void close() {
        this.osClient.getOsClient().close();
    }

    public final boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.osClient.getOsClient().awaitTermination(timeout, unit);
    }
}

