/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.provenance.metadata.v1.MsgAddScopeDataAccessRequest;
import io.provenance.metadata.v1.MsgWriteRecordRequest;
import io.provenance.metadata.v1.MsgWriteScopeRequest;
import io.provenance.metadata.v1.MsgWriteSessionRequest;
import io.provenance.metadata.v1.Party;
import io.provenance.metadata.v1.Record;
import io.provenance.metadata.v1.RecordInput;
import io.provenance.metadata.v1.RecordInputStatus;
import io.provenance.metadata.v1.RecordOutput;
import io.provenance.metadata.v1.Scope;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.encryption.ecies.ECUtils;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.proto.PK;
import io.provenance.scope.proto.Util;
import io.provenance.scope.sdk.ExecutionResult;
import io.provenance.scope.sdk.extensions.EnvelopeExtensionsKt;
import io.provenance.scope.util.ByteStringExtensionsKt;
import io.provenance.scope.util.ExtensionsKt;
import io.provenance.scope.util.MetadataAddress;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR)\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/provenance/scope/sdk/SignedResult;", "Lio/provenance/scope/sdk/ExecutionResult;", "envelopeState", "Lio/provenance/scope/contract/proto/Envelopes$EnvelopeState;", "(Lio/provenance/scope/contract/proto/Envelopes$EnvelopeState;)V", "contractSpecId", "Lio/provenance/scope/util/MetadataAddress;", "getEnvelopeState", "()Lio/provenance/scope/contract/proto/Envelopes$EnvelopeState;", "executionInfo", "", "Lkotlin/Triple;", "", "getExecutionInfo", "()Ljava/util/List;", "mainNet", "", "messages", "", "Lcom/google/protobuf/Message;", "getMessages", "parties", "Lio/provenance/metadata/v1/Party;", "kotlin.jvm.PlatformType", "sessionId", "Lcom/google/protobuf/ByteString;", "signers", "sdk"})
@SourceDebugExtension(value={"SMAP\nExecutionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionResult.kt\nio/provenance/scope/sdk/SignedResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1#2:160\n1549#3:161\n1620#3,3:162\n1549#3:165\n1620#3,3:166\n1549#3:169\n1620#3,3:170\n766#3:173\n857#3,2:174\n766#3:176\n857#3,2:177\n1549#3:179\n1620#3,2:180\n1549#3:182\n1620#3,3:183\n1622#3:186\n*S KotlinDebug\n*F\n+ 1 ExecutionResult.kt\nio/provenance/scope/sdk/SignedResult\n*L\n36#1:161\n36#1:162,3\n55#1:165\n55#1:166,3\n72#1:169\n72#1:170,3\n73#1:173\n73#1:174,2\n106#1:176\n106#1:177,2\n107#1:179\n107#1:180,2\n123#1:182\n123#1:183,3\n107#1:186\n*E\n"})
public final class SignedResult
extends ExecutionResult {
    @NotNull
    private final Envelopes.EnvelopeState envelopeState;
    private final boolean mainNet;
    @NotNull
    private final List<String> signers;
    @NotNull
    private final List<Party> parties;
    private final ByteString sessionId;
    @NotNull
    private final MetadataAddress contractSpecId;
    @NotNull
    private final List<Triple<String, String, String>> executionInfo;
    @NotNull
    private final List<Message> messages;

    /*
     * WARNING - void declaration
     */
    public SignedResult(@NotNull Envelopes.EnvelopeState envelopeState) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$messages_u24lambda_u2410;
        Object item$iv$iv;
        List uuid;
        Scope.Builder it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        void it2;
        Intrinsics.checkNotNullParameter((Object)envelopeState, (String)"envelopeState");
        super(null);
        this.envelopeState = envelopeState;
        this.mainNet = this.envelopeState.getResult().getMainNet();
        byte[] byArray = this.envelopeState.getResult().getContract().getInvoker().getSigningPublicKey().getPublicKeyBytes().toByteArray();
        SignedResult signedResult = this;
        boolean $i$a$-let-SignedResult$signers$22 = false;
        Intrinsics.checkNotNull((Object)it2);
        signedResult.signers = CollectionsKt.listOf((Object)KeyExtensionsKt.getAddress((PublicKey)ECUtils.convertBytesToPublicKey$default((ECUtils)ECUtils.INSTANCE, (byte[])it2, null, (int)2, null), (boolean)this.mainNet));
        List list = this.envelopeState.getResult().getContract().getRecitalsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
        Iterable iterable = list;
        signedResult = this;
        boolean $i$f$map22 = false;
        void $i$a$-let-SignedResult$signers$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            Contracts.Recital recital = (Contracts.Recital)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            Party.Builder builder = Party.newBuilder().setRoleValue(it.getSignerRoleValue());
            byte[] byArray2 = it.getSigner().getSigningPublicKey().getPublicKeyBytes().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            collection.add(builder.setAddress(KeyExtensionsKt.getAddress((PublicKey)ECUtils.convertBytesToPublicKey$default((ECUtils)ECUtils.INSTANCE, (byte[])byArray2, null, (int)2, null), (boolean)this.mainNet)).build());
        }
        signedResult.parties = (List)destination$iv$iv;
        Util.UUID uUID = this.envelopeState.getResult().getRef().getScopeUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getScopeUuid(...)");
        UUID uUID2 = ExtensionsKt.toUuid((Util.UUIDOrBuilder)((Util.UUIDOrBuilder)uUID));
        Util.UUID uUID3 = this.envelopeState.getResult().getRef().getSessionUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getSessionUuid(...)");
        this.sessionId = ByteStringExtensionsKt.toByteString((byte[])MetadataAddress.Companion.forSession(uUID2, ExtensionsKt.toUuid((Util.UUIDOrBuilder)((Util.UUIDOrBuilder)uUID3))).getBytes());
        String string = this.envelopeState.getResult().getContract().getSpec().getDataLocation().getRef().getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
        UUID $i$f$map22 = UtilKt.toUuid((byte[])UtilKt.base64Decode((String)string));
        signedResult = this;
        boolean bl = false;
        signedResult.contractSpecId = MetadataAddress.Companion.forContractSpecification((UUID)((Object)uuid));
        this.executionInfo = new ArrayList();
        uuid = $this$map$iv = (List)new ArrayList();
        signedResult = this;
        boolean $i$a$-apply-SignedResult$messages$22 = false;
        if (this.envelopeState.getResult().getNewScope()) {
            Iterator $this$mapTo$iv$iv3;
            Object item$iv$iv2;
            $this$messages_u24lambda_u2410_u24lambda_u244 = destination$iv$iv = MsgWriteScopeRequest.newBuilder();
            boolean bl2 = false;
            Scope.Builder builder = $this$messages_u24lambda_u2410_u24lambda_u244.getScopeBuilder();
            Util.UUID uUID4 = this.envelopeState.getResult().getRef().getScopeUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"getScopeUuid(...)");
            Scope.Builder builder2 = builder.setScopeId(ByteStringExtensionsKt.toByteString((byte[])MetadataAddress.Companion.forScope(ExtensionsKt.toUuid((Util.UUIDOrBuilder)((Util.UUIDOrBuilder)uUID4))).getBytes()));
            Util.UUID uUID5 = this.envelopeState.getResult().getScopeSpecUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"getScopeSpecUuid(...)");
            Scope.Builder builder3 = builder2.setSpecificationId(ByteStringExtensionsKt.toByteString((byte[])MetadataAddress.Companion.forScopeSpecification(ExtensionsKt.toUuid((Util.UUIDOrBuilder)((Util.UUIDOrBuilder)uUID5))).getBytes())).addAllOwners((Iterable)this.parties);
            List list2 = this.envelopeState.getResult().getDataAccessList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataAccessList(...)");
            item$iv$iv2 = list2;
            it = builder3;
            boolean $i$f$map = false;
            void var11_29 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv3.iterator();
            while (iterator.hasNext()) {
                void it3;
                item$iv$iv = iterator.next();
                PK.PublicKey publicKey = (PK.PublicKey)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it3);
                collection2.add(KeyExtensionsKt.getAddress((PublicKey)UtilKt.toPublicKey((PK.PublicKey)it3), (boolean)this.mainNet));
            }
            Scope.Builder builder4 = it.addAllDataAccess((Iterable)((List)destination$iv$iv2));
            Envelopes.Envelope envelope = this.envelopeState.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"getResult(...)");
            builder4.setValueOwnerAddress(EnvelopeExtensionsKt.getDefaultValueOwner(envelope, this.mainNet));
            MsgWriteScopeRequest msgWriteScopeRequest = destination$iv$iv.addAllSigners(this.signers).build();
            String string2 = this.envelopeState.getResult().getRef().getScopeUuid().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            String string3 = msgWriteScopeRequest.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            this.executionInfo.add((Triple<String, String, String>)new Triple((Object)string2, (Object)string3, (Object)"ScopeID: "));
            Intrinsics.checkNotNull((Object)msgWriteScopeRequest);
            $this$messages_u24lambda_u2410.add(msgWriteScopeRequest);
        } else {
            void $this$filterTo$iv$iv2;
            List $this$filter$iv2;
            void $this$mapTo$iv$iv4;
            Iterable $this$map$iv2;
            ScopeResponse scope = (ScopeResponse)this.envelopeState.getResult().getScope().unpack(ScopeResponse.class);
            List list3 = this.envelopeState.getResult().getDataAccessList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getDataAccessList(...)");
            $this$messages_u24lambda_u2410_u24lambda_u244 = list3;
            boolean $i$f$map = false;
            $this$map$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv4) {
                void it4;
                PK.PublicKey $i$f$mapTo2 = (PK.PublicKey)item$iv$iv3;
                Collection collection3 = destination$iv$iv3;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it4);
                collection3.add(KeyExtensionsKt.getAddress((PublicKey)UtilKt.toPublicKey((PK.PublicKey)it4), (boolean)this.mainNet));
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv4 = $this$filter$iv2;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String address = (String)element$iv$iv;
                boolean bl5 = false;
                if (!(!scope.getScope().getScope().getDataAccessList().contains((Object)address) && !Intrinsics.areEqual((Object)address, (Object)scope.getScope().getScope().getValueOwnerAddress()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List it5 = $this$filter$iv2 = (List)destination$iv$iv3;
            boolean bl6 = false;
            List list4 = !((Collection)it5).isEmpty() ? $this$filter$iv2 : null;
            if (list4 != null) {
                List addresses = list4;
                boolean bl7 = false;
                MsgAddScopeDataAccessRequest.Builder builder = MsgAddScopeDataAccessRequest.newBuilder();
                Util.UUID uUID6 = this.envelopeState.getResult().getRef().getScopeUuid();
                Intrinsics.checkNotNullExpressionValue((Object)uUID6, (String)"getScopeUuid(...)");
                destination$iv$iv3 = builder.setScopeId(ByteStringExtensionsKt.toByteString((byte[])MetadataAddress.Companion.forScope(ExtensionsKt.toUuid((Util.UUIDOrBuilder)((Util.UUIDOrBuilder)uUID6))).getBytes())).addAllDataAccess((Iterable)addresses).addAllSigners((Iterable)this.signers).build();
                Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv3, (String)"build(...)");
                $this$messages_u24lambda_u2410.add(destination$iv$iv3);
            }
        }
        if (this.envelopeState.getResult().getNewSession()) {
            Collection $this$messages_u24lambda_u2410_u24lambda_u249 = destination$iv$iv = MsgWriteSessionRequest.newBuilder();
            boolean bl8 = false;
            $this$messages_u24lambda_u2410_u24lambda_u249.getSessionBuilder().setSessionId(this.sessionId).setSpecificationId(ByteStringExtensionsKt.toByteString((byte[])this.contractSpecId.getBytes())).addAllParties((Iterable)this.parties).setName(this.envelopeState.getResult().getContract().getDefinition().getResourceLocation().getClassname());
            MsgWriteSessionRequest msgWriteSessionRequest = destination$iv$iv.addAllSigners(this.signers).build();
            String string4 = this.envelopeState.getResult().getRef().getSessionUuid().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getValue(...)");
            String string5 = msgWriteSessionRequest.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            this.executionInfo.add((Triple<String, String, String>)new Triple((Object)string4, (Object)string5, (Object)"Session ID: "));
            Intrinsics.checkNotNull((Object)msgWriteSessionRequest);
            $this$messages_u24lambda_u2410.add(msgWriteSessionRequest);
        }
        Collection collection4 = $this$map$iv;
        List list5 = this.envelopeState.getResult().getContract().getConsiderationsList();
        Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getConsiderationsList(...)");
        $this$map$iv = list5;
        collection = collection4;
        boolean $i$f$filter = false;
        void $i$a$-apply-SignedResult$messages$22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Contracts.ConsiderationProto)element$iv$iv;
            boolean bl9 = false;
            if (!(it.getResult().getResult() == Contracts.ExecutionResult.Result.PASS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<MsgWriteRecordRequest> collection5 = (List)destination$iv$iv;
        $this$filter$iv = collection5;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv5;
            void $this$map$iv3;
            MsgWriteRecordRequest.Builder builder;
            it = (Contracts.ConsiderationProto)item$iv$iv4;
            collection5 = destination$iv$iv;
            boolean bl10 = false;
            UUID uUID7 = this.contractSpecId.getPrimaryUuid();
            String string6 = it.getConsiderationName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getConsiderationName(...)");
            String specId = MetadataAddress.Companion.forRecordSpecification(uUID7, string6).toString();
            MsgWriteRecordRequest.Builder $this$messages_u24lambda_u2415_u24lambda_u2414 = builder = MsgWriteRecordRequest.newBuilder();
            boolean bl11 = false;
            Object $this$messages_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412 = item$iv$iv = $this$messages_u24lambda_u2415_u24lambda_u2414.getRecordBuilder();
            boolean $i$a$-apply-SignedResult$messages$3$msgWriteRecordRequest$1$22 = false;
            $this$messages_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412.getProcessBuilder().setHash(this.envelopeState.getResult().getContract().getDefinition().getResourceLocation().getRef().getHash()).setName(it.getResult().getOutput().getClassname()).setMethod(it.getConsiderationName());
            Record.Builder builder5 = item$iv$iv.setName(it.getResult().getOutput().getName()).setSessionId(this.sessionId);
            List list6 = it.getInputsList();
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getInputsList(...)");
            item$iv$iv = list6;
            Record.Builder builder6 = builder5;
            boolean $i$f$map3 = false;
            void $i$a$-apply-SignedResult$messages$3$msgWriteRecordRequest$1$22 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv5) {
                void input;
                Contracts.ProposedRecord proposedRecord = (Contracts.ProposedRecord)item$iv$iv5;
                Collection collection6 = destination$iv$iv4;
                boolean bl12 = false;
                collection6.add(RecordInput.newBuilder().setName(input.getName()).setTypeName(input.getClassname()).setHash(input.getHash()).setStatus(RecordInputStatus.RECORD_INPUT_STATUS_PROPOSED).build());
            }
            builder6.addAllInputs((Iterable)((List)destination$iv$iv4)).addOutputs(RecordOutput.newBuilder().setHash(it.getResult().getOutput().getHash()).setStatusValue(it.getResult().getResultValue()).build());
            MsgWriteRecordRequest msgWriteRecordRequest = builder.addAllSigners((Iterable)this.signers).addAllParties((Iterable)this.parties).build();
            String string7 = msgWriteRecordRequest.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
            this.executionInfo.add((Triple<String, String, String>)new Triple((Object)specId, (Object)string7, (Object)"Record ID: "));
            collection5.add(msgWriteRecordRequest);
        }
        collection5 = (List)destination$iv$iv;
        signedResult.messages = CollectionsKt.plus((Collection)collection, (Iterable)collection5);
    }

    @NotNull
    public final Envelopes.EnvelopeState getEnvelopeState() {
        return this.envelopeState;
    }

    @NotNull
    public final List<Triple<String, String, String>> getExecutionInfo() {
        return this.executionInfo;
    }

    @NotNull
    public final List<Message> getMessages() {
        return this.messages;
    }
}

