/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk.extensions;

import io.provenance.metadata.v1.Party;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.metadata.v1.ScopeWrapper;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.contract.proto.Specifications;
import io.provenance.scope.encryption.ecies.ECUtils;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.proto.Common;
import io.provenance.scope.proto.PK;
import io.provenance.scope.sdk.ExecutionResult;
import io.provenance.scope.sdk.FragmentResult;
import io.provenance.scope.sdk.SignedResult;
import io.provenance.scope.util.ValueOwnerException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"addSignature", "Lio/provenance/scope/contract/proto/Envelopes$EnvelopeState;", "envelope", "Lio/provenance/scope/contract/proto/Envelopes$Envelope;", "getDefaultValueOwner", "", "mainNet", "", "isSigned", "mergeInto", "Lio/provenance/scope/sdk/ExecutionResult;", "envelopeState", "sdk"})
@SourceDebugExtension(value={"SMAP\nEnvelopeExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvelopeExtensions.kt\nio/provenance/scope/sdk/extensions/EnvelopeExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n766#2:101\n857#2,2:102\n1549#2:104\n1620#2,3:105\n1549#2:108\n1620#2,3:109\n1549#2:112\n1620#2,3:113\n1726#2,3:116\n1855#2,2:120\n1#3:119\n*S KotlinDebug\n*F\n+ 1 EnvelopeExtensions.kt\nio/provenance/scope/sdk/extensions/EnvelopeExtensionsKt\n*L\n25#1:101\n25#1:102,2\n26#1:104\n26#1:105,3\n32#1:108\n32#1:109,3\n34#1:112\n34#1:113,3\n38#1:116,3\n86#1:120,2\n*E\n"})
public final class EnvelopeExtensionsKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean isSigned(@NotNull Envelopes.Envelope $this$isSigned) {
        boolean bl;
        block9: {
            void $this$mapTo$iv$iv;
            Iterable iterable;
            Collection collection;
            ScopeWrapper scopeWrapper;
            Collection collection2;
            List $this$mapTo$iv$iv2;
            Contracts.Recital it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$isSigned, (String)"<this>");
            ScopeResponse scopeResponse = io.provenance.scope.util.EnvelopeExtensionsKt.scopeOrNull((Envelopes.Envelope)$this$isSigned);
            List list = $this$isSigned.getContract().getRecitalsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Contracts.Recital)element$iv$iv;
                boolean bl2 = false;
                if (!it.hasSigner()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (Contracts.Recital)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                PK.PublicKey keyProto = PK.PublicKey.parseFrom((byte[])it.getSigner().getSigningPublicKey().toByteArray());
                byte[] byArray = keyProto.getPublicKeyBytes().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                collection2.add(KeyExtensionsKt.getAddress((PublicKey)ECUtils.convertBytesToPublicKey$default((ECUtils)ECUtils.INSTANCE, (byte[])byArray, null, (int)2, null), (boolean)$this$isSigned.getMainNet()));
            }
            Collection collection3 = (List)destination$iv$iv;
            if (scopeResponse != null && (scopeWrapper = scopeResponse.getScope()) != null && ($i$f$map = scopeWrapper.getScope()) != null && ($this$mapTo$iv$iv2 = $i$f$map.getOwnersList()) != null) {
                void $this$mapTo$iv$iv3;
                void $this$map$iv2;
                Object item$iv$iv;
                Iterable $i$f$mapTo2 = $this$mapTo$iv$iv2;
                collection2 = collection3;
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void it2;
                    collection = (Party)item$iv$iv2;
                    Collection collection4 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection4.add(it2.getAddress());
                }
                collection3 = collection2;
                iterable = (List)destination$iv$iv2;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            Set it3 = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection3, (Iterable)iterable));
            boolean bl5 = false;
            List list2 = $this$isSigned.getSignaturesList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSignaturesList(...)");
            Iterable $this$map$iv3 = list2;
            boolean $i$f$map3 = false;
            Iterable $i$f$map2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                Object item$iv$iv2;
                item$iv$iv2 = (Common.Signature)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl6 = false;
                PK.PublicKey keyProto = PK.PublicKey.parseFrom((byte[])it4.getSigner().getSigningPublicKey().toByteArray());
                byte[] byArray = keyProto.getPublicKeyBytes().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                collection.add(KeyExtensionsKt.getAddress((PublicKey)ECUtils.convertBytesToPublicKey$default((ECUtils)ECUtils.INSTANCE, (byte[])byArray, null, (int)2, null), (boolean)$this$isSigned.getMainNet()));
            }
            Set signatureAddresses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            Iterable $this$all$iv = it3;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String address = (String)element$iv;
                    boolean bl7 = false;
                    if (signatureAddresses.contains(address)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final Envelopes.EnvelopeState addSignature(@NotNull Envelopes.EnvelopeState $this$addSignature, @NotNull Envelopes.Envelope envelope) {
        Envelopes.EnvelopeState.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$addSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        if (!(envelope.getSignaturesCount() == 1)) {
            boolean bl = false;
            String string = "Executed contract must have a signature";
            throw new IllegalArgumentException(string.toString());
        }
        Envelopes.EnvelopeState.Builder $this$addSignature_u24lambda_u247 = builder = $this$addSignature.toBuilder();
        boolean bl = false;
        Envelopes.Envelope.Builder builder2 = $this$addSignature_u24lambda_u247.getResultBuilder();
        List list = envelope.getSignaturesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSignaturesList(...)");
        builder2.addSignatures((Common.Signature)CollectionsKt.first((List)list));
        Envelopes.EnvelopeState envelopeState = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)envelopeState, (String)"build(...)");
        return envelopeState;
    }

    @NotNull
    public static final ExecutionResult mergeInto(@NotNull Envelopes.Envelope $this$mergeInto, @NotNull Envelopes.EnvelopeState envelopeState) {
        Intrinsics.checkNotNullParameter((Object)$this$mergeInto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)envelopeState, (String)"envelopeState");
        Envelopes.EnvelopeState merged = EnvelopeExtensionsKt.addSignature(envelopeState, $this$mergeInto);
        Envelopes.Envelope envelope = merged.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)envelope, (String)"getResult(...)");
        return EnvelopeExtensionsKt.isSigned(envelope) ? (ExecutionResult)new SignedResult(merged) : (ExecutionResult)new FragmentResult(merged);
    }

    @NotNull
    public static final String getDefaultValueOwner(@NotNull Envelopes.Envelope $this$getDefaultValueOwner, boolean mainNet) {
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultValueOwner, (String)"<this>");
        if (!$this$getDefaultValueOwner.getContract().getInvoker().getSigningPublicKey().getPublicKeyBytes().isEmpty()) {
            Object v1;
            block6: {
                List list = $this$getDefaultValueOwner.getContract().getRecitalsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    Contracts.Recital it = (Contracts.Recital)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSigner().getSigningPublicKey().getPublicKeyBytes(), (Object)$this$getDefaultValueOwner.getContract().getInvoker().getSigningPublicKey().getPublicKeyBytes())) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            Contracts.Recital recital = v1;
            if (recital != null) {
                Contracts.Recital it = recital;
                boolean bl = false;
                PK.PublicKey publicKey = it.getSigner().getSigningPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getSigningPublicKey(...)");
                return KeyExtensionsKt.getAddress((PublicKey)KeyExtensionsKt.toPublicKey((PK.PublicKey)publicKey), (boolean)mainNet);
            }
        }
        Object[] objectArray = new Specifications.PartyType[]{Specifications.PartyType.OWNER, Specifications.PartyType.ORIGINATOR};
        List roleSearchOrder = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = roleSearchOrder;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Contracts.Recital recital;
            Object v4;
            block7: {
                Specifications.PartyType partyType = (Specifications.PartyType)element$iv;
                boolean bl = false;
                List list = $this$getDefaultValueOwner.getContract().getRecitalsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    Contracts.Recital it = (Contracts.Recital)t;
                    boolean bl2 = false;
                    if (!(it.getSignerRole() == partyType)) continue;
                    v4 = t;
                    break block7;
                }
                v4 = null;
            }
            if ((recital = (Contracts.Recital)v4) == null) continue;
            Contracts.Recital it = recital;
            boolean bl = false;
            PK.PublicKey publicKey = it.getSigner().getSigningPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getSigningPublicKey(...)");
            return KeyExtensionsKt.getAddress((PublicKey)KeyExtensionsKt.toPublicKey((PK.PublicKey)publicKey), (boolean)mainNet);
        }
        List list = $this$getDefaultValueOwner.getContract().getRecitalsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
        if (!((Collection)list).isEmpty()) {
            List list2 = $this$getDefaultValueOwner.getContract().getRecitalsList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRecitalsList(...)");
            PK.PublicKey publicKey = ((Contracts.Recital)CollectionsKt.first((List)list2)).getSigner().getSigningPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getSigningPublicKey(...)");
            return KeyExtensionsKt.getAddress((PublicKey)KeyExtensionsKt.toPublicKey((PK.PublicKey)publicKey), (boolean)mainNet);
        }
        throw new ValueOwnerException("no suitable party found to be value owner");
    }
}

