/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk.extensions;

import io.provenance.metadata.v1.Record;
import io.provenance.metadata.v1.RecordOutput;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.util.MetadataAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0005\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\r"}, d2={"recordsRequested", "", "Lio/provenance/metadata/v1/ScopeResponse;", "resultHash", "", "Lio/provenance/metadata/v1/Record;", "resultType", "", "sessionUuid", "sessionsRequested", "uuid", "validateRecordsRequested", "validateSessionsRequested", "sdk"})
@SourceDebugExtension(value={"SMAP\nProvenance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Provenance.kt\nio/provenance/scope/sdk/extensions/ProvenanceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class ProvenanceKt {
    @NotNull
    public static final String uuid(@NotNull ScopeResponse $this$uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$uuid, (String)"<this>");
        String string = $this$uuid.getScope().getScopeIdInfo().getScopeUuid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScopeUuid(...)");
        return string;
    }

    public static final boolean sessionsRequested(@NotNull ScopeResponse $this$sessionsRequested) {
        Intrinsics.checkNotNullParameter((Object)$this$sessionsRequested, (String)"<this>");
        return $this$sessionsRequested.getRequest().getIncludeSessions();
    }

    public static final boolean recordsRequested(@NotNull ScopeResponse $this$recordsRequested) {
        Intrinsics.checkNotNullParameter((Object)$this$recordsRequested, (String)"<this>");
        return $this$recordsRequested.getRequest().getIncludeRecords();
    }

    @NotNull
    public static final ScopeResponse validateSessionsRequested(@NotNull ScopeResponse $this$validateSessionsRequested) {
        ScopeResponse scopeResponse;
        Intrinsics.checkNotNullParameter((Object)$this$validateSessionsRequested, (String)"<this>");
        ScopeResponse $this$validateSessionsRequested_u24lambda_u240 = scopeResponse = $this$validateSessionsRequested;
        boolean bl = false;
        if (!ProvenanceKt.sessionsRequested($this$validateSessionsRequested_u24lambda_u240)) {
            throw new IllegalStateException("Provided scope must include sessions");
        }
        return scopeResponse;
    }

    @NotNull
    public static final ScopeResponse validateRecordsRequested(@NotNull ScopeResponse $this$validateRecordsRequested) {
        ScopeResponse scopeResponse;
        Intrinsics.checkNotNullParameter((Object)$this$validateRecordsRequested, (String)"<this>");
        ScopeResponse $this$validateRecordsRequested_u24lambda_u241 = scopeResponse = $this$validateRecordsRequested;
        boolean bl = false;
        if (!ProvenanceKt.recordsRequested($this$validateRecordsRequested_u24lambda_u241)) {
            throw new IllegalStateException("Provided scope must include records");
        }
        return scopeResponse;
    }

    @NotNull
    public static final String resultType(@NotNull Record $this$resultType) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        String string = $this$resultType.getProcess().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public static final byte[] resultHash(@NotNull Record $this$resultHash) {
        Intrinsics.checkNotNullParameter((Object)$this$resultHash, (String)"<this>");
        List list = $this$resultHash.getOutputsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutputsList(...)");
        String string = ((RecordOutput)CollectionsKt.first((List)list)).getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
        return UtilKt.base64Decode((String)string);
    }

    @NotNull
    public static final String sessionUuid(@NotNull Record $this$sessionUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$sessionUuid, (String)"<this>");
        byte[] it = $this$sessionUuid.getSessionId().toByteArray();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string = MetadataAddress.Companion.fromBytes(it).getPrimaryUuid().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

