/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk.mailbox;

import com.google.protobuf.Message;
import io.provenance.metadata.v1.Party;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.encryption.crypto.SignerImpl;
import io.provenance.scope.encryption.model.SigningAndEncryptionPublicKeys;
import io.provenance.scope.objectstore.client.OsClient;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.proto.PK;
import io.provenance.scope.proto.Util;
import io.provenance.scope.sdk.AffiliateRepository;
import io.provenance.scope.sdk.mailbox.MailboxMeta;
import io.provenance.scope.util.EnvelopeExtensionsKt;
import io.provenance.scope.util.ExtensionsKt;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J7\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0012\"\u00020\r\u00a2\u0006\u0002\u0010\u0013J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u0010J\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/provenance/scope/sdk/mailbox/MailboxService;", "", "osClient", "Lio/provenance/scope/objectstore/client/OsClient;", "affiliateRepository", "Lio/provenance/scope/sdk/AffiliateRepository;", "(Lio/provenance/scope/objectstore/client/OsClient;Lio/provenance/scope/sdk/AffiliateRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "error", "", "encryptionPublicKey", "Ljava/security/PublicKey;", "signer", "Lio/provenance/scope/encryption/crypto/SignerImpl;", "Lio/provenance/scope/contract/proto/Envelopes$EnvelopeError;", "audienceSigningPublicKeyFilter", "", "(Ljava/security/PublicKey;Lio/provenance/scope/encryption/crypto/SignerImpl;Lio/provenance/scope/contract/proto/Envelopes$EnvelopeError;[Ljava/security/PublicKey;)V", "audiencePublicKeys", "", "Lio/provenance/scope/encryption/model/SigningAndEncryptionPublicKeys;", "fragment", "envelope", "Lio/provenance/scope/contract/proto/Envelopes$Envelope;", "result", "sdk"})
@SourceDebugExtension(value={"SMAP\nMailboxService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailboxService.kt\nio/provenance/scope/sdk/mailbox/MailboxService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n766#2:122\n857#2,2:123\n1549#2:125\n1620#2,3:126\n1549#2:129\n1620#2,3:130\n819#2:133\n847#2,2:134\n1549#2:137\n1620#2,3:138\n1#3:136\n*S KotlinDebug\n*F\n+ 1 MailboxService.kt\nio/provenance/scope/sdk/mailbox/MailboxService\n*L\n41#1:118\n41#1:119,3\n45#1:122\n45#1:123,2\n47#1:125\n47#1:126,3\n90#1:129\n90#1:130,3\n91#1:133\n91#1:134,2\n112#1:137\n112#1:138,3\n*E\n"})
public final class MailboxService {
    @NotNull
    private final OsClient osClient;
    @NotNull
    private final AffiliateRepository affiliateRepository;
    private final Logger log;

    public MailboxService(@NotNull OsClient osClient, @NotNull AffiliateRepository affiliateRepository) {
        Intrinsics.checkNotNullParameter((Object)osClient, (String)"osClient");
        Intrinsics.checkNotNullParameter((Object)affiliateRepository, (String)"affiliateRepository");
        this.osClient = osClient;
        this.affiliateRepository = affiliateRepository;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void fragment(@NotNull PublicKey encryptionPublicKey, @NotNull SignerImpl signer, @NotNull Envelopes.Envelope envelope) {
        Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        v0 = envelope.getContract().getInvoker().getSigningPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getSigningPublicKey(...)");
        invokerPublicKey = UtilKt.toPublicKey((PK.PublicKey)v0);
        if (!Intrinsics.areEqual((Object)invokerPublicKey, (Object)signer.getPublicKey())) {
            return;
        }
        scope = EnvelopeExtensionsKt.scopeOrNull((Envelopes.Envelope)envelope);
        if (scope == null || (var7_6 = scope.getScope()) == null || (var8_7 /* !! */  = var7_6.getScope()) == null || (var9_8 = var8_7 /* !! */ .getOwnersList()) == null) ** GOTO lbl-1000
        var11_10 = var9_8;
        $i$f$map = false;
        var13_12 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var18_21 = (Party)item$iv$iv;
            var20_23 = destination$iv$iv;
            $i$a$-map-MailboxService$fragment$scopeOwners$1 = false;
            v1 = it.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getAddress(...)");
            var20_23.add(this.affiliateRepository.getAffiliateKeysByAddress(v1).getEncryptionPublicKey());
        }
        $this$map$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if ($this$map$iv != null) {
            v2 = $this$map$iv;
        } else lbl-1000:
        // 2 sources

        {
            v2 = SetsKt.emptySet();
        }
        scopeOwners = v2;
        v3 = envelope.getContract().getRecitalsList();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getRecitalsList(...)");
        var8_7 /* !! */  = v3;
        $i$f$filter = false;
        var10_25 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Contracts.Recital)element$iv$iv;
            $i$a$-filter-MailboxService$fragment$additionalAudiences$1 = false;
            if (!it.hasSigner()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Contracts.Recital)item$iv$iv;
            var20_23 = destination$iv$iv;
            $i$a$-map-MailboxService$fragment$additionalAudiences$2 = false;
            v4 = it.getSigner().getEncryptionPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getEncryptionPublicKey(...)");
            var20_23.add(UtilKt.toPublicKey((PK.PublicKey)v4));
        }
        additionalAudiences = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Iterable)scopeOwners);
        OsClient.put$default((OsClient)this.osClient, (Message)((Message)envelope), (PublicKey)encryptionPublicKey, (SignerImpl)signer, (Set)additionalAudiences, MailboxMeta.INSTANCE.getMAILBOX_REQUEST(), null, (boolean)false, (boolean)false, (int)224, null);
    }

    public final void result(@NotNull PublicKey encryptionPublicKey, @NotNull SignerImpl signer, @NotNull Envelopes.Envelope envelope) {
        Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        PK.PublicKey publicKey = envelope.getContract().getInvoker().getEncryptionPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getEncryptionPublicKey(...)");
        Set additionalAudiences = SetsKt.setOf((Object)UtilKt.toPublicKey((PK.PublicKey)publicKey));
        OsClient.put$default((OsClient)this.osClient, (Message)((Message)envelope), (PublicKey)encryptionPublicKey, (SignerImpl)signer, (Set)additionalAudiences, MailboxMeta.INSTANCE.getMAILBOX_RESPONSE(), null, (boolean)false, (boolean)false, (int)224, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(@NotNull PublicKey encryptionPublicKey, @NotNull SignerImpl signer, @NotNull Envelopes.EnvelopeError error, PublicKey ... audienceSigningPublicKeyFilter) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        SigningAndEncryptionPublicKeys it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)audienceSigningPublicKeyFilter, (String)"audienceSigningPublicKeyFilter");
        List list = error.getEnvelope().getContract().getRecitalsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Contracts.Recital recital = (Contracts.Recital)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PK.PublicKey publicKey = it.getSigner().getSigningPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getSigningPublicKey(...)");
            PublicKey publicKey2 = UtilKt.toPublicKey((PK.PublicKey)publicKey);
            PK.PublicKey publicKey3 = it.getSigner().getEncryptionPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey3, (String)"getEncryptionPublicKey(...)");
            collection.add(new SigningAndEncryptionPublicKeys(publicKey2, UtilKt.toPublicKey((PK.PublicKey)publicKey3)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (SigningAndEncryptionPublicKeys)element$iv$iv;
            boolean bl = false;
            if (ArraysKt.contains((Object[])audienceSigningPublicKeyFilter, (Object)it.getSigningPublicKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set $this$error_u24lambda_u245 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        this.error(encryptionPublicKey, signer, $this$error_u24lambda_u245, error);
    }

    /*
     * WARNING - void declaration
     */
    public final void error(@NotNull PublicKey encryptionPublicKey, @NotNull SignerImpl signer, @NotNull Collection<SigningAndEncryptionPublicKeys> audiencePublicKeys, @NotNull Envelopes.EnvelopeError error) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)encryptionPublicKey, (String)"encryptionPublicKey");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter(audiencePublicKeys, (String)"audiencePublicKeys");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.log.info("Sending error result env:{}, error type:{}", (Object)ExtensionsKt.toUuid((Util.UUIDOrBuilder)((Util.UUIDOrBuilder)io.provenance.scope.contract.proto.ExtensionsKt.getSessionUuid((Envelopes.EnvelopeError)error))), (Object)error.getType().name());
        OsClient osClient = this.osClient;
        UUID uUID = UUID.randomUUID();
        Iterable $this$map$iv = audiencePublicKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SigningAndEncryptionPublicKeys signingAndEncryptionPublicKeys = (SigningAndEncryptionPublicKeys)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEncryptionPublicKey());
        }
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map<String, String> map = MailboxMeta.INSTANCE.getMAILBOX_ERROR();
        Message message2 = (Message)error;
        Intrinsics.checkNotNull((Object)uUID);
        OsClient.put$default((OsClient)osClient, (Message)message2, (PublicKey)encryptionPublicKey, (SignerImpl)signer, (Set)set, map, (UUID)uUID, (boolean)false, (boolean)false, (int)192, null);
    }
}

