/*
 * Decompiled with CFR 0.152.
 */
package io.provenance.scope.sdk.mailbox;

import io.provenance.metadata.v1.Party;
import io.provenance.metadata.v1.ScopeResponse;
import io.provenance.scope.contract.proto.Contracts;
import io.provenance.scope.contract.proto.Envelopes;
import io.provenance.scope.contract.proto.ExtensionsKt;
import io.provenance.scope.encryption.crypto.SignatureInputStream;
import io.provenance.scope.encryption.domain.inputstream.DIMEInputStream;
import io.provenance.scope.encryption.model.KeyRef;
import io.provenance.scope.encryption.proto.Encryption;
import io.provenance.scope.encryption.util.EncryptedInputStreamKt;
import io.provenance.scope.encryption.util.KeyExtensionsKt;
import io.provenance.scope.objectstore.client.CachedOsClient;
import io.provenance.scope.objectstore.util.UtilKt;
import io.provenance.scope.proto.PK;
import io.provenance.scope.proto.Util;
import io.provenance.scope.sdk.mailbox.ExecutionErrorEvent;
import io.provenance.scope.sdk.mailbox.ExecutionRequestEvent;
import io.provenance.scope.sdk.mailbox.ExecutionResponseEvent;
import io.provenance.scope.sdk.mailbox.MailboxEvent;
import io.provenance.scope.sdk.mailbox.MailboxService;
import io.provenance.scope.sdk.proxy.Contract;
import io.provenance.scope.util.EnvelopeExtensionsKt;
import io.provenance.scope.util.UuidExtensionsKt;
import java.io.Closeable;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u0010\u00a2\u0006\u0002\u0010\u0011J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J(\u0010,\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020#H\u0016J,\u0010.\u001a\u00020#*\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010/\u001a\u00020\u000fH\u0002R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013\u00a8\u00060"}, d2={"Lio/provenance/scope/sdk/mailbox/PollAffiliateMailbox;", "Ljava/lang/Runnable;", "osClient", "Lio/provenance/scope/objectstore/client/CachedOsClient;", "mailboxService", "Lio/provenance/scope/sdk/mailbox/MailboxService;", "signingKeyRef", "Lio/provenance/scope/encryption/model/KeyRef;", "encryptionKeyRef", "maxResults", "", "mainNet", "", "handler", "Ljava/util/function/Function;", "Lio/provenance/scope/sdk/mailbox/MailboxEvent;", "Lio/provenance/scope/sdk/mailbox/MailHandlerFn;", "(Lio/provenance/scope/objectstore/client/CachedOsClient;Lio/provenance/scope/sdk/mailbox/MailboxService;Lio/provenance/scope/encryption/model/KeyRef;Lio/provenance/scope/encryption/model/KeyRef;IZLjava/util/function/Function;)V", "getEncryptionKeyRef", "()Lio/provenance/scope/encryption/model/KeyRef;", "getHandler", "()Ljava/util/function/Function;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMailboxService", "()Lio/provenance/scope/sdk/mailbox/MailboxService;", "getMainNet", "()Z", "getMaxResults", "()I", "getOsClient", "()Lio/provenance/scope/objectstore/client/CachedOsClient;", "getSigningKeyRef", "handleEnvelope", "", "mailUuid", "Ljava/util/UUID;", "mailboxKey", "", "ownerAudience", "Lio/provenance/scope/encryption/proto/Encryption$Audience;", "message", "", "handleEnvelopeError", "run", "handleSynchronousAck", "event", "sdk"})
@SourceDebugExtension(value={"SMAP\nPollAffiliateMailbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PollAffiliateMailbox.kt\nio/provenance/scope/sdk/mailbox/PollAffiliateMailbox\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1313#2:104\n1314#2:106\n1#3:105\n1549#4:107\n1620#4,3:108\n288#4,2:111\n*S KotlinDebug\n*F\n+ 1 PollAffiliateMailbox.kt\nio/provenance/scope/sdk/mailbox/PollAffiliateMailbox\n*L\n33#1:104\n33#1:106\n77#1:107\n77#1:108,3\n78#1:111,2\n*E\n"})
public final class PollAffiliateMailbox
implements Runnable {
    @NotNull
    private final CachedOsClient osClient;
    @NotNull
    private final MailboxService mailboxService;
    @NotNull
    private final KeyRef signingKeyRef;
    @NotNull
    private final KeyRef encryptionKeyRef;
    private final int maxResults;
    private final boolean mainNet;
    @NotNull
    private final Function<MailboxEvent, Boolean> handler;
    private final Logger log;

    public PollAffiliateMailbox(@NotNull CachedOsClient osClient, @NotNull MailboxService mailboxService, @NotNull KeyRef signingKeyRef, @NotNull KeyRef encryptionKeyRef, int maxResults, boolean mainNet, @NotNull Function<MailboxEvent, Boolean> handler) {
        Intrinsics.checkNotNullParameter((Object)osClient, (String)"osClient");
        Intrinsics.checkNotNullParameter((Object)mailboxService, (String)"mailboxService");
        Intrinsics.checkNotNullParameter((Object)signingKeyRef, (String)"signingKeyRef");
        Intrinsics.checkNotNullParameter((Object)encryptionKeyRef, (String)"encryptionKeyRef");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.osClient = osClient;
        this.mailboxService = mailboxService;
        this.signingKeyRef = signingKeyRef;
        this.encryptionKeyRef = encryptionKeyRef;
        this.maxResults = maxResults;
        this.mainNet = mainNet;
        this.handler = handler;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final CachedOsClient getOsClient() {
        return this.osClient;
    }

    @NotNull
    public final MailboxService getMailboxService() {
        return this.mailboxService;
    }

    @NotNull
    public final KeyRef getSigningKeyRef() {
        return this.signingKeyRef;
    }

    @NotNull
    public final KeyRef getEncryptionKeyRef() {
        return this.encryptionKeyRef;
    }

    public final int getMaxResults() {
        return this.maxResults;
    }

    public final boolean getMainNet() {
        return this.mainNet;
    }

    @NotNull
    public final Function<MailboxEvent, Boolean> getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Sequence $this$forEach$iv = this.osClient.getOsClient().mailboxGet(this.encryptionKeyRef.getPublicKey(), this.maxResults);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            UUID mailUuid = (UUID)pair.component1();
            DIMEInputStream dimeInputStream = (DIMEInputStream)pair.component2();
            try {
                Closeable closeable = (Closeable)dimeInputStream.getDecryptedPayload(this.encryptionKeyRef);
                Throwable throwable = null;
                try {
                    SignatureInputStream it = (SignatureInputStream)closeable;
                    boolean bl2 = false;
                    byte[] bytes = it.readAllBytes();
                    if (!it.verify()) {
                        this.log.warn("Mailbox object verification failure [public key: " + UtilKt.toHex((PublicKey)this.encryptionKeyRef.getPublicKey()) + "] [mailbox uuid: " + mailUuid + "]");
                        return;
                    }
                    this.log.trace("Received mail from poll " + mailUuid);
                    if (!dimeInputStream.getMetadata().containsKey("P8EAPI::TYPE")) {
                        Unit unit;
                        this.osClient.getOsClient().mailboxAck(mailUuid);
                        Unit it2 = unit = Unit.INSTANCE;
                        boolean bl3 = false;
                        this.log.warn("Unhandled mailbox meta: {}", (Object)dimeInputStream.getMetadata());
                        return;
                    }
                    String mailboxKey = (String)dimeInputStream.getMetadata().get("P8EAPI::TYPE");
                    String string = mailboxKey;
                    if (string == null) throw new IllegalStateException("Unhandled mailbox key: " + mailboxKey + " uuid: " + mailUuid);
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1969465216: {
                            if (string.equals("FRAGMENT_REQUEST")) {
                                n = 1;
                            }
                            break;
                        }
                        case 976813392: {
                            if (string.equals("FRAGMENT_RESPONSE")) {
                                n = 1;
                            }
                            break;
                        }
                        case 260178104: {
                            if (string.equals("ERROR_RESPONSE")) {
                                n = 2;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            Encryption.Audience audience = dimeInputStream.getDime().getOwner();
                            Intrinsics.checkNotNullExpressionValue((Object)audience, (String)"getOwner(...)");
                            Intrinsics.checkNotNull((Object)bytes);
                            this.handleEnvelope(mailUuid, mailboxKey, audience, bytes);
                            break;
                        }
                        case 2: {
                            Encryption.Audience audience = dimeInputStream.getDime().getOwner();
                            Intrinsics.checkNotNullExpressionValue((Object)audience, (String)"getOwner(...)");
                            Intrinsics.checkNotNull((Object)bytes);
                            this.handleEnvelopeError(mailUuid, mailboxKey, audience, bytes);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled mailbox key: " + mailboxKey + " uuid: " + mailUuid);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable t) {
                this.log.error("Error processing incoming mail", t);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleEnvelope(UUID mailUuid, String mailboxKey, Encryption.Audience ownerAudience, byte[] message2) {
        Object v7;
        Envelopes.Envelope envelope;
        block11: {
            void $this$firstOrNull$iv;
            Iterable iterable;
            Collection collection;
            void $this$mapTo$iv$iv;
            envelope = Envelopes.Envelope.parseFrom((byte[])message2);
            Intrinsics.checkNotNull((Object)envelope);
            ScopeResponse scope = EnvelopeExtensionsKt.scopeOrNull((Envelopes.Envelope)envelope);
            Util.UUID uUID = envelope.getRef().getSessionUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getSessionUuid(...)");
            if (!(UuidExtensionsKt.toUuidOrNull((Util.UUID)uUID) != null)) {
                boolean $i$a$-require-PollAffiliateMailbox$handleEnvelope$32 = false;
                String $i$a$-require-PollAffiliateMailbox$handleEnvelope$32 = "Session uuid is required";
                throw new IllegalArgumentException($i$a$-require-PollAffiliateMailbox$handleEnvelope$32.toString());
            }
            Util.UUID uUID2 = envelope.getExecutionUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getExecutionUuid(...)");
            if (!(UuidExtensionsKt.toUuidOrNull((Util.UUID)uUID2) != null)) {
                boolean $i$a$-require-PollAffiliateMailbox$handleEnvelope$42 = false;
                String $i$a$-require-PollAffiliateMailbox$handleEnvelope$42 = "Execution uuid is required";
                throw new IllegalArgumentException($i$a$-require-PollAffiliateMailbox$handleEnvelope$42.toString());
            }
            String className = envelope.getContract().getDefinition().getResourceLocation().getClassname();
            String signingAddress = KeyExtensionsKt.getAddress((PublicKey)this.signingKeyRef.getPublicKey(), (boolean)this.mainNet);
            List list = envelope.getContract().getRecitalsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRecitalsList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Contracts.Recital recital = (Contracts.Recital)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PK.PublicKey publicKey = it.getSigner().getSigningPublicKey();
                Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getSigningPublicKey(...)");
                collection.add(KeyExtensionsKt.getAddress((PublicKey)UtilKt.toPublicKey((PK.PublicKey)publicKey), (boolean)this.mainNet));
            }
            Collection collection2 = (List)destination$iv$iv;
            Object object = scope;
            if (object != null && (object = object.getScope()) != null && (object = object.getScope()) != null && (object = object.getOwnersList()) != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object item$iv$iv;
                Iterable $i$f$mapTo2 = (Iterable)object;
                collection = collection2;
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    Party party = (Party)item$iv$iv2;
                    Collection collection3 = destination$iv$iv2;
                    boolean bl = false;
                    collection3.add(it.getAddress());
                }
                collection2 = collection;
                iterable = (List)destination$iv$iv2;
            } else {
                iterable = CollectionsKt.emptyList();
            }
            $this$map$iv = CollectionsKt.plus((Collection)collection2, (Iterable)iterable);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)signingAddress)) continue;
                v7 = element$iv;
                break block11;
            }
            v7 = null;
        }
        EncryptedInputStreamKt.orThrow(v7, (Function0)((Function0)new Function0<IllegalStateException>(envelope, this){
            final /* synthetic */ Envelopes.Envelope $envelope;
            final /* synthetic */ PollAffiliateMailbox this$0;
            {
                this.$envelope = $envelope;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IllegalStateException invoke() {
                return new IllegalStateException("Can't find party on contract execution " + this.$envelope.getExecutionUuid().getValue() + " with key " + UtilKt.toHex((PublicKey)this.this$0.getSigningKeyRef().getPublicKey()));
            }
        }));
        String string = mailboxKey;
        if (Intrinsics.areEqual((Object)string, (Object)"FRAGMENT_REQUEST")) {
            this.handleSynchronousAck(this.handler, mailUuid, new ExecutionRequestEvent(new Contract(envelope, this.osClient, this.encryptionKeyRef)));
        } else if (Intrinsics.areEqual((Object)string, (Object)"FRAGMENT_RESPONSE")) {
            this.handleSynchronousAck(this.handler, mailUuid, new ExecutionResponseEvent(new Contract(envelope, this.osClient, this.encryptionKeyRef)));
        } else {
            throw new IllegalStateException("Should not happen, unhandled mailbox key:" + mailboxKey);
        }
    }

    private final void handleEnvelopeError(UUID mailUuid, String mailboxKey, Encryption.Audience ownerAudience, byte[] message2) {
        Envelopes.EnvelopeError error = Envelopes.EnvelopeError.parseFrom((byte[])message2);
        Intrinsics.checkNotNull((Object)error);
        if (!(UuidExtensionsKt.toUuidOrNull((Util.UUID)ExtensionsKt.getSessionUuid((Envelopes.EnvelopeError)error)) != null)) {
            boolean $i$a$-require-PollAffiliateMailbox$handleEnvelopeError$32 = false;
            String $i$a$-require-PollAffiliateMailbox$handleEnvelopeError$32 = "Session uuid is required";
            throw new IllegalArgumentException($i$a$-require-PollAffiliateMailbox$handleEnvelopeError$32.toString());
        }
        if (!(UuidExtensionsKt.toUuidOrNull((Util.UUID)ExtensionsKt.getExecutionUuid((Envelopes.EnvelopeError)error)) != null)) {
            boolean bl = false;
            String string = "Execution uuid is required";
            throw new IllegalArgumentException(string.toString());
        }
        this.handleSynchronousAck(this.handler, mailUuid, new ExecutionErrorEvent(new Contract(error, this.osClient, this.encryptionKeyRef)));
    }

    private final void handleSynchronousAck(Function<MailboxEvent, Boolean> $this$handleSynchronousAck, UUID mailUuid, MailboxEvent event) {
        Boolean bl = $this$handleSynchronousAck.apply(event);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"apply(...)");
        if (bl.booleanValue()) {
            this.osClient.getOsClient().mailboxAck(mailUuid);
        }
    }
}

