/*
 * Decompiled with CFR 0.152.
 */
package io.provis.testing;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.building.ModelCache;

public class DefaultModelCache
implements ModelCache {
    private final TeslaModelCache cache = new SimpleCache();

    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.cache.get(new Key(groupId, artifactId, version, tag));
    }

    public void put(String groupId, String artifactId, String version, String tag, Object data) {
        this.cache.put(new Key(groupId, artifactId, version, tag), data);
    }

    public class EntrySizeCache
    implements TeslaModelCache {
        private static final long MAX_SIZE = 10000L;
        private final Cache<Key, Object> cache = CacheBuilder.newBuilder().maximumSize(10000L).build();

        @Override
        public void put(Key key, Object data) {
            this.cache.put((Object)key, data);
        }

        @Override
        public Object get(Key key) {
            return this.cache.getIfPresent((Object)key);
        }
    }

    public class SimpleCache
    implements TeslaModelCache {
        private Map<Key, Object> cache = new ConcurrentHashMap<Key, Object>(256);

        @Override
        public void put(Key key, Object model) {
            this.cache.put(key, model);
        }

        @Override
        public Object get(Key key) {
            return this.cache.get(key);
        }
    }

    public static interface TeslaModelCache {
        public void put(Key var1, Object var2);

        public Object get(Key var1);
    }

    static class Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String tag;
        private final int hash;

        public Key(String groupId, String artifactId, String version, String tag) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.tag = tag;
            int h = 17;
            h = h * 31 + this.groupId.hashCode();
            h = h * 31 + this.artifactId.hashCode();
            h = h * 31 + this.version.hashCode();
            this.hash = h = h * 31 + this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Key that = (Key)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

