/*
 * Decompiled with CFR 0.152.
 */
package io.provis.testing;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import io.provis.testing.ConsoleRepositoryListener;
import io.provis.testing.ConsoleTransferListener;
import io.provis.testing.DefaultModelCache;
import io.provis.testing.DefaultModelResolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;

public class RemoteRepositoryGenerator {
    private final File localRepository;
    private final RemoteRepository remoteRepository;
    private final List<RemoteRepository> remoteRepositories;
    private final boolean forceResolutionToRemoteRepository;
    private final boolean retainChecksums;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final ModelBuilder modelBuilder;
    private final ArtifactResolver artifactResolver;
    private final RemoteRepositoryManager remoteRepositoryManager;

    public RemoteRepositoryGenerator(File localRepository, String remoteRepositoryUrl, boolean retainChecksums, boolean forceResolutionToRemoteRepository) throws Exception {
        this.localRepository = localRepository;
        this.remoteRepository = new RemoteRepository.Builder("central", "default", remoteRepositoryUrl).build();
        this.remoteRepositories = Lists.newArrayList();
        this.remoteRepositories.add(this.remoteRepository);
        this.retainChecksums = retainChecksums;
        this.forceResolutionToRemoteRepository = forceResolutionToRemoteRepository;
        ServiceLocator serviceLocator = this.serviceLocator();
        this.system = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        this.session = this.repositorySystemSession(this.system);
        this.modelBuilder = new DefaultModelBuilderFactory().newInstance();
        this.artifactResolver = (ArtifactResolver)serviceLocator.getService(ArtifactResolver.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)serviceLocator.getService(RemoteRepositoryManager.class);
    }

    public void generateFromCoordinates(String ... coordinates) throws Exception {
        FileUtils.deleteDirectory((File)this.localRepository);
        this.localRepository.mkdirs();
        String[] stringArray = coordinates;
        int n = coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            String coordinate = stringArray[n2];
            this.resolveTransitively(coordinate);
            ++n2;
        }
    }

    public void generateFromPomCoordinate(String coordinate) throws Exception {
        this.generateFromPomArtifact((Artifact)new DefaultArtifact(coordinate));
    }

    public void generateFromPom(File pomFile) throws Exception {
        Model model = this.resolveModel(pomFile);
        this.generateFromPomArtifact((Artifact)new DefaultArtifact(model.getGroupId(), model.getArtifactId(), model.getPackaging(), model.getVersion()));
    }

    public void generateFromPomArtifact(Artifact artifact) throws Exception {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(artifact);
        ArtifactDescriptorResult descriptorResult = this.system.readArtifactDescriptor(this.session, descriptorRequest);
        DependencyRequest dependencyRequest = this.dependencyRequest(artifact);
        for (Dependency dependency : descriptorResult.getDependencies()) {
            dependencyRequest.getCollectRequest().addDependency(dependency);
        }
        this.resolveTransitively(dependencyRequest);
    }

    private void resolveTransitively(String coordinate) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(coordinate);
        this.resolveTransitively(this.dependencyRequest((Artifact)artifact));
    }

    private void resolveTransitively(DependencyRequest dependencyRequest) throws Exception {
        List artifactResults = this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
        for (ArtifactResult artifactResult : artifactResults) {
            File file = artifactResult.getArtifact().getFile();
            file.delete();
            com.google.common.io.Files.write((CharSequence)file.getName(), (File)file, (Charset)Charsets.UTF_8);
        }
        if (!this.retainChecksums) {
            Files.walkFileTree(this.localRepository.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(".md5") || fileName.endsWith(".sha1")) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private DependencyRequest dependencyRequest(Artifact artifact) {
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "runtime"));
        collectRequest.addRepository(this.remoteRepository);
        return new DependencyRequest(collectRequest, classpathFlter);
    }

    public Model resolveModel(File pom) throws ModelBuildingException {
        RequestTrace trace = new RequestTrace((Object)pom);
        DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
        modelRequest.setValidationLevel(0);
        modelRequest.setProcessPlugins(false);
        modelRequest.setTwoPhaseBuilding(false);
        modelRequest.setSystemProperties(this.toProperties(this.session.getUserProperties(), this.session.getSystemProperties()));
        modelRequest.setModelCache((ModelCache)new DefaultModelCache());
        modelRequest.setModelResolver((ModelResolver)new DefaultModelResolver(this.session, trace.newChild((Object)modelRequest), "bithub", this.artifactResolver, this.remoteRepositoryManager, this.remoteRepositories));
        modelRequest.setPomFile(pom);
        return this.modelBuilder.build((ModelBuildingRequest)modelRequest).getEffectiveModel();
    }

    private DefaultRepositorySystemSession repositorySystemSession(RepositorySystem system) throws Exception {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.localRepository);
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        if (this.forceResolutionToRemoteRepository) {
            DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
            mirrorSelector.add("central", this.remoteRepository.getUrl(), "default", false, "external:*", "default");
            session.setMirrorSelector((MirrorSelector)mirrorSelector);
        }
        SimpleLocalRepositoryManagerFactory f = new SimpleLocalRepositoryManagerFactory();
        session.setLocalRepositoryManager(f.newInstance((RepositorySystemSession)session, localRepo));
        return session;
    }

    private ServiceLocator serviceLocator() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        return locator;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    public static void main(String[] args) throws Exception {
        RemoteRepositoryGenerator repoGenerator = new RemoteRepositoryGenerator(new File("/tmp/foo10"), "http://localhost:8081/nexus/content/groups/public/", false, true);
        repoGenerator.generateFromPomCoordinate("com.facebook.presto:presto-cassandra:0.74");
    }
}

