/*
 * Decompiled with CFR 0.152.
 */
package io.pst.mojo.s3.sta.uploader;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import io.pst.mojo.s3.sta.uploader.config.Include;
import io.pst.mojo.s3.sta.uploader.config.IncludedFilesListBuilder;
import io.pst.mojo.s3.sta.uploader.config.ManagedFile;
import io.pst.mojo.s3.sta.uploader.config.Metadata;
import io.pst.mojo.s3.sta.uploader.config.ParametersValidator;
import io.pst.mojo.s3.sta.uploader.util.ManagedFileContentEncoder;
import io.pst.mojo.s3.sta.uploader.util.ManagedFileContentEncoderGZipImpl;
import io.pst.mojo.s3.sta.uploader.util.ManagedFileContentEncoderPlainImpl;
import io.pst.mojo.s3.sta.uploader.util.S3Uploader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class S3StaticUploaderMojo
extends AbstractMojo {
    public static final String S3_URL = "s3.amazonaws.com";
    private String accessKey;
    private String secretKey;
    private String bucketName;
    private List<Include> includes;
    private List<String> excludes;
    private List<Metadata> metadatas;
    private File outputDirectory;
    private File inputDirectory;
    private File tmpDirectory;
    private boolean refreshExpiredObjects;
    private S3Uploader uploader;

    public void execute() throws MojoExecutionException {
        this.logParameters();
        this.validateParameters();
        this.uploader = new S3Uploader(new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey)), this.getLog(), this.buildContentEncodersList(), this.bucketName, this.inputDirectory, this.tmpDirectory, this.refreshExpiredObjects);
        List<ManagedFile> managedFiles = this.getManagedFiles();
        this.processManagedFiles(managedFiles);
    }

    private void logParameters() {
        this.getLog().info((CharSequence)("tmpDirectory " + this.tmpDirectory.getPath()));
        this.getLog().info((CharSequence)("inputDirectory " + this.inputDirectory.getPath()));
        this.getLog().info((CharSequence)("outputDirectory " + this.outputDirectory.getPath()));
        this.getLog().info((CharSequence)("includes " + this.includes));
        this.getLog().info((CharSequence)("excludes " + this.excludes));
        this.getLog().info((CharSequence)("metadatas " + this.metadatas));
    }

    private void validateParameters() throws MojoExecutionException {
        try {
            ParametersValidator validator = new ParametersValidator(this.includes, this.metadatas);
            validator.validate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("error found validating configuration", e);
        }
    }

    private List<ManagedFile> getManagedFiles() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"determining files that should be uploaded");
            this.getLog().info((CharSequence)"");
            IncludedFilesListBuilder includedFilesListBuilder = new IncludedFilesListBuilder(this.inputDirectory, this.includes, this.excludes, this.metadatas);
            return includedFilesListBuilder.build();
        }
        catch (IOException e) {
            throw new MojoExecutionException("cannot determine the files to be processed", (Exception)e);
        }
    }

    private void processManagedFiles(List<ManagedFile> managedFiles) throws MojoExecutionException {
        for (ManagedFile managedFile : managedFiles) {
            this.processManagedFile(managedFile);
        }
    }

    private void processManagedFile(ManagedFile managedFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("start processing file " + managedFile.getFilename() + " with metadata " + managedFile.getMetadata().toString()));
        try {
            this.uploader.uploadManagedFile(managedFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("cannot process file " + managedFile.getFilename(), e);
        }
        this.getLog().info((CharSequence)("finnish processing file " + managedFile.getFilename()));
        this.getLog().info((CharSequence)"");
    }

    private List<ManagedFileContentEncoder> buildContentEncodersList() {
        ArrayList<ManagedFileContentEncoder> contentEncoders = new ArrayList<ManagedFileContentEncoder>();
        contentEncoders.add(new ManagedFileContentEncoderGZipImpl(this.tmpDirectory));
        contentEncoders.add(new ManagedFileContentEncoderPlainImpl());
        return contentEncoders;
    }
}

