/*
 * Decompiled with CFR 0.152.
 */
package io.pst.mojo.s3.sta.uploader.config;

import io.pst.mojo.s3.sta.uploader.config.Bind;
import io.pst.mojo.s3.sta.uploader.config.ManagedFile;
import io.pst.mojo.s3.sta.uploader.config.Metadata;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractFilesListBuilder {
    protected final File inputDirectory;
    protected final List<String> excludes;
    protected final Map<String, Metadata> metadataMap;
    protected final Map<String, ManagedFile> fileMap;

    protected AbstractFilesListBuilder(File inputDirectory, List<String> excludes, List<Metadata> metadatas) {
        this.inputDirectory = inputDirectory;
        this.excludes = excludes;
        this.metadataMap = this.buildMetadataMap(metadatas);
        this.fileMap = new HashMap<String, ManagedFile>();
    }

    protected List<String> getMatchingFilesNames(String pattern) throws IOException {
        return FileUtils.getFileNames((File)this.inputDirectory, (String)pattern, (String)this.convertToString(this.excludes), (boolean)true, (boolean)false);
    }

    protected Metadata getMetadata(Bind bind) {
        Metadata metadata = this.metadataMap.get(bind.getMetadataId());
        if (metadata == null && (metadata = this.getDefaultMetadata()) == null) {
            throw new IllegalArgumentException("The metadata with Id " + bind.getMetadataId() + " is undefined.");
        }
        return metadata;
    }

    private Map<String, Metadata> buildMetadataMap(List<Metadata> metadatas) {
        HashMap<String, Metadata> map = new HashMap<String, Metadata>(metadatas.size());
        for (Metadata metadata : metadatas) {
            map.put(metadata.getId(), metadata);
        }
        return map;
    }

    private String convertToString(List<String> list) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((Object)iterator.next());
            ++i;
        }
        return builder.toString();
    }

    private Metadata getDefaultMetadata() {
        Metadata retMetadata = null;
        for (Metadata metadata : this.metadataMap.values()) {
            if (!metadata.isDefault()) continue;
            retMetadata = metadata;
        }
        return retMetadata;
    }
}

