/*
 * Decompiled with CFR 0.152.
 */
package io.pst.mojo.s3.sta.uploader.config;

import io.pst.mojo.s3.sta.uploader.config.AbstractFilesListBuilder;
import io.pst.mojo.s3.sta.uploader.config.ConstrainedFilesListBuilder;
import io.pst.mojo.s3.sta.uploader.config.Include;
import io.pst.mojo.s3.sta.uploader.config.ManagedFile;
import io.pst.mojo.s3.sta.uploader.config.Metadata;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IncludedFilesListBuilder
extends AbstractFilesListBuilder {
    private final List<Include> includes;
    private final ConstrainedFilesListBuilder constrainedFilesListBuilder;

    public IncludedFilesListBuilder(File inputDirectory, List<Include> includes, List<String> excludes, List<Metadata> metadatas) {
        super(inputDirectory, excludes, metadatas);
        this.includes = includes;
        this.constrainedFilesListBuilder = new ConstrainedFilesListBuilder(inputDirectory, excludes, metadatas);
    }

    public List<ManagedFile> build() throws IOException {
        for (Include include : this.includes) {
            this.collectIncludedFiles(include);
            this.replaceConstrainedFiles(include);
        }
        return new ArrayList<ManagedFile>(this.fileMap.values());
    }

    private void collectIncludedFiles(Include include) throws IOException {
        List<String> includedFileNames = this.getMatchingFilesNames(include.getBind().getPattern());
        for (String fileName : includedFileNames) {
            ManagedFile managedFile = new ManagedFile(fileName, this.getMetadata(include.getBind()));
            this.fileMap.put(fileName, managedFile);
        }
    }

    private void replaceConstrainedFiles(Include include) throws IOException {
        List<ManagedFile> constrainedFiles = this.constrainedFilesListBuilder.build(include);
        for (ManagedFile managedFile : constrainedFiles) {
            this.fileMap.put(managedFile.getFilename(), managedFile);
        }
    }
}

