/*
 * Decompiled with CFR 0.152.
 */
package io.pst.mojo.s3.sta.uploader.config;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import io.pst.mojo.s3.sta.uploader.config.Include;
import io.pst.mojo.s3.sta.uploader.config.Metadata;
import java.util.Arrays;
import java.util.List;

public class ParametersValidator {
    private static final String CONTENT_ENCODING_PLAIN = "plain";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final List<String> CONTENT_ENCODING_OPTIONS = Arrays.asList("plain", "gzip");
    private final List<Include> includes;
    private final List<Metadata> metadatas;

    public ParametersValidator(List<Include> includes, List<Metadata> metadatas) {
        this.includes = includes;
        this.metadatas = metadatas;
    }

    public void validate() {
        this.validateIncludes();
        this.validateMetadatas();
    }

    private void validateIncludes() {
        boolean existsDefaultMetadata = this.existsDefaultMetadata();
        for (Include include : this.includes) {
            if (existsDefaultMetadata || !this.isEmptyMetadataId(include.getBind().getMetadataId())) continue;
            throw new IllegalStateException("The include " + include.getBind().getPattern() + " does not define a metadataId and there isn't a default one");
        }
    }

    private void validateMetadatas() {
        for (Metadata metadata : this.metadatas) {
            this.validateContentEncoding(metadata);
            this.validateSecondsToExpire(metadata);
            this.validateCannedAcl(metadata);
        }
    }

    private boolean existsDefaultMetadata() {
        boolean existsDefaultMetadata = false;
        for (Metadata metadata : this.metadatas) {
            if (!metadata.isDefault()) continue;
            existsDefaultMetadata = true;
        }
        return existsDefaultMetadata;
    }

    private boolean isEmptyMetadataId(String metadataId) {
        return metadataId == null || "".equals(metadataId);
    }

    private void validateContentEncoding(Metadata metadata) {
        if (!CONTENT_ENCODING_OPTIONS.contains(metadata.getContentEncoding())) {
            throw new IllegalStateException("The metadata " + metadata.getId() + " has an invalid contentType");
        }
    }

    private void validateSecondsToExpire(Metadata metadata) {
        if (metadata.getSecondsToExpire() < 0) {
            throw new IllegalStateException("The metadata " + metadata.getId() + " has an invalid secondsToExpire");
        }
    }

    private void validateCannedAcl(Metadata metadata) {
        try {
            CannedAccessControlList acl = CannedAccessControlList.valueOf((String)metadata.getCannedAcl());
        }
        catch (Exception e) {
            throw new IllegalStateException("The metadata " + metadata.getId() + " has an invalid cannedAcl");
        }
    }
}

