/*
 * Decompiled with CFR 0.152.
 */
package io.pst.mojo.s3.sta.uploader.util;

import com.amazonaws.services.s3.model.ObjectMetadata;
import io.pst.mojo.s3.sta.uploader.config.ManagedFile;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.activation.MimetypesFileTypeMap;

public class ObjectMetadataBuilder {
    private static final MimetypesFileTypeMap mimeMap = new MimetypesFileTypeMap();
    private final ManagedFile managedFile;
    private final File encodedFile;
    private final ObjectMetadata objectMetadata;
    private Calendar calendar;
    private Date expiresReference;

    public ObjectMetadataBuilder(ManagedFile managedFile, File encodedFile) {
        this.managedFile = managedFile;
        this.encodedFile = encodedFile;
        this.objectMetadata = new ObjectMetadata();
    }

    public ObjectMetadata buildMetadata() {
        this.initializeCalendar();
        this.assignContentLength();
        this.assignLastModified();
        this.assignContentEncoding();
        this.assignContentType();
        this.assignCacheControl();
        this.assignContentDisposition();
        this.assignContentLanguage();
        this.assignExpires();
        this.assignWebsiteRedirectLocation();
        return this.objectMetadata;
    }

    Date getExpiresReference() {
        return this.expiresReference;
    }

    private void initializeCalendar() {
        this.calendar = Calendar.getInstance();
        this.expiresReference = this.calendar.getTime();
    }

    private void assignContentLength() {
        this.objectMetadata.setContentLength(this.encodedFile.length());
    }

    private void assignLastModified() {
        this.objectMetadata.setLastModified(new Date(this.encodedFile.lastModified()));
    }

    private void assignContentEncoding() {
        if (!this.encodedFile.equals(new File(this.managedFile.getFilename()))) {
            this.objectMetadata.setContentEncoding(this.managedFile.getMetadata().getContentEncoding());
        }
    }

    private void assignContentType() {
        String contentType = !this.isEmptyContentType(this.managedFile.getMetadata().getContentType()) ? this.managedFile.getMetadata().getContentType() : mimeMap.getContentType(this.managedFile.getFilename());
        this.objectMetadata.setContentType(contentType);
    }

    private void assignCacheControl() {
        if (this.managedFile.getMetadata().getCacheControl() != null) {
            this.objectMetadata.setCacheControl(this.managedFile.getMetadata().getCacheControl());
        }
    }

    private void assignContentDisposition() {
        if (this.managedFile.getMetadata().getContentDisposition() != null) {
            this.objectMetadata.setContentDisposition(this.managedFile.getMetadata().getContentDisposition());
        }
    }

    private void assignContentLanguage() {
        if (this.managedFile.getMetadata().getContentLanguage() != null) {
            this.objectMetadata.setHeader("Content-Disposition", (Object)this.managedFile.getMetadata().getContentLanguage());
        }
    }

    private void assignExpires() {
        if (this.managedFile.getMetadata().getSecondsToExpire() != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, this.managedFile.getMetadata().getSecondsToExpire());
            this.objectMetadata.setHttpExpiresDate(calendar.getTime());
        }
    }

    private void assignWebsiteRedirectLocation() {
        if (this.managedFile.getMetadata().getWebsiteRedirectLocation() != null) {
            this.objectMetadata.setHeader("x-amz-website-redirect-location", (Object)this.managedFile.getMetadata().getWebsiteRedirectLocation());
        }
    }

    private boolean isEmptyContentType(String contentType) {
        return contentType == null || "".equals(contentType);
    }
}

