/*
 * Decompiled with CFR 0.152.
 */
package io.pst.mojo.s3.sta.uploader.util;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import io.pst.mojo.s3.sta.uploader.config.ManagedFile;
import io.pst.mojo.s3.sta.uploader.util.ManagedFileContentEncoder;
import io.pst.mojo.s3.sta.uploader.util.ObjectMetadataBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.logging.Log;

public class S3Uploader {
    private final AmazonS3Client client;
    private final Log log;
    private final String bucketName;
    private final File inputDirectory;
    private final List<ManagedFileContentEncoder> contentEncoders;
    private final boolean refreshExpiredObjects;
    private final SimpleDateFormat httpDateFormat;

    public S3Uploader(AmazonS3Client client, Log log, List<ManagedFileContentEncoder> contentEncoders, String bucketName, File inputDirectory, File tmpDirectory, boolean refreshExpiredObjects) {
        this.client = client;
        this.log = log;
        this.bucketName = bucketName;
        this.inputDirectory = inputDirectory;
        this.contentEncoders = contentEncoders;
        this.refreshExpiredObjects = refreshExpiredObjects;
        this.httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        this.httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void uploadManagedFile(ManagedFile managedFile) throws Exception {
        File encodedFile = this.encodeManagedFile(managedFile);
        String remoteFileName = this.getRemoteFileName(managedFile);
        ObjectMetadata remoteMetadata = this.retrieveObjectMetadata(remoteFileName);
        ObjectMetadataBuilder objectMetadataBuilder = new ObjectMetadataBuilder(managedFile, encodedFile);
        ObjectMetadata objectMetadata = objectMetadataBuilder.buildMetadata();
        if (!this.isLocalFileSameAsRemote(encodedFile, remoteMetadata)) {
            this.log.info((CharSequence)("uploading file " + managedFile.getFilename() + " to " + this.bucketName));
            this.client.putObject(this.bucketName, remoteFileName, (InputStream)new FileInputStream(encodedFile), objectMetadata);
            this.setObjectAcl(managedFile, remoteFileName);
        } else if (this.refreshExpiredObjects && this.isMetadataExpired(remoteMetadata)) {
            this.log.info((CharSequence)("refreshing metadata for file " + managedFile.getFilename()));
            this.client.copyObject(this.buildCopyObjectRequest(remoteFileName, objectMetadata));
            this.setObjectAcl(managedFile, remoteFileName);
        } else {
            this.log.info((CharSequence)("the object " + remoteFileName + " stored at " + this.bucketName + " does not require update"));
        }
    }

    private String getRemoteFileName(ManagedFile managedFile) {
        File file = new File(managedFile.getFilename());
        return this.transformFileNameSlashesToS3(this.removeBasePath(file));
    }

    private boolean isLocalFileSameAsRemote(File localFile, ObjectMetadata remoteFileMetadata) throws Exception {
        return remoteFileMetadata != null && remoteFileMetadata.getETag().equals(this.calculateETag(localFile));
    }

    private String transformFileNameSlashesToS3(String fileName) {
        return fileName.replace("\\", "/");
    }

    private String removeBasePath(File file) {
        return file.getPath().substring(this.inputDirectory.getPath().length() + 1);
    }

    private ObjectMetadata retrieveObjectMetadata(String remoteFileName) {
        this.log.info((CharSequence)("retrieving metadata for " + remoteFileName));
        ObjectMetadata objectMetadata = null;
        try {
            objectMetadata = this.client.getObjectMetadata(this.bucketName, remoteFileName);
            this.logObjectMetadata(remoteFileName, objectMetadata);
        }
        catch (AmazonServiceException e) {
            this.log.info((CharSequence)"  no object metadata found");
        }
        return objectMetadata;
    }

    private String calculateETag(File file) throws Exception {
        return Hex.encodeHexString((byte[])DigestUtils.md5((InputStream)new FileInputStream(file)));
    }

    private File encodeManagedFile(ManagedFile managedFile) throws Exception {
        File encodedFile = null;
        for (ManagedFileContentEncoder contentEncoder : this.contentEncoders) {
            if (!contentEncoder.isContentEncodingSupported(managedFile.getMetadata().getContentEncoding())) continue;
            this.log.info((CharSequence)("contentEncoding file " + managedFile.getFilename()));
            encodedFile = contentEncoder.encode(managedFile);
        }
        return encodedFile;
    }

    private void setObjectAcl(ManagedFile managedFile, String remoteFileName) {
        CannedAccessControlList acl = CannedAccessControlList.valueOf((String)managedFile.getMetadata().getCannedAcl());
        this.client.setObjectAcl(this.bucketName, remoteFileName, acl);
    }

    private boolean isMetadataExpired(ObjectMetadata objectMetadata) {
        return objectMetadata.getHttpExpiresDate().before(new Date());
    }

    private void logObjectMetadata(String remoteFileName, ObjectMetadata objectMetadata) {
        this.log.info((CharSequence)("  ETag: " + objectMetadata.getETag()));
        this.log.info((CharSequence)("  ContentType: " + objectMetadata.getContentType()));
        this.log.info((CharSequence)("  CacheControl: " + objectMetadata.getCacheControl()));
        this.log.info((CharSequence)("  ContentEncoding: " + objectMetadata.getContentEncoding()));
        this.log.info((CharSequence)("  ContentLength: " + objectMetadata.getContentLength()));
        this.log.info((CharSequence)("  Expires: " + (objectMetadata.getHttpExpiresDate() == null ? "unknown" : this.httpDateFormat.format(objectMetadata.getHttpExpiresDate()))));
        this.log.info((CharSequence)("  LastModified: " + objectMetadata.getLastModified()));
    }

    private CopyObjectRequest buildCopyObjectRequest(String remoteFileName, ObjectMetadata objectMetadata) {
        return new CopyObjectRequest(this.bucketName, remoteFileName, this.bucketName, remoteFileName).withNewObjectMetadata(objectMetadata);
    }
}

