/*
 * Decompiled with CFR 0.152.
 */
package com.iab.omid.library.bytedance2.adsession;

import android.webkit.WebView;
import androidx.annotation.Nullable;
import com.iab.omid.library.bytedance2.adsession.AdSessionContextType;
import com.iab.omid.library.bytedance2.adsession.Partner;
import com.iab.omid.library.bytedance2.adsession.VerificationScriptResource;
import com.iab.omid.library.bytedance2.utils.g;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class AdSessionContext {
    private final Partner partner;
    private final WebView webView;
    private final List<VerificationScriptResource> verificationScriptResources;
    private final Map<String, VerificationScriptResource> injectedResourcesMap;
    private final String omidJsScriptContent;
    private final String customReferenceData;
    @Nullable
    private final String contentUrl;
    private final AdSessionContextType adSessionContextType;

    /*
     * WARNING - void declaration
     */
    private AdSessionContext(Partner object, WebView object22, String string, List<VerificationScriptResource> list, @Nullable String string2, String string3, AdSessionContextType adSessionContextType) {
        void var6_8;
        void var5_7;
        void var4_6;
        void var7_9;
        String string4;
        HashMap<String, VerificationScriptResource> hashMap;
        ArrayList<VerificationScriptResource> arrayList;
        ArrayList<VerificationScriptResource> arrayList2 = arrayList;
        arrayList = new ArrayList<VerificationScriptResource>();
        this.verificationScriptResources = arrayList2;
        HashMap<String, VerificationScriptResource> hashMap2 = hashMap;
        hashMap = new HashMap<String, VerificationScriptResource>();
        this.injectedResourcesMap = hashMap2;
        this.partner = object;
        this.webView = object22;
        this.omidJsScriptContent = string4;
        this.adSessionContextType = var7_9;
        if (var4_6 != null) {
            arrayList2.addAll((Collection<VerificationScriptResource>)var4_6);
            for (VerificationScriptResource verificationScriptResource : var4_6) {
                string4 = UUID.randomUUID().toString();
                this.injectedResourcesMap.put(string4, verificationScriptResource);
            }
        }
        AdSessionContext adSessionContext = this;
        adSessionContext.contentUrl = var5_7;
        adSessionContext.customReferenceData = var6_8;
    }

    public static AdSessionContext createHtmlAdSessionContext(Partner partner, WebView webView, @Nullable String string, String string2) {
        g.a(partner, "Partner is null");
        g.a(webView, "WebView is null");
        if (string2 != null) {
            g.a(string2, 256, "CustomReferenceData is greater than 256 characters");
        }
        AdSessionContextType adSessionContextType = AdSessionContextType.HTML;
        return new AdSessionContext(partner, webView, null, null, string, string2, adSessionContextType);
    }

    public static AdSessionContext createJavascriptAdSessionContext(Partner partner, WebView webView, @Nullable String string, String string2) {
        g.a(partner, "Partner is null");
        g.a(webView, "WebView is null");
        if (string2 != null) {
            g.a(string2, 256, "CustomReferenceData is greater than 256 characters");
        }
        AdSessionContextType adSessionContextType = AdSessionContextType.JAVASCRIPT;
        return new AdSessionContext(partner, webView, null, null, string, string2, adSessionContextType);
    }

    public static AdSessionContext createNativeAdSessionContext(Partner partner, String string, List<VerificationScriptResource> list, @Nullable String string2, String string3) {
        g.a(partner, "Partner is null");
        g.a((Object)string, "OM SDK JS script content is null");
        g.a(list, "VerificationScriptResources is null");
        if (string3 != null) {
            g.a(string3, 256, "CustomReferenceData is greater than 256 characters");
        }
        AdSessionContextType adSessionContextType = AdSessionContextType.NATIVE;
        return new AdSessionContext(partner, null, string, list, string2, string3, adSessionContextType);
    }

    public Partner getPartner() {
        return this.partner;
    }

    public List<VerificationScriptResource> getVerificationScriptResources() {
        return Collections.unmodifiableList(this.verificationScriptResources);
    }

    public Map<String, VerificationScriptResource> getInjectedResourcesMap() {
        return Collections.unmodifiableMap(this.injectedResourcesMap);
    }

    public WebView getWebView() {
        return this.webView;
    }

    @Nullable
    public String getContentUrl() {
        return this.contentUrl;
    }

    public String getCustomReferenceData() {
        return this.customReferenceData;
    }

    public String getOmidJsScriptContent() {
        return this.omidJsScriptContent;
    }

    public AdSessionContextType getAdSessionContextType() {
        return this.adSessionContextType;
    }
}

