/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.http.Format;
import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.labels.Pyroscope;
import io.pyroscope.labels.io.pyroscope.PyroscopeAsyncProfiler;
import io.pyroscope.one.profiler.AsyncProfiler;
import io.pyroscope.one.profiler.Counter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;

public final class Profiler {
    private final EventType eventType;
    private final String alloc;
    private final String lock;
    private final Duration interval;
    private final Format format;
    private final AsyncProfiler instance = PyroscopeAsyncProfiler.getAsyncProfiler();
    private final File tempJFRFile;

    Profiler(Config config) {
        this.alloc = config.profilingAlloc;
        this.lock = config.profilingLock;
        this.eventType = config.profilingEvent;
        this.interval = config.profilingInterval;
        this.format = config.format;
        if (this.format == Format.JFR) {
            try {
                this.tempJFRFile = File.createTempFile("pyroscope", ".jfr");
                this.tempJFRFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.tempJFRFile = null;
        }
    }

    public synchronized void start() {
        if (this.format == Format.JFR) {
            try {
                this.instance.execute(this.createJFRCommand());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.instance.start(this.eventType.id, this.interval.toNanos());
        }
    }

    public synchronized void stop() {
        this.instance.stop();
    }

    public synchronized Snapshot dumpProfile(Instant profilingIntervalStartTime) {
        return this.dumpImpl(profilingIntervalStartTime);
    }

    @Deprecated
    public synchronized Snapshot dump(Instant profilingIntervalStartTime) {
        this.instance.stop();
        Snapshot result = this.dumpImpl(profilingIntervalStartTime);
        this.start();
        return result;
    }

    private String createJFRCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append("start,event=").append(this.eventType.id);
        if (this.alloc != null && !this.alloc.isEmpty()) {
            sb.append(",alloc=").append(this.alloc);
        }
        if (this.lock != null && !this.lock.isEmpty()) {
            sb.append(",lock=").append(this.lock);
        }
        sb.append(",interval=").append(this.interval.toNanos()).append(",file=").append(this.tempJFRFile.toString());
        return sb.toString();
    }

    private Snapshot dumpImpl(Instant profilingIntervalStartTime) {
        byte[] data = this.format == Format.JFR ? this.dumpJFR() : this.instance.dumpCollapsed(Counter.SAMPLES).getBytes(StandardCharsets.UTF_8);
        return new Snapshot(this.format, this.eventType, profilingIntervalStartTime, data, Pyroscope.LabelsWrapper.dump());
    }

    private byte[] dumpJFR() {
        try {
            byte[] bytes = new byte[(int)this.tempJFRFile.length()];
            try (DataInputStream ds = new DataInputStream(new FileInputStream(this.tempJFRFile));){
                ds.readFully(bytes);
            }
            return bytes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

