/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.javaagent.Profiler;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.api.ProfilingScheduler;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.javaagent.impl.ContinuousProfilingScheduler;
import io.pyroscope.javaagent.impl.DefaultConfigurationProvider;
import io.pyroscope.javaagent.impl.DefaultLogger;
import io.pyroscope.javaagent.impl.PyroscopeExporter;
import io.pyroscope.javaagent.impl.QueuedExporter;
import java.lang.instrument.Instrumentation;
import java.util.concurrent.atomic.AtomicBoolean;

public class PyroscopeAgent {
    private static final AtomicBoolean started = new AtomicBoolean(false);

    public static void premain(String agentArgs, Instrumentation inst) {
        Config config;
        try {
            config = Config.build(DefaultConfigurationProvider.INSTANCE);
        }
        catch (Throwable e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.ERROR, "Error starting profiler %s", e);
            return;
        }
        PyroscopeAgent.start(config);
    }

    public static void start() {
        PyroscopeAgent.start(new Config.Builder().build());
    }

    public static void start(Config config) {
        PyroscopeAgent.start(new Options.Builder(config).build());
    }

    public static void start(Options options) {
        Logger logger = options.logger;
        if (!started.compareAndSet(false, true)) {
            logger.log(Logger.Level.ERROR, "Failed to start profiling - already started", new Object[0]);
            return;
        }
        logger.log(Logger.Level.DEBUG, "Config %s", options.config);
        try {
            options.scheduler.start(options.profiler);
            logger.log(Logger.Level.INFO, "Profiling started", new Object[0]);
        }
        catch (Throwable e) {
            logger.log(Logger.Level.ERROR, "Error starting profiler %s", e);
        }
    }

    public static class Options {
        final Config config;
        final ProfilingScheduler scheduler;
        final Logger logger;
        final Profiler profiler;

        private Options(Builder b) {
            this.config = b.config;
            this.profiler = b.profiler;
            this.scheduler = b.scheduler;
            this.logger = b.logger;
        }

        public static class Builder {
            final Config config;
            final Profiler profiler;
            Exporter exporter;
            ProfilingScheduler scheduler;
            Logger logger;

            public Builder(Config config) {
                this.config = config;
                this.profiler = new Profiler(config);
            }

            public Builder setExporter(Exporter exporter) {
                this.exporter = exporter;
                return this;
            }

            public Builder setScheduler(ProfilingScheduler scheduler) {
                this.scheduler = scheduler;
                return this;
            }

            public Builder setLogger(Logger logger) {
                this.logger = logger;
                return this;
            }

            public Options build() {
                if (this.logger == null) {
                    this.logger = new DefaultLogger(this.config.logLevel, System.err);
                }
                if (this.scheduler == null) {
                    if (this.exporter == null) {
                        this.exporter = new QueuedExporter(this.config, new PyroscopeExporter(this.config, this.logger), this.logger);
                    }
                    this.scheduler = new ContinuousProfilingScheduler(this.config, this.exporter);
                }
                return new Options(this);
            }
        }
    }
}

