/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.config;

import io.pyroscope.http.Format;
import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.api.ConfigurationProvider;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.config.AppName;
import io.pyroscope.javaagent.config.IntervalParser;
import io.pyroscope.javaagent.impl.DefaultConfigurationProvider;
import io.pyroscope.javaagent.impl.DefaultLogger;
import io.pyroscope.org.jetbrains.annotations.NotNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class Config {
    private static final String PYROSCOPE_APPLICATION_NAME_CONFIG = "PYROSCOPE_APPLICATION_NAME";
    private static final String PYROSCOPE_PROFILING_INTERVAL_CONFIG = "PYROSCOPE_PROFILING_INTERVAL";
    private static final String PYROSCOPE_PROFILER_EVENT_CONFIG = "PYROSCOPE_PROFILER_EVENT";
    private static final String PYROSCOPE_PROFILER_ALLOC_CONFIG = "PYROSCOPE_PROFILER_ALLOC";
    private static final String PYROSCOPE_PROFILER_LOCK_CONFIG = "PYROSCOPE_PROFILER_LOCK";
    private static final String PYROSCOPE_UPLOAD_INTERVAL_CONFIG = "PYROSCOPE_UPLOAD_INTERVAL";
    private static final String PYROSCOPE_LOG_LEVEL_CONFIG = "PYROSCOPE_LOG_LEVEL";
    private static final String PYROSCOPE_SERVER_ADDRESS_CONFIG = "PYROSCOPE_SERVER_ADDRESS";
    private static final String PYROSCOPE_ADHOC_SERVER_ADDRESS_CONFIG = "PYROSCOPE_ADHOC_SERVER_ADDRESS";
    private static final String PYROSCOPE_AUTH_TOKEN_CONFIG = "PYROSCOPE_AUTH_TOKEN";
    private static final String PYROSCOPE_FORMAT_CONFIG = "PYROSCOPE_FORMAT";
    private static final String PYROSCOPE_PUSH_QUEUE_CAPACITY_CONFIG = "PYROSCOPE_PUSH_QUEUE_CAPACITY";
    private static final String PYROSCOPE_LABELS = "PYROSCOPE_LABELS";
    private static final String PYROSCOPE_INGEST_MAX_TRIES = "PYROSCOPE_INGEST_MAX_TRIES";
    public static final String DEFAULT_SPY_NAME = "javaspy";
    private static final Duration DEFAULT_PROFILING_INTERVAL = Duration.ofMillis(10L);
    private static final EventType DEFAULT_PROFILER_EVENT = EventType.ITIMER;
    private static final String DEFAULT_PROFILER_ALLOC = "";
    private static final String DEFAULT_PROFILER_LOCK = "";
    private static final Duration DEFAULT_UPLOAD_INTERVAL = Duration.ofSeconds(10L);
    private static final String DEFAULT_SERVER_ADDRESS = "http://localhost:4040";
    private static final Format DEFAULT_FORMAT = Format.COLLAPSED;
    private static final int DEFAULT_PUSH_QUEUE_CAPACITY = 8;
    private static final int DEFAULT_INGEST_MAX_RETRIES = 8;
    private static final String DEFAULT_LABELS = "";
    public final String applicationName;
    public final Duration profilingInterval;
    public final EventType profilingEvent;
    public final String profilingAlloc;
    public final String profilingLock;
    public final Duration uploadInterval;
    public final Logger.Level logLevel;
    public final String serverAddress;
    public final String authToken;
    @Deprecated
    public final String timeseriesName;
    public final AppName timeseries;
    public final Format format;
    public final int pushQueueCapacity;
    public final Map<String, String> labels;
    public final int ingestMaxTries;

    Config(String applicationName, Duration profilingInterval, EventType profilingEvent, String profilingAlloc, String profilingLock, Duration uploadInterval, Logger.Level logLevel, String serverAddress, String authToken, Format format, int pushQueueCapacity, Map<String, String> labels, int ingestMaxRetries) {
        this.applicationName = applicationName;
        this.profilingInterval = profilingInterval;
        this.profilingEvent = profilingEvent;
        this.profilingAlloc = profilingAlloc;
        this.profilingLock = profilingLock;
        this.uploadInterval = uploadInterval;
        this.logLevel = logLevel;
        this.serverAddress = serverAddress;
        this.authToken = authToken;
        this.ingestMaxTries = ingestMaxRetries;
        this.timeseries = this.timeseriesName(AppName.parse(applicationName), profilingEvent, format);
        this.timeseriesName = this.timeseries.toString();
        this.format = format;
        this.pushQueueCapacity = pushQueueCapacity;
        this.labels = Collections.unmodifiableMap(labels);
    }

    public long profilingIntervalInHertz() {
        return Config.durationToHertz(this.profilingInterval);
    }

    public String toString() {
        return "Config{applicationName='" + this.applicationName + '\'' + ", profilingInterval=" + this.profilingInterval + ", profilingEvent=" + (Object)((Object)this.profilingEvent) + ", profilingAlloc='" + this.profilingAlloc + '\'' + ", profilingLock='" + this.profilingLock + '\'' + ", uploadInterval=" + this.uploadInterval + ", logLevel=" + (Object)((Object)this.logLevel) + ", serverAddress='" + this.serverAddress + '\'' + ", authToken='" + this.authToken + '\'' + ", timeseriesName='" + this.timeseriesName + '\'' + ", format=" + (Object)((Object)this.format) + ", pushQueueCapacity=" + this.pushQueueCapacity + '}';
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    private static long durationToHertz(Duration duration) {
        Duration oneSecond = Duration.ofSeconds(1L);
        return oneSecond.toNanos() / duration.toNanos();
    }

    public static Config build() {
        return Config.build(DefaultConfigurationProvider.INSTANCE);
    }

    public static Config build(ConfigurationProvider configurationProvider) {
        return new Config(Config.applicationName(configurationProvider), Config.profilingInterval(configurationProvider), Config.profilingEvent(configurationProvider), Config.profilingAlloc(configurationProvider), Config.profilingLock(configurationProvider), Config.uploadInterval(configurationProvider), Config.logLevel(configurationProvider), Config.serverAddress(configurationProvider), Config.authToken(configurationProvider), Config.format(configurationProvider), Config.pushQueueCapacity(configurationProvider), Config.labels(configurationProvider), Config.ingestMaxRetries(configurationProvider));
    }

    private static String applicationName(ConfigurationProvider configurationProvider) {
        String applicationName = configurationProvider.get(PYROSCOPE_APPLICATION_NAME_CONFIG);
        if (applicationName == null || applicationName.isEmpty()) {
            applicationName = Config.generateApplicationName();
        }
        return applicationName;
    }

    @NotNull
    private static String generateApplicationName() {
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.INFO, "We recommend specifying application name via env variable %s", PYROSCOPE_APPLICATION_NAME_CONFIG);
        UUID uuid = UUID.randomUUID();
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        String random = Base64.getUrlEncoder().withoutPadding().encodeToString(byteBuffer.array());
        String applicationName = "javaspy." + random;
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.INFO, "For now we chose the name for you and it's %s", applicationName);
        return applicationName;
    }

    private static Duration profilingInterval(ConfigurationProvider configurationProvider) {
        String profilingIntervalStr = configurationProvider.get(PYROSCOPE_PROFILING_INTERVAL_CONFIG);
        if (profilingIntervalStr == null || profilingIntervalStr.isEmpty()) {
            return DEFAULT_PROFILING_INTERVAL;
        }
        try {
            return IntervalParser.parse(profilingIntervalStr);
        }
        catch (NumberFormatException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, using %sms", PYROSCOPE_PROFILING_INTERVAL_CONFIG, profilingIntervalStr, DEFAULT_PROFILING_INTERVAL.toMillis());
            return DEFAULT_PROFILING_INTERVAL;
        }
    }

    private AppName timeseriesName(AppName app, EventType eventType, Format format) {
        if (format == Format.JFR) {
            return app;
        }
        return app.newBuilder().setName(app.name + "." + eventType.id).build();
    }

    private static EventType profilingEvent(ConfigurationProvider configurationProvider) {
        String profilingEventStr = configurationProvider.get(PYROSCOPE_PROFILER_EVENT_CONFIG);
        if (profilingEventStr == null || profilingEventStr.isEmpty()) {
            return DEFAULT_PROFILER_EVENT;
        }
        String lowerCaseTrimmed = profilingEventStr.trim().toLowerCase();
        try {
            return EventType.fromId(lowerCaseTrimmed);
        }
        catch (IllegalArgumentException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, using %s", PYROSCOPE_PROFILER_EVENT_CONFIG, profilingEventStr, Config.DEFAULT_PROFILER_EVENT.id);
            return DEFAULT_PROFILER_EVENT;
        }
    }

    private static String profilingAlloc(ConfigurationProvider configurationProvider) {
        String profilingAlloc = configurationProvider.get(PYROSCOPE_PROFILER_ALLOC_CONFIG);
        if (profilingAlloc == null || profilingAlloc.isEmpty()) {
            return "";
        }
        return profilingAlloc.trim().toLowerCase();
    }

    private static String profilingLock(ConfigurationProvider configurationProvider) {
        String profilingLock = configurationProvider.get(PYROSCOPE_PROFILER_LOCK_CONFIG);
        if (profilingLock == null || profilingLock.isEmpty()) {
            return "";
        }
        return profilingLock.trim().toLowerCase();
    }

    private static Duration uploadInterval(ConfigurationProvider configurationProvider) {
        String uploadIntervalStr = configurationProvider.get(PYROSCOPE_UPLOAD_INTERVAL_CONFIG);
        if (uploadIntervalStr == null || uploadIntervalStr.isEmpty()) {
            return DEFAULT_UPLOAD_INTERVAL;
        }
        try {
            return IntervalParser.parse(uploadIntervalStr);
        }
        catch (NumberFormatException e) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Invalid %s value %s, using %s", PYROSCOPE_UPLOAD_INTERVAL_CONFIG, uploadIntervalStr, DEFAULT_UPLOAD_INTERVAL);
            return DEFAULT_UPLOAD_INTERVAL;
        }
    }

    private static Logger.Level logLevel(ConfigurationProvider configurationProvider) {
        String logLevel = configurationProvider.get(PYROSCOPE_LOG_LEVEL_CONFIG);
        if (logLevel == null || logLevel.isEmpty()) {
            return Logger.Level.INFO;
        }
        switch (logLevel.toLowerCase(Locale.ROOT)) {
            case "debug": {
                return Logger.Level.DEBUG;
            }
            case "info": {
                return Logger.Level.INFO;
            }
            case "warn": {
                return Logger.Level.WARN;
            }
            case "error": {
                return Logger.Level.ERROR;
            }
        }
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Unknown log level %s, using INFO", logLevel);
        return Logger.Level.INFO;
    }

    private static String serverAddress(ConfigurationProvider configurationProvider) {
        String serverAddress = configurationProvider.get(PYROSCOPE_ADHOC_SERVER_ADDRESS_CONFIG);
        if (serverAddress == null || serverAddress.isEmpty()) {
            serverAddress = configurationProvider.get(PYROSCOPE_SERVER_ADDRESS_CONFIG);
        }
        if (serverAddress == null || serverAddress.isEmpty()) {
            DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "%s is not defined, using %s", PYROSCOPE_SERVER_ADDRESS_CONFIG, DEFAULT_SERVER_ADDRESS);
            serverAddress = DEFAULT_SERVER_ADDRESS;
        }
        return serverAddress;
    }

    private static String authToken(ConfigurationProvider configurationProvider) {
        return configurationProvider.get(PYROSCOPE_AUTH_TOKEN_CONFIG);
    }

    private static Format format(ConfigurationProvider configurationProvider) {
        String format = configurationProvider.get(PYROSCOPE_FORMAT_CONFIG);
        if (format == null || format.isEmpty()) {
            return DEFAULT_FORMAT;
        }
        switch (format.trim().toLowerCase()) {
            case "collapsed": {
                return Format.COLLAPSED;
            }
            case "jfr": {
                return Format.JFR;
            }
        }
        DefaultLogger.PRECONFIG_LOGGER.log(Logger.Level.WARN, "Unknown format %s, using %s", new Object[]{format, DEFAULT_FORMAT});
        return DEFAULT_FORMAT;
    }

    private static int pushQueueCapacity(ConfigurationProvider configurationProvider) {
        String strPushQueueCapacity = configurationProvider.get(PYROSCOPE_PUSH_QUEUE_CAPACITY_CONFIG);
        if (strPushQueueCapacity == null || strPushQueueCapacity.isEmpty()) {
            return 8;
        }
        try {
            int pushQueueCapacity = Integer.parseInt(strPushQueueCapacity);
            if (pushQueueCapacity <= 0) {
                return 8;
            }
            return pushQueueCapacity;
        }
        catch (NumberFormatException e) {
            return 8;
        }
    }

    public static Map<String, String> labels(ConfigurationProvider configurationProvider) {
        String strLabels = configurationProvider.get(PYROSCOPE_LABELS);
        if (strLabels == null) {
            strLabels = "";
        }
        return AppName.parseLabels(strLabels);
    }

    private static int ingestMaxRetries(ConfigurationProvider configurationProvider) {
        String strIngestMaxRetries = configurationProvider.get(PYROSCOPE_INGEST_MAX_TRIES);
        if (strIngestMaxRetries == null || strIngestMaxRetries.isEmpty()) {
            return 8;
        }
        try {
            return Integer.parseInt(strIngestMaxRetries);
        }
        catch (NumberFormatException e) {
            return 8;
        }
    }

    static /* synthetic */ Duration access$000() {
        return DEFAULT_PROFILING_INTERVAL;
    }

    static /* synthetic */ EventType access$100() {
        return DEFAULT_PROFILER_EVENT;
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_UPLOAD_INTERVAL;
    }

    static /* synthetic */ Format access$300() {
        return DEFAULT_FORMAT;
    }

    public static class Builder {
        public String applicationName = null;
        public Duration profilingInterval = Config.access$000();
        public EventType profilingEvent = Config.access$100();
        public String profilingAlloc = "";
        public String profilingLock = "";
        public Duration uploadInterval = Config.access$200();
        public Logger.Level logLevel = Logger.Level.INFO;
        public String serverAddress = "http://localhost:4040";
        public String authToken = null;
        public Format format = Config.access$300();
        public int pushQueueCapacity = 8;
        public Map<String, String> labels = Collections.emptyMap();
        public int ingestMaxRetries = 8;

        public Builder() {
        }

        public Builder(Config buildUpon) {
            this.applicationName = buildUpon.applicationName;
            this.profilingInterval = buildUpon.profilingInterval;
            this.profilingEvent = buildUpon.profilingEvent;
            this.profilingAlloc = buildUpon.profilingAlloc;
            this.profilingLock = buildUpon.profilingLock;
            this.uploadInterval = buildUpon.uploadInterval;
            this.logLevel = buildUpon.logLevel;
            this.serverAddress = buildUpon.serverAddress;
            this.authToken = buildUpon.authToken;
            this.format = buildUpon.format;
            this.pushQueueCapacity = buildUpon.pushQueueCapacity;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder setProfilingInterval(Duration profilingInterval) {
            this.profilingInterval = profilingInterval;
            return this;
        }

        public Builder setProfilingEvent(EventType profilingEvent) {
            this.profilingEvent = profilingEvent;
            return this;
        }

        public Builder setProfilingAlloc(String profilingAlloc) {
            this.profilingAlloc = profilingAlloc;
            return this;
        }

        public Builder setProfilingLock(String profilingLock) {
            this.profilingLock = profilingLock;
            return this;
        }

        public Builder setUploadInterval(Duration uploadInterval) {
            this.uploadInterval = uploadInterval;
            return this;
        }

        public Builder setLogLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder setAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder setFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder setPushQueueCapacity(int pushQueueCapacity) {
            this.pushQueueCapacity = pushQueueCapacity;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setIngestMaxRetries(int ingestMaxRetries) {
            this.ingestMaxRetries = ingestMaxRetries;
            return this;
        }

        public Config build() {
            if (this.applicationName == null || this.applicationName.isEmpty()) {
                this.applicationName = Config.generateApplicationName();
            }
            return new Config(this.applicationName, this.profilingInterval, this.profilingEvent, this.profilingAlloc, this.profilingLock, this.uploadInterval, this.logLevel, this.serverAddress, this.authToken, this.format, this.pushQueueCapacity, this.labels, this.ingestMaxRetries);
        }
    }
}

