/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.DateUtils;
import io.pyroscope.javaagent.Profiler;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.ProfilingScheduler;
import io.pyroscope.javaagent.config.Config;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ContinuousProfilingScheduler
implements ProfilingScheduler {
    final Config config;
    final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName("PyroscopeProfilingScheduler");
        t.setDaemon(true);
        return t;
    });
    private final Exporter exporter;
    private Instant profilingIntervalStartTime;

    public ContinuousProfilingScheduler(Config config, Exporter exporter) {
        this.config = config;
        this.exporter = exporter;
    }

    @Override
    public void start(Profiler profiler) {
        Duration firstProfilingDuration = this.startFirst(profiler);
        Runnable dumpProfile = () -> {
            Snapshot snapshot = profiler.dump(ContinuousProfilingScheduler.alignProfilingIntervalStartTime(this.profilingIntervalStartTime, this.config.uploadInterval));
            this.profilingIntervalStartTime = Instant.now();
            this.exporter.export(snapshot);
        };
        this.executor.scheduleAtFixedRate(dumpProfile, firstProfilingDuration.toMillis(), this.config.uploadInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private Duration startFirst(Profiler profiler) {
        Instant now = Instant.now();
        Instant prevUploadInterval = DateUtils.truncate(now, this.config.uploadInterval);
        Instant nextUploadInterval = prevUploadInterval.plus(this.config.uploadInterval);
        Duration firstProfilingDuration = Duration.between(now, nextUploadInterval);
        profiler.start();
        this.profilingIntervalStartTime = prevUploadInterval;
        return firstProfilingDuration;
    }

    public static Instant alignProfilingIntervalStartTime(Instant profilingIntervalStartTime, Duration uploadInterval) {
        Duration d2;
        Instant prev = DateUtils.truncate(profilingIntervalStartTime, uploadInterval);
        Instant next = prev.plus(uploadInterval);
        Duration d1 = Duration.between(prev, profilingIntervalStartTime);
        if (d1.compareTo(d2 = Duration.between(profilingIntervalStartTime, next)) < 0) {
            return prev;
        }
        return next;
    }
}

