/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.http.Format;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.javaagent.impl.ExponentialBackoff;
import io.pyroscope.labels.Pyroscope;
import io.pyroscope.okhttp3.HttpUrl;
import io.pyroscope.okhttp3.MediaType;
import io.pyroscope.okhttp3.MultipartBody;
import io.pyroscope.okhttp3.OkHttpClient;
import io.pyroscope.okhttp3.Request;
import io.pyroscope.okhttp3.RequestBody;
import io.pyroscope.okhttp3.Response;
import io.pyroscope.okhttp3.ResponseBody;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Random;

public class PyroscopeExporter
implements Exporter {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final MediaType PROTOBUF = MediaType.parse("application/x-protobuf");
    final Config config;
    final Logger logger;
    final OkHttpClient client;

    public PyroscopeExporter(Config config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.client = new OkHttpClient.Builder().connectTimeout(TIMEOUT).readTimeout(TIMEOUT).callTimeout(TIMEOUT).build();
    }

    @Override
    public void export(Snapshot snapshot) {
        try {
            this.uploadSnapshot(snapshot);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private void uploadSnapshot(Snapshot snapshot) throws InterruptedException {
        HttpUrl url = this.urlForSnapshot(snapshot);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(1000, 30000, new Random());
        boolean success = false;
        int tries = 0;
        while (!success) {
            RequestBody requestBody;
            ++tries;
            if (this.config.format == Format.JFR) {
                byte[] labels = snapshot.labels.toByteArray();
                this.logger.log(Logger.Level.DEBUG, "Upload attempt %d. JFR: %s, labels: %s", tries, snapshot.data.length, labels.length);
                MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                bodyBuilder.addFormDataPart("jfr", "jfr", RequestBody.create(snapshot.data));
                if (labels.length > 0) {
                    bodyBuilder.addFormDataPart("labels", "labels", RequestBody.create(labels, PROTOBUF));
                }
                requestBody = bodyBuilder.build();
            } else {
                this.logger.log(Logger.Level.DEBUG, "Upload attempt %d. collapsed: %s", tries, snapshot.data.length);
                requestBody = RequestBody.create(snapshot.data);
            }
            Request.Builder request = new Request.Builder().post(requestBody).url(url);
            if (this.config.authToken != null && !this.config.authToken.isEmpty()) {
                request.header("Authorization", "Bearer " + this.config.authToken);
            }
            try (Response response = this.client.newCall(request.build()).execute();){
                int status = response.code();
                if (status >= 400) {
                    ResponseBody body = response.body();
                    String responseBody = body == null ? "" : body.string();
                    this.logger.log(Logger.Level.ERROR, "Error uploading snapshot: %s %s", status, responseBody);
                } else {
                    success = true;
                }
            }
            catch (IOException e) {
                this.logger.log(Logger.Level.ERROR, "Error uploading snapshot: %s", e.getMessage());
            }
            if (this.config.ingestMaxTries >= 0 && tries >= this.config.ingestMaxTries) {
                this.logger.log(Logger.Level.ERROR, "Gave up uploading profiling snapshot after %d tries", tries);
                break;
            }
            if (success) continue;
            int backoff = exponentialBackoff.error();
            this.logger.log(Logger.Level.DEBUG, "Backing off for %s ms", backoff);
            Thread.sleep(backoff);
        }
    }

    private HttpUrl urlForSnapshot(Snapshot snapshot) {
        Instant started = snapshot.started;
        Instant finished = started.plus(this.config.uploadInterval);
        HttpUrl.Builder builder = HttpUrl.parse(this.config.serverAddress).newBuilder().addPathSegment("ingest").addQueryParameter("name", this.nameWithStaticLabels()).addQueryParameter("units", snapshot.eventType.units.id).addQueryParameter("aggregationType", snapshot.eventType.aggregationType.id).addQueryParameter("sampleRate", Long.toString(this.config.profilingIntervalInHertz())).addQueryParameter("from", Long.toString(started.getEpochSecond())).addQueryParameter("until", Long.toString(finished.getEpochSecond())).addQueryParameter("spyName", "javaspy");
        if (this.config.format == Format.JFR) {
            builder.addQueryParameter("format", "jfr");
        }
        return builder.build();
    }

    private String nameWithStaticLabels() {
        return this.config.timeseries.newBuilder().addLabels(this.config.labels).addLabels(Pyroscope.getStaticLabels()).build().toString();
    }
}

