/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.Profiler;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.api.ProfilingScheduler;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.kotlin.random.Random;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SamplingProfilingScheduler
implements ProfilingScheduler {
    private final Config config;
    private final Exporter exporter;
    private Logger logger;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName("PyroscopeProfilingScheduler_Sampling");
        t.setDaemon(true);
        return t;
    });
    private ScheduledFuture<?> job;

    public SamplingProfilingScheduler(Config config, Exporter exporter, Logger logger) {
        this.config = config;
        this.exporter = exporter;
        this.logger = logger;
    }

    @Override
    public void start(Profiler profiler) {
        long samplingDurationMillis = this.config.samplingDuration.toMillis();
        Duration uploadInterval = this.config.uploadInterval;
        Runnable task = null != this.config.samplingEventOrder ? () -> {
            for (int i = 0; i < this.config.samplingEventOrder.size(); ++i) {
                EventType t = this.config.samplingEventOrder.get(i);
                Config tmp = this.isolate(t, this.config);
                this.logger.log(Logger.Level.DEBUG, "Config for %s ordinal %d: %s", t.id, i, tmp);
                profiler.setConfig(tmp);
                this.dumpProfile(profiler, samplingDurationMillis, uploadInterval);
            }
        } : () -> this.dumpProfile(profiler, samplingDurationMillis, uploadInterval);
        Duration initialDelay = this.getInitialDelay();
        this.job = this.executor.scheduleAtFixedRate(task, initialDelay.toMillis(), this.config.uploadInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void dumpProfile(Profiler profiler, long samplingDurationMillis, Duration uploadInterval) {
        Instant profilingStartTime = Instant.now();
        try {
            profiler.start();
        }
        catch (Throwable e) {
            this.logger.log(Logger.Level.ERROR, "Error starting profiler %s", e);
            this.stop();
            return;
        }
        try {
            Thread.sleep(samplingDurationMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        profiler.stop();
        Snapshot snapshot = profiler.dumpProfile(profilingStartTime, Instant.now());
        this.exporter.export(snapshot);
    }

    private void stop() {
        if (this.job != null) {
            this.job.cancel(true);
        }
        this.executor.shutdown();
    }

    private Duration getInitialDelay() {
        long uploadIntervalMillis = this.config.uploadInterval.toMillis();
        float randomOffset = Random.Default.nextFloat();
        if ((uploadIntervalMillis = (long)((float)uploadIntervalMillis * randomOffset)) < 2000L) {
            uploadIntervalMillis = 2000L;
        }
        Duration firstProfilingDuration = Duration.ofMillis(uploadIntervalMillis);
        return firstProfilingDuration;
    }

    private Config isolate(EventType type, Config config) {
        Config.Builder b = new Config.Builder(config);
        b.setProfilingEvent(type);
        if (!EventType.ALLOC.equals((Object)type)) {
            b.setProfilingAlloc("");
        }
        if (!EventType.LOCK.equals((Object)type)) {
            b.setProfilingLock("");
        }
        return b.build();
    }
}

