/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.Profiler;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.api.ProfilingScheduler;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.kotlin.random.Random;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ContinuousProfilingScheduler
implements ProfilingScheduler {
    public static final ThreadFactory THREAD_FACTORY = r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName("PyroscopeProfilingScheduler");
        t.setDaemon(true);
        return t;
    };
    private final Config config;
    private ScheduledExecutorService executor;
    private final Exporter exporter;
    private final Logger logger;
    private final Object lock = new Object();
    private Instant profilingIntervalStartTime;
    private ScheduledFuture<?> job;
    private boolean started;
    private Profiler profiler;

    public ContinuousProfilingScheduler(Config config, Exporter exporter, Logger logger) {
        this.config = config;
        this.exporter = exporter;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Profiler profiler) {
        this.logger.log(Logger.Level.DEBUG, "ContinuousProfilingScheduler starting", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            Duration firstProfilingDuration;
            if (this.started) {
                throw new IllegalStateException("already started");
            }
            try {
                firstProfilingDuration = this.startFirst(profiler);
            }
            catch (Throwable throwable) {
                this.stopSchedulerLocked();
                throw new IllegalStateException(throwable);
            }
            this.profiler = profiler;
            this.executor = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
            this.job = this.executor.scheduleAtFixedRate(this::schedulerTick, firstProfilingDuration.toMillis(), this.config.uploadInterval.toMillis(), TimeUnit.MILLISECONDS);
            this.started = true;
            this.logger.log(Logger.Level.DEBUG, "ContinuousProfilingScheduler started", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ScheduledExecutorService svc = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.stopSchedulerLocked();
                }
                finally {
                    svc = this.executor;
                    this.executor = null;
                }
            }
            this.logger.log(Logger.Level.DEBUG, "ContinuousProfilingScheduler stopped", new Object[0]);
        }
        catch (Throwable throwable) {
            ContinuousProfilingScheduler.awaitTermination(svc);
            throw throwable;
        }
        ContinuousProfilingScheduler.awaitTermination(svc);
    }

    private static void awaitTermination(ScheduledExecutorService svc) {
        try {
            boolean terminated = svc.awaitTermination(10L, TimeUnit.SECONDS);
            if (!terminated) {
                throw new IllegalStateException("failed to terminate scheduler's executor");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("failed to terminate scheduler's executor", e);
        }
    }

    private void stopSchedulerLocked() {
        if (!this.started) {
            return;
        }
        this.logger.log(Logger.Level.DEBUG, "ContinuousProfilingScheduler stopping", new Object[0]);
        try {
            this.profiler.stop();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
        finally {
            this.job.cancel(true);
            this.executor.shutdown();
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulerTick() {
        Object object = this.lock;
        synchronized (object) {
            Snapshot snapshot;
            Instant now;
            if (!this.started) {
                return;
            }
            this.logger.log(Logger.Level.DEBUG, "ContinuousProfilingScheduler#schedulerTick", new Object[0]);
            try {
                this.profiler.stop();
                now = Instant.now();
                snapshot = this.profiler.dumpProfile(this.profilingIntervalStartTime, now);
                this.profiler.start();
            }
            catch (Throwable throwable) {
                this.logger.log(Logger.Level.ERROR, "Error dumping profiler %s", throwable);
                this.stopSchedulerLocked();
                return;
            }
            this.profilingIntervalStartTime = now;
            this.exporter.export(snapshot);
        }
    }

    private Duration startFirst(Profiler profiler) {
        Instant now = Instant.now();
        long uploadIntervalMillis = this.config.uploadInterval.toMillis();
        float randomOffset = Random.Default.nextFloat();
        if ((uploadIntervalMillis = (long)((float)uploadIntervalMillis * randomOffset)) < 2000L) {
            uploadIntervalMillis = 2000L;
        }
        Duration firstProfilingDuration = Duration.ofMillis(uploadIntervalMillis);
        profiler.start();
        this.profilingIntervalStartTime = now;
        return firstProfilingDuration;
    }
}

