/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.OverfillQueue;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.api.Exporter;
import io.pyroscope.javaagent.api.Logger;
import io.pyroscope.javaagent.config.Config;

public class QueuedExporter
implements Exporter {
    final Exporter impl;
    final Logger logger;
    private final Thread thread;
    private final OverfillQueue<Snapshot> queue;

    public QueuedExporter(Config config, Exporter impl, Logger logger) {
        this.impl = impl;
        this.logger = logger;
        this.thread = new Thread(this::exportLoop);
        this.thread.setDaemon(true);
        this.queue = new OverfillQueue(config.pushQueueCapacity);
        this.thread.start();
    }

    private void exportLoop() {
        this.logger.log(Logger.Level.DEBUG, "Uploading started", new Object[0]);
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Snapshot snapshot = this.queue.take();
                this.impl.export(snapshot);
            }
        }
        catch (InterruptedException e) {
            this.logger.log(Logger.Level.DEBUG, "Uploading interrupted", new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void export(Snapshot snapshot) {
        try {
            this.queue.put(snapshot);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void stop() {
        try {
            this.thread.interrupt();
        }
        catch (Exception e) {
            this.logger.log(Logger.Level.ERROR, "Error stopping thread", e);
        }
    }
}

