/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent.impl;

import io.pyroscope.javaagent.api.Logger;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DefaultLogger
implements Logger {
    public static final Logger PRECONFIG_LOGGER = new DefaultLogger(Logger.Level.DEBUG, System.err);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Logger.Level logLevel;
    private final PrintStream out;

    public DefaultLogger(Logger.Level logLevel, PrintStream out) {
        this.logLevel = logLevel;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Logger.Level logLevel, String msg, Object ... args) {
        String date;
        if (logLevel.level < this.logLevel.level) {
            return;
        }
        DefaultLogger defaultLogger = this;
        synchronized (defaultLogger) {
            date = DATE_FORMAT.format(System.currentTimeMillis());
        }
        String formattedMsg = msg == null ? "null" : (args == null || args.length == 0 ? msg : String.format(msg, args));
        this.out.printf("%s [%s] %s%n", new Object[]{date, logLevel, formattedMsg});
    }
}

