/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.labels;

import io.pyroscope.labels.LabelsSet;
import io.pyroscope.labels.Ref;
import io.pyroscope.labels.RefCounted;
import io.pyroscope.one.profiler.AsyncProfiler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ScopedContext
implements AutoCloseable {
    static final ThreadLocal<Context> context = ThreadLocal.withInitial(() -> new Context(0L, Collections.emptyMap()));
    final Context previous = context.get();
    final Context current;
    final Ref<Map<Ref<String>, Ref<String>>> currentRef;
    boolean closed = false;

    public ScopedContext(LabelsSet labels) {
        HashMap<Ref<String>, Ref<String>> nextContext = new HashMap<Ref<String>, Ref<String>>(this.previous.labels.size() + labels.args.length / 2);
        for (Map.Entry<Ref<String>, Ref<String>> it : this.previous.labels.entrySet()) {
            Ref<String> key = it.getKey();
            Ref<String> value = it.getValue();
            ScopedContext.assertAlive(key.refCount.get());
            ScopedContext.assertAlive(value.refCount.get());
            ScopedContext.assertAlive(key.refCount.incrementAndGet());
            ScopedContext.assertAlive(value.refCount.incrementAndGet());
            nextContext.put(key, value);
        }
        for (int i = 0; i < labels.args.length; i += 2) {
            Ref<String> v;
            String ks = labels.args[i].toString();
            String vs = labels.args[i + 1].toString();
            Ref<String> k = RefCounted.strings.acquireRef(ks);
            Ref<String> prev = nextContext.put(k, v = RefCounted.strings.acquireRef(vs));
            if (prev == null) continue;
            ScopedContext.assertAlive(k.refCount.decrementAndGet());
            ScopedContext.assertAlive(prev.refCount.decrementAndGet());
        }
        boolean[] fresh = new boolean[1];
        this.currentRef = RefCounted.contexts.acquireRef(nextContext, fresh);
        if (!fresh[0]) {
            for (Map.Entry it : nextContext.entrySet()) {
                ((Ref)it.getKey()).refCount.decrementAndGet();
                ((Ref)it.getValue()).refCount.decrementAndGet();
            }
        }
        AsyncProfiler.getInstance().setContextId(this.currentRef.id);
        this.current = new Context(this.currentRef.id, nextContext);
        context.set(this.current);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.currentRef.refCount.decrementAndGet();
        context.set(this.previous);
        AsyncProfiler.getInstance().setContextId(this.previous.id);
    }

    public void forEachLabel(BiConsumer<String, String> labelConsumer) {
        for (Map.Entry<Ref<String>, Ref<String>> it : this.current.labels.entrySet()) {
            labelConsumer.accept((String)it.getKey().val, (String)it.getValue().val);
        }
    }

    static void assertAlive(long counter) {
        if (counter <= 0L) {
            throw new AssertionError();
        }
    }

    static class Context {
        public final Long id;
        public final Map<Ref<String>, Ref<String>> labels;

        public Context(Long id, Map<Ref<String>, Ref<String>> labels) {
            this.id = id;
            this.labels = labels;
        }
    }
}

