/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope;

import io.pyroscope.vendor.one.profiler.AsyncProfiler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class PyroscopeAsyncProfiler {
    static final String libraryPath;

    public static AsyncProfiler getAsyncProfiler() {
        return AsyncProfiler.getInstance(libraryPath);
    }

    private static String deployLibrary() throws IOException {
        String fileName = PyroscopeAsyncProfiler.libraryFileName();
        String userName = System.getProperty("user.name");
        Path targetDir = Files.createTempDirectory(userName + "-pyroscope", new FileAttribute[0]);
        try (InputStream is = PyroscopeAsyncProfiler.loadResource(fileName);){
            Path target = targetDir.resolve(PyroscopeAsyncProfiler.targetLibraryFileName(fileName)).toAbsolutePath();
            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
            String string = target.toString();
            return string;
        }
    }

    private static InputStream loadResource(String fileName) throws IOException {
        InputStream res = PyroscopeAsyncProfiler.class.getResourceAsStream("/" + fileName);
        if (res != null) {
            return res;
        }
        Path filePath = Paths.get("build", "async-profiler", "native", fileName);
        return Files.newInputStream(filePath, new OpenOption[0]);
    }

    private static String libraryFileName() {
        String osProperty = System.getProperty("os.name");
        String archProperty = System.getProperty("os.arch");
        switch (osProperty) {
            case "Linux": {
                String arch;
                switch (archProperty) {
                    case "amd64": {
                        arch = "x64";
                        break;
                    }
                    case "aarch64": {
                        arch = "arm64";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported architecture " + archProperty);
                    }
                }
                return "libasyncProfiler-linux-" + arch + ".so";
            }
            case "Mac OS X": {
                switch (archProperty) {
                    case "x86_64": 
                    case "aarch64": {
                        return "libasyncProfiler-macos.so";
                    }
                }
                throw new RuntimeException("Unsupported architecture " + archProperty);
            }
        }
        throw new RuntimeException("Unsupported OS " + osProperty);
    }

    private static String targetLibraryFileName(String libraryFileName) throws IOException {
        String checksum;
        if (!libraryFileName.endsWith(".so")) {
            throw new IllegalArgumentException("Incorrect library file name: " + libraryFileName);
        }
        String checksumFileName = libraryFileName + ".sha1";
        try (InputStream is = PyroscopeAsyncProfiler.loadResource(checksumFileName);){
            byte[] buf = new byte[40];
            int bufLen = is.read(buf);
            if (bufLen <= 0) {
                throw new IOException("checksum read fail");
            }
            checksum = new String(buf, 0, bufLen, StandardCharsets.UTF_8);
        }
        return libraryFileName.substring(0, libraryFileName.length() - 3) + "-" + checksum + ".so";
    }

    static {
        try {
            libraryPath = PyroscopeAsyncProfiler.deployLibrary();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

