/*
 * Decompiled with CFR 0.152.
 */
package io.pyroscope.javaagent;

import io.pyroscope.http.Format;
import io.pyroscope.javaagent.CurrentPidProvider;
import io.pyroscope.javaagent.EventType;
import io.pyroscope.javaagent.ProfilerDelegate;
import io.pyroscope.javaagent.Snapshot;
import io.pyroscope.javaagent.config.Config;
import io.pyroscope.labels.v2.Pyroscope;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class JFRJCMDProfilerDelegate
implements ProfilerDelegate {
    private static final String RECORDING_NAME = "pyroscope";
    private static final String JFR_SETTINGS_RESOURCE = "/jfr/pyroscope.jfc";
    private static final String OS_NAME = "os.name";
    private Config config;
    private File tempJFRFile;
    private Path jcmdBin;
    private Path jfrSettingsPath;

    public JFRJCMDProfilerDelegate(Config config) {
        this.setConfig(config);
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
        this.jcmdBin = JFRJCMDProfilerDelegate.findJcmdBin();
        this.jfrSettingsPath = JFRJCMDProfilerDelegate.findJfrSettingsPath(config);
        try {
            this.tempJFRFile = File.createTempFile(RECORDING_NAME, ".jfr");
            this.tempJFRFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void start() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.jcmdBin.toString());
        cmdLine.add(String.valueOf(CurrentPidProvider.getCurrentProcessId()));
        cmdLine.add("JFR.start");
        cmdLine.add("name=pyroscope");
        cmdLine.add("filename=" + this.tempJFRFile.getAbsolutePath());
        cmdLine.add("settings=" + this.jfrSettingsPath);
        JFRJCMDProfilerDelegate.executeCmd(cmdLine);
    }

    @Override
    public synchronized void stop() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.jcmdBin.toString());
        cmdLine.add(String.valueOf(CurrentPidProvider.getCurrentProcessId()));
        cmdLine.add("JFR.stop");
        cmdLine.add("name=pyroscope");
        JFRJCMDProfilerDelegate.executeCmd(cmdLine);
    }

    @Override
    public synchronized Snapshot dumpProfile(Instant started, Instant ended) {
        return this.dumpImpl(started, ended);
    }

    private Snapshot dumpImpl(Instant started, Instant ended) {
        if (this.config.gcBeforeDump) {
            System.gc();
        }
        try {
            byte[] data = Files.readAllBytes(this.tempJFRFile.toPath());
            return new Snapshot(Format.JFR, EventType.CPU, started, ended, data, Pyroscope.LabelsWrapper.dump());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Path findJcmdBin() {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        String jcmd = JFRJCMDProfilerDelegate.jcmdExecutable();
        Path jcmdBin = javaHome.resolve("bin").resolve(jcmd);
        if (!Files.isExecutable(jcmdBin) && !Files.isExecutable(jcmdBin = javaHome.getParent().resolve("bin").resolve(jcmd))) {
            throw new RuntimeException("cannot find executable jcmd in Java home");
        }
        return jcmdBin;
    }

    private static String jcmdExecutable() {
        String jcmd = "jcmd";
        if (JFRJCMDProfilerDelegate.isWindowsOS()) {
            jcmd = "jcmd.exe";
        }
        return jcmd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path findJfrSettingsPath(Config config) {
        if (config.jfrProfilerSettings != null) {
            return Paths.get(config.jfrProfilerSettings, new String[0]);
        }
        try (InputStream inputStream2 = JFRJCMDProfilerDelegate.class.getResourceAsStream(JFR_SETTINGS_RESOURCE);){
            Path jfrSettingsPath = Files.createTempFile(RECORDING_NAME, ".jfc", new FileAttribute[0]);
            Files.copy(inputStream2, jfrSettingsPath, StandardCopyOption.REPLACE_EXISTING);
            Path path = jfrSettingsPath;
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("unable to load %s from classpath", JFR_SETTINGS_RESOURCE), e);
        }
    }

    private static boolean isWindowsOS() {
        String osName = System.getProperty(OS_NAME);
        return osName.contains("Windows");
    }

    private static void executeCmd(List<String> cmdLine) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine);
            Process process = processBuilder.redirectErrorStream(true).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String processOutput = new BufferedReader(new InputStreamReader(process.getInputStream())).lines().collect(Collectors.joining("\n"));
                throw new RuntimeException(String.format("Invalid exit code %s, process output %s", exitCode, processOutput));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(String.format("failed to start process: %s", cmdLine), e);
        }
    }
}

